/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.ui.component;

import com.pkc.geom.RectObject;
import com.pkc.util.Tools;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class ContainerPreviewPanel
extends JPanel
implements ActionListener {
    public static final Color3f EMISSIVE_COLOR = new Color3f();
    public static final Color3f DIFFUSE_COLOR = new Color3f();
    public static final Color3f SPECULAR_COLOR = new Color3f();
    protected List rectObjects = new ArrayList(0);
    protected int displayCount;
    protected float scale;
    BranchGroup objRoot = new BranchGroup();
    BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), 10000.0);
    Canvas3D canvas3D = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
    SimpleUniverse simpleUniverse = new SimpleUniverse(this.canvas3D);
    JButton start = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("images/start.gif")));
    JButton prev = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("images/prev.gif")));
    JButton next = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("images/next.gif")));
    JButton end = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("images/end.gif")));
    RectObject container;
    Transform3D rotate;
    TransformGroup objRotate;

    public ContainerPreviewPanel(float scale) {
        super(new BorderLayout());
        this.scale = scale;
        this.add((Component)this.canvas3D, "Center");
        this.start.addActionListener(this);
        this.prev.addActionListener(this);
        this.next.addActionListener(this);
        this.end.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.start);
        buttonPanel.add(this.prev);
        buttonPanel.add(this.next);
        buttonPanel.add(this.end);
        this.add((Component)buttonPanel, "South");
        this.simpleUniverse.getViewingPlatform().setNominalViewingTransform();
        this.objRoot.setCapability(17);
        this.simpleUniverse.addBranchGraph(this.objRoot);
        this.enableControls();
    }

    public void initialize(RectObject container, List rectObjects) {
        this.rectObjects = rectObjects;
        this.container = container;
        this.displayCount = rectObjects.size();
        this.createSceneGraph();
        this.objRoot.compile();
        this.simpleUniverse.addBranchGraph(this.objRoot);
        this.enableControls();
    }

    public Node genNode(RectObject object, float scale) {
        Vector3d translation = new Vector3d((double)((float)object.getCenterCoord(0) / scale), (double)((float)object.getCenterCoord(2) / scale), (double)((float)object.getCenterCoord(1) / scale));
        Transform3D moveTransform = new Transform3D();
        moveTransform.setTranslation(translation);
        TransformGroup td = new TransformGroup(moveTransform);
        Color cl = new Color(1, 1, 1);
        cl = (Color)object.getProperty("Color");
        Appearance app = new Appearance();
        Color3f c3f = new Color3f((float)Tools.random.nextInt(), (float)Tools.random.nextInt(), (float)Tools.random.nextInt());
        c3f.set(cl);
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.setTransparencyMode(1);
        ta.setTransparency(0.1f);
        app.setColoringAttributes(new ColoringAttributes(c3f, 1));
        td.addChild((Node)new Box((float)object.getDim(0) / (2.0f * scale), (float)object.getDim(2) / (2.0f * scale), (float)object.getDim(1) / (2.0f * scale), 47, app));
        return td;
    }

    public void createSceneGraph() {
        this.simpleUniverse.getLocale().removeBranchGraph(this.objRoot);
        this.objRoot = new BranchGroup();
        this.objRoot.setCapability(17);
        if (this.rotate == null) {
            this.rotate = new Transform3D();
            Transform3D tempRotate = new Transform3D();
            this.rotate.rotX(0.7853981633974483);
            tempRotate.rotY(0.6283185307179586);
            this.rotate.mul(tempRotate);
        }
        this.objRotate = new TransformGroup(this.rotate);
        this.objRotate.setCapability(17);
        this.objRotate.setCapability(18);
        int i = 0;
        while (i < this.displayCount) {
            this.objRotate.addChild(this.genNode((RectObject)this.rectObjects.get(i), this.scale));
            ++i;
        }
        Vector3d translation = new Vector3d((double)((float)this.container.getCenterCoord(0) / this.scale), (double)((float)this.container.getCenterCoord(2) / this.scale), (double)((float)this.container.getCenterCoord(1) / this.scale));
        Transform3D moveTransform = new Transform3D();
        moveTransform.setTranslation(translation);
        TransformGroup td = new TransformGroup(moveTransform);
        Appearance app = new Appearance();
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setPolygonMode(1);
        app.setPolygonAttributes(polygonAttributes);
        td.addChild((Node)new Box((float)this.container.getDim(0) / (2.0f * this.scale), (float)this.container.getDim(2) / (2.0f * this.scale), (float)this.container.getDim(1) / (2.0f * this.scale), 47, app));
        this.objRotate.addChild((Node)td);
        this.objRoot.addChild((Node)this.objRotate);
        MouseRotate mouseRotate = new MouseRotate((Component)this.canvas3D);
        mouseRotate.setTransformGroup(this.objRotate);
        mouseRotate.setSchedulingBounds((Bounds)this.boundingSphere);
        mouseRotate.setFactor(0.02, 0.02);
        this.objRoot.addChild((Node)mouseRotate);
        AmbientLight lightA = new AmbientLight();
        DirectionalLight lightD = new DirectionalLight();
        lightA.setInfluencingBounds((Bounds)this.boundingSphere);
        this.objRoot.addChild((Node)lightA);
        lightD.setInfluencingBounds((Bounds)this.boundingSphere);
        this.objRoot.addChild((Node)lightD);
    }

    protected void enableControls() {
        this.start.setEnabled(this.displayCount > 0);
        this.prev.setEnabled(this.displayCount > 0);
        this.next.setEnabled(this.displayCount < this.rectObjects.size());
        this.end.setEnabled(this.displayCount < this.rectObjects.size());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.start) {
            this.displayCount = 0;
        } else if (e.getSource() == this.prev) {
            if (this.displayCount >= 1) {
                --this.displayCount;
            }
        } else if (e.getSource() == this.next) {
            if (this.displayCount < this.rectObjects.size()) {
                ++this.displayCount;
            }
        } else if (e.getSource() == this.end) {
            this.displayCount = this.rectObjects.size();
        }
        this.objRotate.getTransform(this.rotate);
        this.createSceneGraph();
        this.objRoot.compile();
        this.simpleUniverse.addBranchGraph(this.objRoot);
        this.enableControls();
    }
}

