/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.ui;

import com.pkc.ui.component.StatusBar;
import com.pkc.ui.dialogs.HelpDialog;
import com.pkc.ui.dialogs.NewDialog;
import com.pkc.ui.dialogs.PackDialog;
import com.pkc.ui.dialogs.SettingsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MainDialog
extends JFrame
implements ActionListener {
    PackDialog packDialog;
    JPanel content = new JPanel(new GridLayout(1, 1));

    public MainDialog(String string) {
        super(string);
        this.setMenuBar(this.loadMenu("config/Menu_en"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.content, "Center");
        this.getContentPane().add((Component)new StatusBar(), "South");
        this.pack();
        this.setSize(800, 600);
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    private MenuBar loadMenu(String string) {
        MenuBar menuBar = new MenuBar();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        String[] stringArray = resourceBundle.getString("MenuBar").split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            Menu menu = new Menu(stringArray[i]);
            String[] stringArray2 = resourceBundle.getString(stringArray[i]).split(";");
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].equals("")) {
                    menu.addSeparator();
                    continue;
                }
                String[] stringArray3 = stringArray2[j].split("->");
                MenuItem menuItem = new MenuItem(stringArray3[0]);
                menuItem.setActionCommand(stringArray3[1]);
                menuItem.addActionListener(this);
                menu.add(menuItem);
            }
            menuBar.add(menu);
        }
        return menuBar;
    }

    public void newPacking(PackDialog packDialog) {
        this.packDialog = packDialog;
        this.content.removeAll();
        this.content.add(packDialog);
        this.setTitle("Packer v0.04 - {" + packDialog + "}");
        this.setSize(this.getWidth() - 1, this.getHeight());
        this.setSize(this.getWidth() + 1, this.getHeight());
        packDialog.setDividerLocation(this.content.getWidth() / 2);
        packDialog.leftPanel.setDividerLocation(this.content.getHeight() / 3);
        packDialog.rightPanel.setDividerLocation(this.content.getHeight() / 2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("new")) {
            new NewDialog();
        } else if (actionEvent.getActionCommand().equals("options")) {
            new SettingsDialog();
        } else if (actionEvent.getActionCommand().equals("about")) {
            new HelpDialog();
        } else if (actionEvent.getActionCommand().equals("start")) {
            this.packDialog.startPacking();
        } else if (actionEvent.getActionCommand().equals("stop")) {
            this.packDialog.stopPacking();
        } else if (actionEvent.getActionCommand().equals("exit")) {
            System.exit(0);
        }
    }
}

