/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.settings;

import com.pkc.ui.MainDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public class Settings {
    public static final String BANNER = "Packer v0.04";
    public static final int STOP_AFTER_GIVEN_TIME = 0;
    public static final int STOP_AFTER_GIVEN_ITERATION_COUNT = 1;
    public static int stopCondition;
    public static int stopTime;
    public static int stopIterations;
    public static MainDialog mainDialog;
    public static int byDimmension;
    public static int byVolume;
    public static int byRatio;
    public static int byMinMax;
    public static int byRandom;
    public static Locale locale;
    public static List dataSources;
    public static ResourceBundle resources;
    private static Properties configuration;
    public static List problems;

    public static void apply() {
        resources = ResourceBundle.getBundle("config/Packer", locale);
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            SwingUtilities.updateComponentTreeUI(frameArray[i]);
            Window[] windowArray = frameArray[i].getOwnedWindows();
            for (int j = 0; j < windowArray.length; ++j) {
                SwingUtilities.updateComponentTreeUI(windowArray[j]);
            }
        }
        Settings.save();
    }

    public static String getString(String string) {
        return configuration.getProperty(string);
    }

    public static void setString(String string, String string2) {
        configuration.setProperty(string, string2);
    }

    public static int getInt(String string) {
        return Integer.parseInt(configuration.getProperty(string));
    }

    public static void setInt(String string, int n) {
        configuration.setProperty(string, String.valueOf(n));
    }

    public static void save() {
        Settings.setString("language", locale.getLanguage());
        Settings.setString("country", locale.getCountry());
        Settings.setInt("stopCondition", stopCondition);
        Settings.setInt("stopTime", stopTime);
        Settings.setInt("stopIterations", stopIterations);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("config/Settings.properties");
            configuration.store(fileOutputStream, "Packer configuration file");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error while saving configuration: " + exception);
        }
    }

    static {
        dataSources = new ArrayList(0);
        configuration = new Properties();
        problems = new ArrayList();
        try {
            configuration.load(Settings.class.getClassLoader().getResourceAsStream("config/Settings.properties"));
        }
        catch (Exception exception) {
            System.out.println("Error while loading configuration: " + exception);
        }
        stopCondition = Settings.getInt("stopCondition");
        stopTime = Settings.getInt("stopTime");
        stopIterations = Settings.getInt("stopIterations");
        locale = new Locale(configuration.getProperty("language"), configuration.getProperty("country"));
        Settings.apply();
    }
}

