/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.packing;

import com.pkc.data.PackingDataSource;
import com.pkc.geom.NDPoint;
import com.pkc.geom.RectObject;
import com.pkc.packing.ChooseObjectCriterion;
import com.pkc.packing.EqualLayerChooser;
import com.pkc.packing.LayerChooser;
import com.pkc.packing.LayerChooserByObjDims;
import com.pkc.packing.ObjectChooser;
import com.pkc.util.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PackingAlgorithm {
    int dimension;
    long objectsVolume;
    NDPoint[] points;
    PackingDataSource.PackingProblem problem;
    long bestValue;
    List bestList;
    RectObject[] packedObjects;
    int packedObjectCount;
    RectObject[] unpackedObjects;
    int unpackedObjectCount;
    ObjectChooser objectChooser;
    RectObject container;
    List currentBestList;
    List currentBestLeft;
    boolean[] objectClassFits;
    int[] objectClassMinDim;
    float[] objectClassRatio;
    public ChooseObjectCriterion[] chooseObjectByGivenDimCriterion = new ChooseObjectCriterion[]{new ChooseObjectByGivenDimCriterion()};
    public ChooseObjectCriterion[] chooseLargestVolumeObjectCriterion = new ChooseObjectCriterion[]{new ChooseLargestVolumeObjectCriterion()};
    public ChooseObjectCriterion[] chooseMaxRatioObjectCriterion = new ChooseObjectCriterion[]{new ChooseMaxRatioObjectCriterion()};
    public ChooseObjectCriterion[] chooseMaxMinObjectCriterion = new ChooseObjectCriterion[]{new ChooseMaxMinObjectCriterion()};
    public ChooseObjectCriterion[] chooseRandomObjectCriterion = new ChooseObjectCriterion[]{new ChooseRandomObjectCriterion()};
    public EqualLayerChooser equalLayerChooser;
    public LayerChooserByObjDims layerChooserByObjDims;
    public ChooseObjectCriterion[] criterionsMixture;

    public PackingAlgorithm(PackingDataSource.PackingProblem packingProblem, int[] nArray) {
        int n;
        this.problem = packingProblem;
        this.objectClassFits = new boolean[packingProblem.getClassCount()];
        this.objectClassMinDim = new int[packingProblem.getClassCount()];
        this.objectClassRatio = new float[packingProblem.getClassCount()];
        this.dimension = packingProblem.getDimension();
        this.container = ((RectObject)packingProblem.getContainers().get(0)).copy();
        this.points = new NDPoint[2 * packingProblem.getObjects().size() + 1];
        for (n = 0; n < this.points.length; ++n) {
            this.points[n] = new NDPoint(packingProblem.getDimension());
        }
        this.objectChooser = new ObjectChooser(packingProblem.getObjects());
        this.bestList = new ArrayList(packingProblem.getObjects().size());
        this.packedObjects = new RectObject[packingProblem.getObjects().size()];
        this.unpackedObjects = new RectObject[packingProblem.getObjects().size()];
        this.currentBestList = new ArrayList(packingProblem.getObjects().size());
        this.currentBestLeft = new ArrayList(packingProblem.getObjects().size());
        for (n = 0; n < packingProblem.getObjects().size(); ++n) {
            RectObject rectObject = (RectObject)packingProblem.getObjects().get(n);
            this.objectsVolume += rectObject.getVolume();
            this.objectClassMinDim[rectObject.getObjectClass()] = rectObject.getMinDim();
            this.objectClassRatio[rectObject.getObjectClass()] = rectObject.getRatio();
        }
        this.equalLayerChooser = new EqualLayerChooser(this.container, 0);
        this.objectChooser.reset(0);
        this.layerChooserByObjDims = new LayerChooserByObjDims(this.objectChooser, this.container, 0, 1);
        this.criterionsMixture = new ChooseObjectCriterion[5];
        this.criterionsMixture[0] = this.chooseObjectByGivenDimCriterion[0];
        this.criterionsMixture[1] = this.chooseLargestVolumeObjectCriterion[0];
        this.criterionsMixture[2] = this.chooseMaxRatioObjectCriterion[0];
        this.criterionsMixture[3] = this.chooseMaxMinObjectCriterion[0];
        this.criterionsMixture[4] = this.chooseRandomObjectCriterion[0];
        for (n = 0; n < this.criterionsMixture.length; ++n) {
            this.criterionsMixture[n].setProbability(nArray[n]);
        }
    }

    public PackingDataSource.PackingProblem getProblem() {
        return this.problem;
    }

    public long getObjectsVolume() {
        return this.objectsVolume;
    }

    public List getBestPacking() {
        return this.bestList;
    }

    public long getBestValue() {
        return this.bestValue;
    }

    void copyObjectList(List list, int n, RectObject[] rectObjectArray) {
        list.clear();
        for (int i = 0; i < n; ++i) {
            list.add(rectObjectArray[i].copy());
        }
    }

    public long packGreedy(ChooseObjectCriterion[] chooseObjectCriterionArray) {
        this.objectChooser.setCriterions(chooseObjectCriterionArray);
        return this.packObjects(0L, this.container.getStart(0), 0, this.container, this.container.getDim(0));
    }

    public int getObjectsSize(RectObject rectObject, List list, int n) {
        int n2 = rectObject.getStart(n);
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            RectObject rectObject2 = (RectObject)list.get(i);
            if (rectObject2.getEnd(n) <= n2) continue;
            n2 = rectObject2.getEnd(n);
        }
        return n2;
    }

    long packObjects(long l, int n, int n2, RectObject rectObject, int n3) {
        this.packedObjectCount = n2;
        this.unpackedObjectCount = 0;
        this.points[0].set(rectObject.getStart());
        this.points[0].setCoord(0, n);
        for (int i = 0; i < n2; ++i) {
            this.packedObjects[i] = this.objectChooser.objects[i];
        }
        long l2 = this.pack(l, rectObject, n2, this.objectChooser, 1, n3);
        if (l2 > this.bestValue) {
            this.bestValue = l2;
            this.copyObjectList(this.bestList, this.packedObjectCount, this.packedObjects);
        }
        return l2;
    }

    public long packUsingLayers(LayerChooser layerChooser, int n) {
        int n2;
        long l = 0L;
        long l2 = 0L;
        int n3 = this.container.getStart(0);
        int n4 = 0;
        int n5 = this.container.getDim(0);
        this.objectChooser.reset(n4);
        this.currentBestList.clear();
        this.currentBestLeft.clear();
        int n6 = 0;
        while ((n2 = layerChooser.nextDim(this.objectChooser)) != -1) {
            double d = 0.0;
            do {
                int n7;
                this.container.setDim(0, n2);
                this.objectChooser.setCriterions(this.chooseObjectByGivenDimCriterion);
                long l3 = this.packObjects(l2, n3, n4, this.container, n2 - n3);
                double d2 = (double)l3 / (double)this.container.getVolume();
                if (d2 > d) {
                    l = l3;
                    d = d2;
                    this.copyObjectList(this.currentBestList, this.packedObjectCount, this.packedObjects);
                    this.currentBestLeft.clear();
                    for (n7 = 0; n7 < this.unpackedObjectCount; ++n7) {
                        this.currentBestLeft.add(this.unpackedObjects[n7]);
                    }
                }
                this.objectChooser.setCriterions(this.chooseLargestVolumeObjectCriterion);
                l3 = this.packObjects(l2, n3, n4, this.container, n2 - n3);
                d2 = (double)l3 / (double)this.container.getVolume();
                if (d2 > d) {
                    l = l3;
                    d = d2;
                    this.copyObjectList(this.currentBestList, this.packedObjectCount, this.packedObjects);
                    this.currentBestLeft.clear();
                    for (n7 = 0; n7 < this.unpackedObjectCount; ++n7) {
                        this.currentBestLeft.add(this.unpackedObjects[n7]);
                    }
                }
                this.objectChooser.setCriterions(this.chooseMaxRatioObjectCriterion);
                l3 = this.packObjects(l2, n3, n4, this.container, n2 - n3);
                d2 = (double)l3 / (double)this.container.getVolume();
                if (d2 > d) {
                    l = l3;
                    d = d2;
                    this.copyObjectList(this.currentBestList, this.packedObjectCount, this.packedObjects);
                    this.currentBestLeft.clear();
                    for (n7 = 0; n7 < this.unpackedObjectCount; ++n7) {
                        this.currentBestLeft.add(this.unpackedObjects[n7]);
                    }
                }
                this.objectChooser.setCriterions(this.chooseMaxMinObjectCriterion);
                l3 = this.packObjects(l2, n3, n4, this.container, n2 - n3);
                d2 = (double)l3 / (double)this.container.getVolume();
                if (d2 > d) {
                    l = l3;
                    d = d2;
                    this.copyObjectList(this.currentBestList, this.packedObjectCount, this.packedObjects);
                    this.currentBestLeft.clear();
                    for (n7 = 0; n7 < this.unpackedObjectCount; ++n7) {
                        this.currentBestLeft.add(this.unpackedObjects[n7]);
                    }
                }
                this.objectChooser.setCriterions(this.criterionsMixture);
                for (n7 = 0; n7 < n; ++n7) {
                    l3 = this.packObjects(l2, n3, n4, this.container, n2 - n3);
                    d2 = (double)l3 / (double)this.container.getVolume();
                    if (!(d2 > d)) continue;
                    l = l3;
                    d = d2;
                    this.copyObjectList(this.currentBestList, this.packedObjectCount, this.packedObjects);
                    this.currentBestLeft.clear();
                    for (int i = 0; i < this.unpackedObjectCount; ++i) {
                        this.currentBestLeft.add(this.unpackedObjects[i]);
                    }
                }
            } while ((n2 = layerChooser.alternativeDim()) != -1);
            if (this.container.getDim(0) == n5) break;
            n4 = this.currentBestList.size();
            l2 = l;
            this.objectChooser.setList(0, this.currentBestList);
            this.objectChooser.setList(this.currentBestList.size(), this.currentBestLeft);
            int n8 = n3;
            n3 = this.getObjectsSize(this.container, this.currentBestList, 0);
            if (n3 == n8) break;
            this.objectChooser.reset(n4);
            layerChooser.chossenDim(this.objectChooser, n3 - this.container.getStart(0));
            this.objectChooser.reset(n4);
            ++n6;
        }
        return l;
    }

    long pack(long l, RectObject rectObject, int n, ObjectChooser objectChooser, int n2, int n3) {
        RectObject rectObject2;
        objectChooser.reset(n);
        long l2 = l;
        Arrays.fill(this.objectClassFits, true);
        block0: while ((rectObject2 = objectChooser.get(n3)) != null) {
            if (!this.objectClassFits[rectObject2.getObjectClass()]) {
                this.unpackedObjects[this.unpackedObjectCount++] = rectObject2;
                continue;
            }
            List list = rectObject2.getPossibleRotations();
            int n4 = rectObject2.getCurrRotation();
            int n5 = 1;
            int n6 = list == null ? 0 : list.size();
            while (true) {
                block2: for (int i = 0; i < n2; ++i) {
                    int n7;
                    NDPoint nDPoint = this.points[i];
                    for (n7 = 0; n7 < this.dimension; ++n7) {
                        if (nDPoint.getCoord(n7) + rectObject2.getDim(n7) > rectObject.getEnd(n7)) continue block2;
                    }
                    rectObject2.move(nDPoint);
                    for (n7 = n; n7 < this.packedObjectCount; ++n7) {
                        if (rectObject2.intercects(this.packedObjects[n7])) continue block2;
                    }
                    this.packedObjects[this.packedObjectCount++] = rectObject2;
                    l2 += rectObject2.getVolume();
                    nDPoint.setCoord(0, rectObject2.getEnd(0));
                    for (n7 = 1; n7 < this.dimension; ++n7) {
                        this.points[n2].set(rectObject2.getStart());
                        this.points[n2++].setCoord(n7, rectObject2.getEnd(n7));
                    }
                    Arrays.fill(this.objectClassFits, true);
                    continue block0;
                }
                if (n5 >= n6) break;
                rectObject2.rotate((n4 + n5) % n6);
                ++n5;
            }
            this.unpackedObjects[this.unpackedObjectCount++] = rectObject2;
            this.objectClassFits[rectObject2.getObjectClass()] = false;
        }
        return l2;
    }

    public class ChooseMaxMinObjectCriterion
    extends ChooseObjectCriterion {
        @Override
        public int choose(RectObject[] rectObjectArray, int n, int n2) {
            int n3 = PackingAlgorithm.this.objectClassMinDim[rectObjectArray[n].getObjectClass()];
            int n4 = n;
            int n5 = rectObjectArray.length;
            for (int i = n + 1; i < n5; ++i) {
                if (PackingAlgorithm.this.objectClassMinDim[rectObjectArray[i].getObjectClass()] <= n3) continue;
                n4 = i;
                n3 = PackingAlgorithm.this.objectClassMinDim[rectObjectArray[i].getObjectClass()];
            }
            return n4;
        }
    }

    public class ChooseMaxRatioObjectCriterion
    extends ChooseObjectCriterion {
        @Override
        public int choose(RectObject[] rectObjectArray, int n, int n2) {
            float f = PackingAlgorithm.this.objectClassRatio[rectObjectArray[n].getObjectClass()];
            int n3 = n;
            int n4 = rectObjectArray.length;
            for (int i = n + 1; i < n4; ++i) {
                if (!(PackingAlgorithm.this.objectClassRatio[rectObjectArray[i].getObjectClass()] > f)) continue;
                n3 = i;
                f = PackingAlgorithm.this.objectClassRatio[rectObjectArray[i].getObjectClass()];
            }
            return n3;
        }
    }

    public static class ChooseLargestVolumeObjectCriterion
    extends ChooseObjectCriterion {
        @Override
        public int choose(RectObject[] rectObjectArray, int n, int n2) {
            long l = rectObjectArray[n].getVolume();
            int n3 = n;
            int n4 = rectObjectArray.length;
            for (int i = n + 1; i < n4; ++i) {
                if (rectObjectArray[i].getVolume() <= l) continue;
                n3 = i;
                l = rectObjectArray[i].getVolume();
            }
            return n3;
        }
    }

    public static class ChooseRandomObjectCriterion
    extends ChooseObjectCriterion {
        @Override
        public int choose(RectObject[] rectObjectArray, int n, int n2) {
            return Tools.random.nextInt(rectObjectArray.length - n) + n;
        }
    }

    public class ChooseObjectByGivenDimCriterion
    extends ChooseLargestVolumeObjectCriterion {
        @Override
        public int choose(RectObject[] rectObjectArray, int n, int n2) {
            for (int i = n + 1; i < rectObjectArray.length; ++i) {
                for (int j = 0; j < PackingAlgorithm.this.dimension; ++j) {
                    if (rectObjectArray[i].getDim(j) != n2) continue;
                    List list = rectObjectArray[i].getPossibleRotations();
                    int n3 = list == null ? 0 : list.size();
                    for (int k = 0; k < n3 && rectObjectArray[i].getDim(0) != n2; ++k) {
                        rectObjectArray[i].rotate(k);
                    }
                    return i;
                }
            }
            return super.choose(rectObjectArray, n, n2);
        }
    }
}

