/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.packing;

import com.pkc.geom.RectObject;
import com.pkc.packing.ChooseObjectCriterion;
import com.pkc.util.Tools;
import java.util.List;

public class ObjectChooser {
    protected RectObject[] objects;
    protected int index;
    protected ChooseObjectCriterion[] criterions;
    protected int max;

    public ObjectChooser(List list) {
        this.objects = new RectObject[list.size()];
        this.setList(0, list);
    }

    public void setList(int n, List list) {
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            this.objects[i + n] = (RectObject)list.get(i);
        }
    }

    public void setCriterions(ChooseObjectCriterion[] chooseObjectCriterionArray) {
        this.criterions = chooseObjectCriterionArray;
        this.max = 0;
        for (int i = 0; i < chooseObjectCriterionArray.length; ++i) {
            this.max += chooseObjectCriterionArray[i].getProbability();
        }
    }

    public void reset(int n) {
        this.index = n;
    }

    public RectObject get() {
        return this.index == this.objects.length ? null : this.objects[this.index++];
    }

    public RectObject get(int n) {
        if (this.index == this.objects.length) {
            return null;
        }
        int n2 = 0;
        int n3 = this.max == 0 ? 0 : Tools.random.nextInt(this.max);
        for (int i = 0; i < this.criterions.length; ++i) {
            ChooseObjectCriterion chooseObjectCriterion = this.criterions[i];
            if ((n2 += chooseObjectCriterion.getProbability()) < n3) continue;
            int n4 = chooseObjectCriterion.choose(this.objects, this.index, n);
            if (n4 != this.index) {
                RectObject rectObject = this.objects[this.index];
                this.objects[this.index] = this.objects[n4];
                this.objects[n4] = rectObject;
            }
            return this.objects[this.index++];
        }
        return null;
    }
}

