/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.packing;

import com.pkc.geom.NDPoint;
import com.pkc.geom.RectObject;
import com.pkc.packing.LayerChooser;
import com.pkc.packing.ObjectChooser;
import java.util.List;

public class LayerChooserByObjDims
extends LayerChooser {
    int alternativeDimCount;
    int dimension;
    int index;
    int sum;
    int[] possibleLayerDims;
    int possibleLayerDimCount;
    int[] dimCounts;
    int[] minDims;

    public LayerChooserByObjDims(ObjectChooser objectChooser, RectObject rectObject, int n, int n2) {
        this.alternativeDimCount = n2;
        this.dimension = rectObject.getDim(n);
        this.possibleLayerDims = new int[objectChooser.objects.length];
        this.dimCounts = new int[objectChooser.objects.length];
        this.minDims = new int[objectChooser.objects.length];
        this.genLayers(objectChooser);
    }

    protected void genLayers(ObjectChooser objectChooser) {
        RectObject rectObject;
        this.possibleLayerDimCount = 0;
        while ((rectObject = objectChooser.get()) != null) {
            block1: for (int i = 0; i < rectObject.getDimension(); ++i) {
                int n;
                int n2 = rectObject.getDim(i);
                List list = rectObject.getPossibleRotations();
                if (list == null || list.size() == 0) {
                    if (i != 0) {
                        continue;
                    }
                } else {
                    n = list.size();
                    boolean bl = false;
                    for (int j = 0; j < n; ++j) {
                        if (((NDPoint)list.get(j)).getCoord(0) != n2) continue;
                        bl = true;
                    }
                    if (!bl) continue;
                }
                for (n = 0; n < this.possibleLayerDimCount; ++n) {
                    if (this.possibleLayerDims[n] != n2) continue;
                    int n3 = n;
                    this.dimCounts[n3] = this.dimCounts[n3] + 1;
                    continue block1;
                }
                this.possibleLayerDims[this.possibleLayerDimCount] = n2;
                this.dimCounts[this.possibleLayerDimCount] = 1;
                this.minDims[this.possibleLayerDimCount] = rectObject.getMinDim();
                ++this.possibleLayerDimCount;
            }
        }
    }

    protected int getMostFrequentDim() {
        int n;
        int n2 = 0;
        for (n = 1; n < this.possibleLayerDimCount; ++n) {
            if (this.dimCounts[n] <= this.dimCounts[n2]) continue;
            n2 = n;
        }
        n = this.possibleLayerDims[n2];
        --this.possibleLayerDimCount;
        if (this.possibleLayerDimCount > 0) {
            this.possibleLayerDims[n2] = this.possibleLayerDims[this.possibleLayerDimCount];
        }
        return n;
    }

    protected int getLargestDim() {
        int n;
        int n2 = 0;
        for (n = 1; n < this.possibleLayerDimCount; ++n) {
            if (this.possibleLayerDims[n] <= this.possibleLayerDims[n2]) continue;
            n2 = n;
        }
        n = this.possibleLayerDims[n2];
        --this.possibleLayerDimCount;
        if (this.possibleLayerDimCount > 0) {
            this.possibleLayerDims[n2] = this.possibleLayerDims[this.possibleLayerDimCount];
        }
        return n;
    }

    protected int getMaxMinDim() {
        int n;
        int n2 = 0;
        for (n = 1; n < this.possibleLayerDimCount; ++n) {
            if (this.minDims[n] <= this.minDims[n2]) continue;
            n2 = n;
        }
        n = this.possibleLayerDims[n2];
        --this.possibleLayerDimCount;
        if (this.possibleLayerDimCount > 0) {
            this.possibleLayerDims[n2] = this.possibleLayerDims[this.possibleLayerDimCount];
        }
        return n;
    }

    public void reset() {
        this.sum = 0;
    }

    @Override
    public int nextDim(ObjectChooser objectChooser) {
        this.index = 0;
        this.genLayers(objectChooser);
        if (this.possibleLayerDimCount == 0) {
            return -1;
        }
        int n = this.getMaxMinDim();
        if (this.sum == this.dimension) {
            return -1;
        }
        return this.sum + 2 * n > this.dimension ? this.dimension : this.sum + n;
    }

    @Override
    public int alternativeDim() {
        ++this.index;
        if (this.sum == this.dimension || this.index >= this.possibleLayerDimCount || this.index > this.alternativeDimCount) {
            return -1;
        }
        int n = this.getMostFrequentDim();
        return this.sum + 2 * n > this.dimension ? this.dimension : this.sum + n;
    }

    @Override
    public void chossenDim(ObjectChooser objectChooser, int n) {
        RectObject rectObject;
        this.sum = n;
        while ((rectObject = objectChooser.get()) != null) {
            if (rectObject.getMinDim() <= this.dimension - this.sum) continue;
            this.sum = this.dimension;
            return;
        }
    }
}

