/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.geom;

import com.pkc.data.PackingObject;
import com.pkc.geom.NDPoint;
import java.util.List;

public class RectObject
extends PackingObject {
    protected long volume;
    protected NDPoint start;
    protected NDPoint dims;
    protected List rotations;
    protected int currRotationIndex;
    protected int origRotationIndex;
    protected int dimension;
    private int objectClass;

    public RectObject(int n) {
        this.dimension = n;
        this.start = new NDPoint(n);
        this.dims = new NDPoint(n);
    }

    protected void calculateVolume() {
        this.volume = this.dims.coords[0];
        for (int i = 1; i < this.dimension; ++i) {
            this.volume *= (long)this.dims.coords[i];
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setStart(int n, int n2) {
        this.start.coords[n] = n2;
    }

    public void move(NDPoint nDPoint) {
        for (int i = 0; i < this.dimension; ++i) {
            this.start.coords[i] = nDPoint.coords[i];
        }
    }

    public int getStart(int n) {
        return this.start.coords[n];
    }

    public int getCenterCoord(int n) {
        return this.start.coords[n] + (this.dims.coords[n] >> 1);
    }

    public NDPoint getStart() {
        return this.start;
    }

    public void setDims(NDPoint nDPoint) {
        for (int i = 0; i < this.dimension; ++i) {
            this.dims.coords[i] = nDPoint.coords[i];
        }
        this.calculateVolume();
    }

    public NDPoint getDims() {
        return this.dims;
    }

    public int getEnd(int n) {
        return this.start.coords[n] + this.dims.coords[n];
    }

    public void setDim(int n, int n2) {
        this.dims.coords[n] = n2;
        this.calculateVolume();
    }

    public int getDim(int n) {
        return this.dims.coords[n];
    }

    public String toString() {
        String string = this.start.toString() + ": ";
        for (int i = 0; i < this.dimension - 1; ++i) {
            string = string + this.dims.coords[i] + ", ";
        }
        return string + this.getDim(this.dimension - 1);
    }

    public RectObject copy() {
        RectObject rectObject = new RectObject(this.dimension);
        rectObject.volume = this.volume;
        rectObject.move(this.start);
        rectObject.dims.set(this.dims);
        rectObject.rotations = this.rotations;
        rectObject.dimension = this.dimension;
        rectObject.objectClass = this.objectClass;
        rectObject.properties = this.properties;
        rectObject.propertyNames = this.propertyNames;
        return rectObject;
    }

    public boolean intercects(RectObject rectObject) {
        for (int i = 0; i < this.dimension; ++i) {
            int n = this.dims.coords[i] >> 1;
            int n2 = rectObject.dims.coords[i] >> 1;
            int n3 = this.start.coords[i] + n - rectObject.start.coords[i] - n2;
            if ((n3 < 0 ? -n3 : n3) < n + n2) continue;
            return false;
        }
        return true;
    }

    public int getMaxDim() {
        int n = 0;
        for (int i = 1; i < this.dimension; ++i) {
            if (this.dims.coords[i] <= this.dims.coords[n]) continue;
            n = i;
        }
        return this.dims.coords[n];
    }

    public int getMinDim() {
        int n = 0;
        for (int i = 1; i < this.dimension; ++i) {
            if (this.dims.coords[i] >= this.dims.coords[n]) continue;
            n = i;
        }
        return this.dims.coords[n];
    }

    public long getVolume() {
        return this.volume;
    }

    public float getRatio() {
        float f = 0.0f;
        for (int i = 0; i < this.dimension; ++i) {
            f += (float)(this.dims.coords[i] * this.dims.coords[i]);
        }
        float f2 = (float)Math.sqrt(f);
        float f3 = (float)Math.PI * f * f2 / 6.0f;
        return (float)this.volume / f3;
    }

    public void setPossibleRotations(List list, int n) {
        this.rotations = list;
        this.currRotationIndex = n;
        this.origRotationIndex = n;
    }

    public int getCurrRotation() {
        return this.currRotationIndex;
    }

    public List getPossibleRotations() {
        return this.rotations;
    }

    public void rotate(int n) {
        this.currRotationIndex = n;
        this.dims = (NDPoint)this.rotations.get(n);
    }

    public void restoreOrigRotation() {
        this.rotate(this.origRotationIndex);
    }

    public boolean equals(Object object) {
        if (object instanceof RectObject) {
            RectObject rectObject = (RectObject)object;
            for (int i = 0; i < this.dimension; ++i) {
                if (this.dims.coords[i] == rectObject.dims.coords[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setObjectClass(int n) {
        this.objectClass = n;
    }

    public int getObjectClass() {
        return this.objectClass;
    }
}

