/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.ec;

import com.pkc.ec.Individual;
import java.util.Arrays;
import java.util.Random;

public class Population {
    private Individual[] individuals;
    private Class individualClass;
    private Random random = new Random();

    public Population(int n, Class clazz) {
        this.individuals = new Individual[n];
        this.individualClass = clazz;
        for (int i = 0; i < n; ++i) {
            this.individuals[i] = this.newIndividual();
        }
    }

    private Individual newIndividual() {
        try {
            return (Individual)this.individualClass.newInstance();
        }
        catch (Exception exception) {
            System.err.println("Can not create individual using class '" + this.individualClass.getName() + "': " + exception.getMessage());
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public Individual evolve(int n, int n2, int n3, int n4, int n5) {
        Individual[] individualArray = new Individual[n2];
        Arrays.sort(this.individuals);
        for (int i = 0; i < n; ++i) {
            int n6;
            int n7;
            for (n7 = 0; n7 < n3; ++n7) {
                this.individuals[n7].markAsUnevaluated();
            }
            for (n6 = 0; n6 < n4; ++n6) {
                for (int j = 0; j < n2; ++j) {
                    individualArray[j] = this.individuals[this.random.nextInt(n7)];
                }
                this.individuals[n7++] = individualArray[0].cross(this.individuals[n7], individualArray);
            }
            for (n6 = 0; n6 < n5; ++n6) {
                this.individuals[n7++] = this.individuals[this.random.nextInt(n7)].mutate(this.individuals[n7]);
            }
            while (n7 < this.individuals.length) {
                this.individuals[n7] = this.newIndividual();
                ++n7;
            }
            Arrays.sort(this.individuals);
            System.out.println("=== Generation: " + i + ", best individual (" + this.individuals[0] + "): " + this.individuals[0].getFitness() + " ===");
        }
        return this.individuals[0];
    }
}

