/*
 * Decompiled with CFR 0.152.
 */
package com.pkc.ann;

import java.util.ArrayList;
import java.util.List;

public class Neuron {
    protected float value;
    private boolean evaluated;
    private List inputConnections = new ArrayList();

    public void connect(float f, Neuron neuron) {
        this.inputConnections.add(new Connection(f, neuron));
    }

    public List getConnections() {
        return this.inputConnections;
    }

    public void reset() {
        if (this.evaluated) {
            this.evaluated = false;
            for (int i = 0; i < this.inputConnections.size(); ++i) {
                ((Connection)this.inputConnections.get(i)).getNeuron().reset();
            }
        }
    }

    public float function(float f) {
        return f;
    }

    public float evaluate() {
        if (this.evaluated) {
            return this.value;
        }
        this.value = 0.0f;
        for (int i = 0; i < this.inputConnections.size(); ++i) {
            Connection connection = (Connection)this.inputConnections.get(i);
            this.value += connection.getWeight() * connection.getNeuron().evaluate();
        }
        this.evaluated = true;
        this.value = this.function(this.value);
        return this.value;
    }

    public static class Connection {
        private float weight;
        private Neuron neuron;

        public Connection(float f, Neuron neuron) {
            this.weight = f;
            this.neuron = neuron;
        }

        public float getWeight() {
            return this.weight;
        }

        public void setWeight(float f) {
            this.weight = f;
        }

        public Neuron getNeuron() {
            return this.neuron;
        }

        public void setNeuron(Neuron neuron) {
            this.neuron = neuron;
        }
    }
}

