/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import lt.monarch.chart.Chart;
import lt.monarch.chart.ChartContainer;

public class JChartPanel
extends JPanel
implements ChartContainer {
    protected Chart chart;

    private void updateChartSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        this.chart.setContainer(this, new Rectangle(insets.left, insets.top, dimension.width - insets.right - insets.left, dimension.height - insets.bottom - insets.top));
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.chart.tipAt(mouseEvent.getPoint());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.chart.paint(graphics);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    public JChartPanel(Chart chart) {
        this.setBackground(Color.white);
        this.chart = chart;
        this.updateChartSize();
        this.addComponentListener(new _cls1());
    }

    private class _cls1
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent componentEvent) {
            JChartPanel.this.updateChartSize();
        }

        public void constructor$0(JChartPanel jChartPanel) {
        }

        public _cls1() {
            this.constructor$0(JChartPanel.this);
        }
    }
}

