/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function.node;

import lt.monarch.function.Identifier;
import lt.monarch.function.MacroIdentifier;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.Variable;
import lt.monarch.function.node.AbstractNode;
import lt.monarch.function.node.ConstantNode;
import lt.monarch.function.node.MulNode;
import lt.monarch.function.node.PlusNode;

public class IdentifierNode
extends AbstractNode {
    protected static Node[] noParams = new Node[0];
    protected Identifier identifier;
    protected Node[] params;
    protected double[] values;

    @Override
    public void visited(Node.Visitor visitor) {
        super.visited(visitor);
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].visited(visitor);
        }
    }

    @Override
    public Node cloneNode() {
        Node[] nodeArray = new Node[this.params.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = this.params[i].cloneNode();
        }
        return new IdentifierNode(this.identifier, nodeArray);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.identifier.name());
        if (this.params.length != 0) {
            stringBuffer.append("(");
            for (int i = 0; i < this.params.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((Object)this.params[i]).toString());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    public Node simplify() {
        if (this.identifier instanceof MacroIdentifier) {
            return ((MacroIdentifier)this.identifier).expand(this.params);
        }
        boolean bl = true;
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i] = this.params[i].simplify();
            bl &= this.params[i] instanceof ConstantNode;
        }
        if (this.params.length != 0 && bl || this.identifier.isConstant()) {
            return new ConstantNode(this.evaluate());
        }
        return this;
    }

    @Override
    public double evaluate() {
        for (int i = 0; i < this.params.length; ++i) {
            this.values[i] = this.params[i].evaluate();
        }
        return this.identifier.evaluate(this.values);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        IdentifierNode identifierNode = (IdentifierNode)object;
        return this.identifier.equals(identifierNode.identifier) && this.paramsEquals(identifierNode.params);
    }

    private boolean paramsEquals(Node[] nodeArray) {
        if (nodeArray.length != this.params.length) {
            return false;
        }
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i].equals(nodeArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Node derivative(Variable variable) {
        if (variable == this.identifier) {
            return new ConstantNode(1.0);
        }
        Node node = new ConstantNode(0.0);
        for (int i = 0; i < this.params.length; ++i) {
            IdentifierNode identifierNode = new IdentifierNode(this.identifier.derivative(i), this.params);
            Node node2 = this.params[i].derivative(variable);
            Node node3 = new MulNode(identifierNode, node2).simplifyOperation();
            node = new PlusNode(node, node3).simplifyOperation();
        }
        return node;
    }

    @Override
    public void compile(NodeCompiler nodeCompiler) {
        this.identifier.compileRef(nodeCompiler, this.params);
    }

    public IdentifierNode(Identifier identifier, Node[] nodeArray) {
        this.identifier = identifier;
        this.params = nodeArray;
        if (this.params.length != 0) {
            this.values = new double[this.params.length];
        }
    }

    public IdentifierNode(Identifier identifier, Node node) {
        this(identifier, new Node[]{node});
    }

    public IdentifierNode(Identifier identifier) {
        this(identifier, noParams);
    }
}

