/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.charts;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import lt.monarch.charts.Axis;
import lt.monarch.charts.AxisMapper;

public class YAxis
extends Axis {
    boolean alignRight;

    public YAxis(AxisMapper axisMapper) {
        super(axisMapper);
    }

    @Override
    public void draw(Graphics graphics, Rectangle rectangle) {
        int n;
        int n2;
        graphics.setColor(Color.black);
        if (this.alignRight) {
            graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        } else {
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        }
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(" ");
        int n4 = 0;
        for (n2 = 0; n2 < this.mapper.labelCount(); ++n2) {
            n4 += fontMetrics.getHeight();
        }
        n2 = (int)Math.floor((double)n4 / (double)rectangle.height) + 1;
        int n5 = this.label == null ? 0 : n2;
        for (n = 0; n < this.mapper.labelCount() - n5; n += n2) {
            String string = this.mapper.label(n);
            int n6 = this.alignRight ? rectangle.x + rectangle.width - fontMetrics.stringWidth(string) - n3 * 2 : rectangle.x + n3 * 2;
            int n7 = this.mapLabel(rectangle, n);
            graphics.drawString(string, n6, n7 + fontMetrics.getHeight() / 3);
            if (this.alignRight) {
                graphics.drawLine(rectangle.x + rectangle.width, n7, rectangle.x + rectangle.width - n3, n7);
                continue;
            }
            graphics.drawLine(rectangle.x, n7, rectangle.x + n3, n7);
        }
        if (this.label != null) {
            n = this.alignRight ? rectangle.x + rectangle.width - fontMetrics.stringWidth(this.label) - n3 : rectangle.x + n3;
            graphics.drawString(this.label, n, rectangle.y + fontMetrics.getHeight() / 2);
        }
    }

    public int map(Rectangle rectangle, Object object) {
        return rectangle.height - this.mapper.map(rectangle.height, object) + rectangle.y;
    }

    public int mapLabel(Rectangle rectangle, int n) {
        return rectangle.height - this.mapper.mapLabel(rectangle.height, n) + rectangle.y;
    }

    public int width(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(" ");
        int n2 = 0;
        for (int i = 0; i < this.mapper.labelCount(); ++i) {
            n2 = Math.max(n2, fontMetrics.stringWidth(this.mapper.label(i)));
        }
        if (this.label != null) {
            n2 = Math.max(n2, fontMetrics.stringWidth(this.label));
        }
        return n2 + n;
    }
}

