/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.charts;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import lt.monarch.charts.Axis;
import lt.monarch.charts.AxisMapper;

public class XAxis
extends Axis {
    public XAxis(AxisMapper axisMapper) {
        super(axisMapper);
    }

    @Override
    public void draw(Graphics graphics, Rectangle rectangle) {
        int n;
        graphics.setColor(Color.black);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.stringWidth(" ");
        String string = "";
        for (n = 0; n < this.mapper.labelCount(); ++n) {
            string = string + " " + this.mapper.label(n) + " ";
        }
        n = (int)Math.floor((double)fontMetrics.stringWidth(string) / (double)rectangle.width) + 1;
        int n3 = this.label == null ? 0 : n;
        for (int i = n / 2; i < this.mapper.labelCount() - n3; i += n) {
            String string2 = this.mapper.label(i);
            int n4 = this.mapLabel(rectangle, i);
            graphics.drawString(string2, n4 - fontMetrics.stringWidth(string2) / 2, rectangle.y + fontMetrics.getHeight() + n2);
            graphics.drawLine(n4, rectangle.y, n4, rectangle.y + n2);
        }
        if (this.label != null) {
            graphics.drawString(this.label, rectangle.width + rectangle.x - fontMetrics.stringWidth(this.label), rectangle.y + fontMetrics.getHeight() + n2);
        }
    }

    public int height(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        return fontMetrics.getHeight();
    }

    public int map(Rectangle rectangle, Object object) {
        return this.mapper.map(rectangle.width, object) + rectangle.x;
    }

    public int mapLabel(Rectangle rectangle, int n) {
        return this.mapper.mapLabel(rectangle.width, n) + rectangle.x;
    }
}

