/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import lt.monarch.chart.NormalizedPoint;
import lt.monarch.chart.chart2D.ChartPointSeries;
import lt.monarch.chart.chart2D.InvisibleDot;

public class Dot
extends InvisibleDot {
    Color fillColor;
    Color outlineColor = Color.black;
    int starSize = 4;

    public Dot(Object object, Object object2) {
        super(object, object2);
        this.fillColor = Color.yellow;
    }

    @Override
    public void draw(Graphics graphics, ChartPointSeries chartPointSeries) {
        double d = chartPointSeries.xMapper.map(this.xValue);
        double d2 = chartPointSeries.yMapper.map(this.yValue);
        NormalizedPoint normalizedPoint = chartPointSeries.mapper.map(d, d2);
        Point point = chartPointSeries.chart().projector().project(normalizedPoint);
        this.tipRectangle = new Rectangle(point.x - this.starSize, point.y - this.starSize, this.starSize * 2, this.starSize * 2);
        graphics.setColor(this.fillColor);
        graphics.fillOval(this.tipRectangle.x, this.tipRectangle.y, this.tipRectangle.width, this.tipRectangle.height);
        graphics.setColor(this.outlineColor);
        graphics.drawOval(this.tipRectangle.x, this.tipRectangle.y, this.tipRectangle.width, this.tipRectangle.height);
    }

    public void setColor(Color color, Color color2) {
        this.outlineColor = color;
        this.fillColor = color2;
    }
}

