/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.NormalizedPoint;
import lt.monarch.chart.PlainMapper;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart2D.ChartPoint;
import lt.monarch.chart.chart2D.ChartPointProvider;
import lt.monarch.chart.chart2D.DotSeries;
import lt.monarch.chart.chart2D.NormalizedPoint2D;

public class ConnectedSeries
extends DotSeries {
    protected Color lineColor = Color.red;
    protected Color fillColor = null;
    protected Stroke lineStroke;

    public ConnectedSeries(ChartPointProvider chartPointProvider, PlainMapper plainMapper, AxisMapper axisMapper, AxisMapper axisMapper2) {
        super(chartPointProvider, plainMapper, axisMapper, axisMapper2);
    }

    public ConnectedSeries(ChartPointProvider chartPointProvider, Axis2D axis2D, Axis2D axis2D2) {
        super(chartPointProvider, axis2D, axis2D2);
    }

    @Override
    public void draw(Graphics graphics) {
        Point point;
        Object object;
        Polygon polygon = new Polygon();
        double d = 0.0;
        double d2 = 0.0;
        int n = this.provider.pointCount();
        for (int i = 0; i < n; ++i) {
            object = this.provider.point(i).getCenter(graphics, this);
            point = this.chart().projector().project((NormalizedPoint)object);
            polygon.addPoint(point.x, point.y);
            d2 = ((NormalizedPoint2D)object).x;
            if (i != 0) continue;
            d = d2;
        }
        if (n != 0 && this.fillColor != null) {
            Polygon polygon2 = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
            object = this.chart().projector().project(this.mapper.map(d2, 0.0));
            polygon2.addPoint(((Point)object).x, ((Point)object).y);
            point = this.chart().projector().project(this.mapper.map(d, 0.0));
            polygon2.addPoint(point.x, point.y);
            graphics.setColor(this.fillColor);
            graphics.fillPolygon(polygon2);
        }
        Stroke stroke = null;
        if (this.lineStroke != null) {
            stroke = ((Graphics2D)graphics).getStroke();
            ((Graphics2D)graphics).setStroke(this.lineStroke);
        }
        graphics.setColor(this.lineColor);
        graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
        if (stroke != null) {
            ((Graphics2D)graphics).setStroke(stroke);
        }
        this.drawPoints(graphics);
    }

    @Override
    public void pointAdded(ChartPointProvider chartPointProvider, ChartPoint chartPoint) {
        this.chart().invalidate();
    }

    public void setColor(Color color) {
        this.lineColor = color;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setStroke(Stroke stroke) {
        this.lineStroke = stroke;
    }
}

