/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import lt.monarch.chart.AbstractChart;
import lt.monarch.chart.ChartObject;
import lt.monarch.chart.Projector;
import lt.monarch.chart.chart2D.Axis2DX;
import lt.monarch.chart.chart2D.Axis2DY;
import lt.monarch.chart.chart2D.Projector2D;

public class Chart2D
extends AbstractChart {
    protected final int border = 10;
    protected Projector2D projector = new Projector2D();
    protected ChartObject[] objects;
    protected Axis2DX axisB;
    protected Axis2DY axisL;
    protected Axis2DY axisR;

    public void enableAspectRatio11() {
        this.projector = new Projector2D();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.objects == null) {
            return;
        }
        for (int i = 0; i < this.objects.length; ++i) {
            this.objects[i].draw(graphics);
        }
    }

    @Override
    protected void prepareChart(Graphics graphics) {
        if (this.axisB != null) {
            this.axisB.prepare();
        }
        if (this.axisL != null) {
            this.axisL.prepare();
        }
        if (this.axisR != null) {
            this.axisR.prepare();
        }
        int n = this.axisR == null ? 0 : this.axisR.width(graphics);
        int n2 = this.axisL == null ? 0 : this.axisL.width(graphics);
        int n3 = this.axisB == null ? 0 : this.axisB.height(graphics);
        Rectangle rectangle = new Rectangle(this.area.x + 10 + n2, this.area.y + 10, this.area.width - n2 - n - 20, this.area.height - n3 - 20);
        this.projector.setProjectionArea(rectangle);
    }

    @Override
    public Projector projector() {
        return this.projector;
    }

    public void reset() {
        if (this.objects != null) {
            for (int i = 0; i < this.objects.length; ++i) {
                this.objects[i].setChart(null);
            }
        }
        this.objects = null;
        this.requestPreparation();
    }

    public void setLAxis(Axis2DY axis2DY) {
        this.axisL = axis2DY;
        this.axisL.alignRight = false;
        this.requestPreparation();
    }

    public void setObjects(ChartObject[] chartObjectArray) {
        this.reset();
        this.objects = chartObjectArray;
        for (int i = 0; i < this.objects.length; ++i) {
            this.objects[i].setChart(this);
        }
    }

    public void setRAxis(Axis2DY axis2DY) {
        this.axisR = axis2DY;
        this.axisR.alignRight = true;
        this.requestPreparation();
    }

    public void setXAxis(Axis2DX axis2DX) {
        this.axisB = axis2DX;
        this.requestPreparation();
    }

    @Override
    public String tipAt(Point point) {
        String string = null;
        for (int i = this.objects.length - 1; i >= 0 && string == null; --i) {
            string = this.objects[i].tipAt(point);
        }
        return string;
    }
}

