/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart;

public class NormalizedRange {
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    private double minR = Double.MAX_VALUE;
    private double maxR = Double.MIN_VALUE;
    private double step = 0.0;
    private int steps;
    private int precisionPlaces;
    private double precision;

    public final double range() {
        return this.max - this.min;
    }

    public final double min() {
        return this.min;
    }

    public final double max() {
        return this.max;
    }

    public final double step() {
        return this.step;
    }

    public final int steps() {
        return this.steps + 1;
    }

    public void setRange(double d, double d2) {
        this.minR = this.min = d;
        this.maxR = this.max = d2;
    }

    public boolean updateRange(double d) {
        if (this.maxR < d) {
            this.maxR = d;
        }
        if (this.minR > d) {
            this.minR = d;
        }
        return this.max < d || this.min > d;
    }

    public void normalize() {
        this.normalize(2, 10);
    }

    public void normalize(int n) {
        this.normalize(n / 2, n * 5);
    }

    protected void normalize(int n, int n2) {
        int n3;
        if (this.minR == Double.MAX_VALUE || this.maxR == Double.MIN_VALUE) {
            this.steps = 0;
            this.step = 0.0;
            this.min = 0.0;
            this.max = 1.0;
            return;
        }
        this.min = this.minR;
        this.max = this.maxR;
        double[] dArray = new double[]{2.0, 5.0};
        int n4 = 0;
        this.step = 1.0;
        this.precisionPlaces = 0;
        double d = this.max - this.min;
        if (d == 0.0) {
            this.min = 0.0;
            this.max += 1.0;
            d = this.max - this.min;
        }
        while (true) {
            if (d / this.step <= (double)n) {
                this.step /= dArray[n4];
                n4 = 1 - n4;
                this.precisionPlaces += n4;
                continue;
            }
            if (d / this.step <= (double)n2) break;
            this.precisionPlaces -= n4;
            n4 = 1 - n4;
            this.step *= dArray[n4];
        }
        this.precision = 1.0;
        for (n3 = 0; n3 < this.precisionPlaces; ++n3) {
            this.precision /= 10.0;
        }
        for (n3 = 0; n3 < -this.precisionPlaces; ++n3) {
            this.precision *= 10.0;
        }
        double d2 = this.precision / 100.0;
        this.min = (double)Math.round(this.min / d2) * d2;
        this.max = (double)Math.round(this.max / d2) * d2;
        this.min = Math.floor(this.min / this.step) * this.step;
        this.max = Math.ceil(this.max / this.step) * this.step;
        d = this.max - this.min;
        this.steps = (int)Math.round(d / this.step);
        this.step = d / (double)this.steps;
    }

    public String format(double d) {
        if (this.step < 1.0) {
            String string = String.valueOf(d = (double)Math.round(d / this.precision) * this.precision);
            if (string.indexOf(69) > 0) {
                return string;
            }
            int n = this.precisionPlaces + 1 + new Integer(Math.abs((int)d)).toString().length();
            if (d < 0.0) {
                ++n;
            }
            return string.length() <= n ? string : string.substring(0, n);
        }
        return String.valueOf((int)d);
    }

    public String formatPrecise(double d) {
        if (this.step < 10.0) {
            double d2 = this.precision / 100.0;
            String string = String.valueOf(d = (double)Math.round(d / d2) * d2);
            if (string.indexOf(69) > 0) {
                return string;
            }
            int n = this.precisionPlaces + 3 + new Integer(Math.abs((int)d)).toString().length();
            if (d < 0.0) {
                ++n;
            }
            return string.length() <= n ? string : string.substring(0, n);
        }
        return String.valueOf((int)d);
    }

    public double map(double d) {
        if (this.range() == 0.0) {
            return 0.0;
        }
        return (d - this.min) / this.range();
    }

    public NormalizedRange() {
    }

    public NormalizedRange(double d, double d2) {
        this.minR = this.min = d;
        this.maxR = this.max = d2;
    }
}

