/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.ui;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultObserver;
import lt.ktu.gmj.ResultRepository;
import lt.ktu.gmj.propertySheet.ComponentPresenter;
import lt.ktu.gmj.propertySheet.Header;
import lt.ktu.gmj.propertySheet.PropertySheet;
import lt.ktu.gmj.propertySheet.SimpleProperty;

public class ResultSheet
extends PropertySheet
implements ResultObserver {
    protected ResultRepository set = null;
    protected JLabel iteration;
    protected JLabel value;
    protected JLabel[] dimensions;

    @Override
    public void logStarted(ResultRepository resultRepository) {
        this.set = resultRepository;
        SwingUtilities.invokeLater(new _cls1());
    }

    @Override
    public void logDisposed(ResultRepository resultRepository) {
        resultRepository.removeObserver(this);
        SwingUtilities.invokeLater(new _cls2());
    }

    @Override
    public void newResult(ResultRepository resultRepository) {
        Result result = resultRepository.lastResult();
        SwingUtilities.invokeLater(new _cls3(result));
    }

    private String format(double d) {
        String string = String.valueOf((double)Math.round(d * 1000.0) / 1000.0);
        if (string.length() > 7) {
            string = string.substring(0, 7);
        }
        return string;
    }

    private String format(int n) {
        return String.valueOf(n);
    }

    @Override
    public void newProgressResult(ResultRepository resultRepository) {
        Result result = resultRepository.lastResult();
        SwingUtilities.invokeLater(new _cls4(result));
    }

    @Override
    public void finalResult(ResultRepository resultRepository) {
    }

    protected void setup() {
        this.removeAll();
        this.add(new Header("Property", "Value"));
        this.iteration = new JLabel("", 0);
        this.add(new SimpleProperty("Iteration", new ComponentPresenter(this.iteration)));
        this.value = new JLabel("", 0);
        this.add(new SimpleProperty("F(x)", new ComponentPresenter(this.value)));
        String[] stringArray = this.set.task().domain().dimensions();
        this.dimensions = new JLabel[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.dimensions[i] = new JLabel("", 0);
            this.add(new SimpleProperty(stringArray[i], new ComponentPresenter(this.dimensions[i])));
        }
        this.complete();
    }

    private class _cls4
    implements Runnable {
        private Result r;

        @Override
        public void run() {
            ResultSheet.this.value.setText(ResultSheet.this.format(this.r.value));
            for (int i = 0; i < this.r.point.x.length; ++i) {
                ResultSheet.this.dimensions[i].setText(ResultSheet.this.format(this.r.point.x[i]));
            }
        }

        public void constructor$0(ResultSheet resultSheet) {
        }

        public _cls4(Result result) {
            this.r = result;
            this.constructor$0(ResultSheet.this);
        }
    }

    private class _cls3
    implements Runnable {
        private Result r;

        @Override
        public void run() {
            ResultSheet.this.iteration.setText(String.valueOf(this.r.iteration));
        }

        public void constructor$0(ResultSheet resultSheet) {
        }

        public _cls3(Result result) {
            this.r = result;
            this.constructor$0(ResultSheet.this);
        }
    }

    private class _cls2
    implements Runnable {
        @Override
        public void run() {
            ResultSheet.this.removeAll();
        }

        public void constructor$0(ResultSheet resultSheet) {
        }

        public _cls2() {
            this.constructor$0(ResultSheet.this);
        }
    }

    private class _cls1
    implements Runnable {
        @Override
        public void run() {
            ResultSheet.this.setup();
        }

        public void constructor$0(ResultSheet resultSheet) {
        }

        public _cls1() {
            this.constructor$0(ResultSheet.this);
        }
    }
}

