/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.tasks;

import lt.ktu.gmj.AbstractTask;
import lt.ktu.gmj.Domain;
import lt.ktu.gmj.Point;
import lt.ktu.gmj.TaskWithAnalyzers;
import lt.ktu.gmj.propertySheet.FieldProvider;
import lt.ktu.gmj.propertySheet.IntProperty;
import lt.ktu.gmj.propertySheet.PropertyManager;
import lt.ktu.gmj.tasks.ChannelProperties;
import lt.ktu.gmj.tasks.Model;
import lt.ktu.gmj.tasks.ModelDomain;

public class ModelTask
extends AbstractTask
implements TaskWithAnalyzers {
    private ModelDomain domain = new ModelDomain();
    private Model model = new Model();
    public int x = 100;
    private double[] v = new double[]{-119.9, -117.5, -115.1, -112.7, -110.3, -107.9, -105.5, -103.1, -100.7, -98.3, -95.9, -93.5, -91.1, -88.7, -86.3, -83.9, -81.5, -79.1, -76.7, -74.3, -71.9, -69.5, -67.1, -64.7, -62.3, -59.9, -57.5, -55.1, -52.7, -50.3, -47.9, -45.5, -43.1, -40.7, -38.3, -35.9, -33.5, -31.1, -28.7, -26.3, -23.9, -21.5, -19.1, -16.7, -14.3, -11.9, -9.5, -7.1, -4.7, -2.3, 0.0, 2.4, 4.8, 7.2, 9.6, 12.0, 14.4, 16.8, 19.2, 21.6, 24.0, 26.4, 28.8, 31.2, 33.6, 36.0, 38.4, 40.8, 43.2, 45.6, 48.0, 50.4, 52.8, 55.2, 57.6, 60.0, 62.4, 64.8, 67.2, 69.6, 72.0, 74.4, 76.8, 79.2, 81.6, 84.0, 86.4, 88.8, 91.2, 93.6, 96.0, 98.4, 100.8, 103.2, 105.6, 108.0, 110.4, 112.8, 115.2, 117.6};
    private double[] g = new double[]{0.1828, 0.183, 0.1837, 0.1848, 0.1849, 0.186, 0.1877, 0.1872, 0.1892, 0.1921, 0.1945, 0.2002, 0.2054, 0.2111, 0.2201, 0.2283, 0.2429, 0.2636, 0.2869, 0.3035, 0.3396, 0.3741, 0.4198, 0.4615, 0.5169, 0.5648, 0.6189, 0.6626, 0.7108, 0.7504, 0.7907, 0.8172, 0.8435, 0.866, 0.887, 0.898, 0.9158, 0.9246, 0.9345, 0.9414, 0.9507, 0.9546, 0.9568, 0.9607, 0.9652, 0.968, 0.9672, 0.968, 0.9684, 0.9711, 0.9672, 0.9697, 0.9709, 0.9691, 0.9694, 0.9654, 0.9627, 0.9617, 0.9557, 0.9532, 0.9478, 0.9406, 0.9312, 0.9261, 0.9112, 0.8999, 0.8816, 0.8602, 0.8476, 0.821, 0.7885, 0.7548, 0.71, 0.6609, 0.6053, 0.5575, 0.5047, 0.4652, 0.4199, 0.3788, 0.3412, 0.3103, 0.2816, 0.2619, 0.2439, 0.2275, 0.2188, 0.2099, 0.2045, 0.1994, 0.1952, 0.1935, 0.1904, 0.188, 0.1877, 0.1852, 0.1855, 0.1839, 0.183, 0.1827};

    @Override
    public Class[] analyzers() throws ClassNotFoundException {
        Class<?> clazz = Class.forName("lt.ktu.gmj.analysis.Spectrum");
        return new Class[]{clazz};
    }

    @Override
    public void customize(PropertyManager propertyManager) {
        propertyManager.add(new IntProperty("X", new FieldProvider(this, "x"), 1, 10000));
    }

    @Override
    public Domain domain() {
        return this.domain;
    }

    private double[] Normalize(double d, double d2, double d3, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[(int)((d2 - d) / d3) + 1];
        int n = 0;
        for (double d4 = d; d4 <= d2; d4 += d3) {
            double d5 = Double.NaN;
            double d6 = Double.NaN;
            double d7 = Double.NaN;
            double d8 = Double.NaN;
            for (int i = 0; i < dArray.length - 1; ++i) {
                if (dArray[i] <= d4) {
                    if (Double.isNaN(d5)) {
                        d5 = dArray[i];
                        d6 = dArray2[i];
                    } else if (d4 - dArray[i] < d4 - d5) {
                        d5 = dArray[i];
                        d6 = dArray2[i];
                    }
                }
                if (!(dArray[i] >= d4)) continue;
                if (Double.isNaN(d7)) {
                    d7 = dArray[i];
                    d8 = dArray2[i];
                    continue;
                }
                if (!(dArray[i] - d4 < d7 - d4)) continue;
                d7 = dArray[i];
                d8 = dArray2[i];
            }
            dArray3[n] = d4 - d5 < d7 - d4 ? d6 : d8;
            ++n;
        }
        return dArray3;
    }

    @Override
    public double f(Point point) {
        double d = -100.0;
        double d2 = 100.0;
        double d3 = 5.0;
        ChannelProperties channelProperties = this.model.getProperties();
        channelProperties.getA().setGc(point.x[0]);
        channelProperties.getA().setGo(point.x[1]);
        channelProperties.getA().setA(point.x[2]);
        channelProperties.getA().setV0(point.x[3]);
        channelProperties.getB().setGc(point.x[4]);
        channelProperties.getB().setGo(point.x[5]);
        channelProperties.getB().setA(point.x[6]);
        channelProperties.getB().setV0(point.x[7]);
        channelProperties.setX(this.x);
        double[][] dArray = this.model.Run();
        double[] dArray2 = this.Normalize(d, d2, d3, dArray[0], dArray[1]);
        double[] dArray3 = this.Normalize(d, d2, d3, this.v, this.g);
        double d4 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d4 += Math.abs(dArray2[i] - dArray3[i]);
        }
        return d4;
    }
}

