/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.propertySheet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import lt.ktu.gmj.propertySheet.InvalidPropertyException;
import lt.ktu.gmj.propertySheet.PropertyProvider;
import lt.ktu.gmj.propertySheet.PropertyStringer;
import lt.ktu.gmj.propertySheet.StringablePropertyEditor;

public class UrlEditor
extends StringablePropertyEditor
implements PropertyStringer {
    private PropertyProvider provider;

    public UrlEditor(PropertyProvider propertyProvider) {
        this.provider = propertyProvider;
        this.provider.addObserver(this);
        this.setStringer(this);
    }

    @Override
    public String getAsString() {
        return this.provider.get().toString();
    }

    @Override
    public void setAsString(String string) throws InvalidPropertyException {
        try {
            URL uRL = new URL(string);
            System.out.println("Will read data from: " + uRL.getHost() + uRL.getFile());
            URLConnection uRLConnection = uRL.openConnection();
            System.out.println("Data type will be: " + uRLConnection.getContentType() + " and size: " + uRLConnection.getContentLength());
            if (uRLConnection.getContentLength() <= 0) {
                throw new InvalidPropertyException("!!!-Bad data file...");
            }
            this.provider.set(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("!!!-Bad URL: " + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("!!!-Bad Connection: " + iOException);
        }
    }
}

