/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.analysis;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultRepository;
import lt.ktu.gmj.analysis.ResultFrame;
import lt.monarch.chart.ChartObject;
import lt.monarch.chart.Grid;
import lt.monarch.chart.MathAxisMapper;
import lt.monarch.chart.chart2D.AbstractChartPointProvider;
import lt.monarch.chart.chart2D.Axis2DX;
import lt.monarch.chart.chart2D.Axis2DY;
import lt.monarch.chart.chart2D.Chart2D;
import lt.monarch.chart.chart2D.ChartPoint;
import lt.monarch.chart.chart2D.ChartPointSeries;
import lt.monarch.chart.chart2D.Dot;
import lt.monarch.chart.chart2D.DotSeries;
import lt.monarch.swing.JChartPanel;

public class Projection
extends ResultFrame {
    protected Chart2D chart = new Chart2D();
    protected int projection = 0;
    protected ChartPointSeries series = null;
    protected JComboBox projectionChoice;
    private Provider provider;

    protected synchronized void setupChart() {
        this.provider = new Provider();
        MathAxisMapper mathAxisMapper = new MathAxisMapper();
        MathAxisMapper mathAxisMapper2 = new MathAxisMapper();
        Axis2DX axis2DX = new Axis2DX(mathAxisMapper2);
        Axis2DY axis2DY = new Axis2DY(mathAxisMapper);
        this.series = new DotSeries(this.provider, axis2DX, axis2DY);
        Grid grid = new Grid(axis2DX, axis2DY);
        axis2DY.setLabel("f(x)");
        axis2DX.setLabel(this.results.task().domain().dimensions()[this.projection]);
        mathAxisMapper.range.setRange(this.results.minValue(), this.results.maxValue());
        mathAxisMapper2.range.setRange(this.results.task().domain().min[this.projection], this.results.task().domain().max[this.projection]);
        this.chart.reset();
        this.chart.setLAxis(axis2DY);
        this.chart.setXAxis(axis2DX);
        this.chart.setObjects(new ChartObject[]{grid, axis2DX, axis2DY, this.series});
        this.chart.invalidate();
    }

    @Override
    public synchronized void prepare(ResultRepository resultRepository) {
        super.prepare(resultRepository);
        String[] stringArray = resultRepository.task().domain().dimensions();
        for (int i = 0; i < stringArray.length; ++i) {
            this.projectionChoice.addItem(stringArray[i]);
        }
        this.setupChart();
        this.show();
        resultRepository.addObserver(this);
    }

    @Override
    public synchronized void newResult(ResultRepository resultRepository) {
        this.provider.newResult(resultRepository.lastResult());
    }

    @Override
    public void newProgressResult(ResultRepository resultRepository) {
    }

    @Override
    public void finalResult(ResultRepository resultRepository) {
    }

    @Override
    public synchronized void logStarted(ResultRepository resultRepository) {
        this.setupChart();
    }

    public Projection() {
        super("Projection");
        this.getContentPane().add("Center", new JChartPanel(this.chart));
        this.projectionChoice = new JComboBox();
        this.getContentPane().add("South", this.projectionChoice);
        this.projectionChoice.addItemListener(new _cls1());
    }

    private class _cls1
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Projection.this.projection = Projection.this.projectionChoice.getSelectedIndex();
            Projection.this.setupChart();
        }

        public void constructor$0(Projection projection) {
        }

        public _cls1() {
            this.constructor$0(Projection.this);
        }
    }

    class Provider
    extends AbstractChartPointProvider {
        ChartPoint[] dotCache = new ChartPoint[500];

        @Override
        public int pointCount() {
            int n = Projection.this.results.resultCount();
            return n <= 500 ? n : 500;
        }

        @Override
        public ChartPoint point(int n) {
            int n2 = n;
            int n3 = Projection.this.results.resultCount();
            if (n3 > 500) {
                n2 = n2 * n3 / 500;
            }
            if (this.dotCache[n] == null) {
                this.dotCache[n] = this.pointFromResult(Projection.this.results.resultAt(n2));
            }
            return this.dotCache[n];
        }

        public void newResult(Result result) {
            int n = Projection.this.results.resultCount();
            if (n < 500 || n % 50 == 0) {
                ChartPoint chartPoint = this.pointFromResult(result);
                if (chartPoint.registerOn(Projection.this.series)) {
                    this.firePointsChanged();
                }
                this.dotCache[(int)(Math.random() * 500.0)] = chartPoint;
                this.firePointAdded(chartPoint);
            }
        }

        protected ChartPoint pointFromResult(Result result) {
            _cls2 _cls22 = new _cls2(new Double(result.point.x[Projection.this.projection]), new Double(result.value));
            return _cls22;
        }

        Provider() {
        }

        private class _cls2
        extends Dot {
            @Override
            public String tip(ChartPointSeries chartPointSeries) {
                return " (" + chartPointSeries.xMapper.formatKey(this.xValue()) + ", " + chartPointSeries.yMapper.formatKey(this.yValue()) + ") ";
            }

            public void constructor$0(Provider provider, Object object, Object object2) {
            }

            public _cls2(Object object, Object object2) {
                super(object, object2);
                this.constructor$0(Provider.this, object, object2);
            }
        }
    }
}

