/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function;

import lt.monarch.function.AbstractIdentifier;
import lt.monarch.function.FunctionError;
import lt.monarch.function.Identifier;
import lt.monarch.function.MacroIdentifier;
import lt.monarch.function.MacroParameter;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.node.ConstantNode;

public class MacroFunction
extends AbstractIdentifier
implements MacroIdentifier {
    protected Node body;
    protected MacroParameter[] params;

    @Override
    public int parameterCount() {
        return this.params.length;
    }

    public MacroParameter[] parameters() {
        return this.params;
    }

    @Override
    public synchronized double evaluate(double[] dArray) {
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].setNode(new ConstantNode(dArray[i]));
        }
        return this.body.evaluate();
    }

    @Override
    public synchronized Node expand(Node[] nodeArray) {
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].setNode(nodeArray[i]);
        }
        return this.body.cloneNode().simplify();
    }

    @Override
    public Identifier derivative(int n) {
        throw new FunctionError("Derivative not supported");
    }

    @Override
    public synchronized void compileRef(NodeCompiler nodeCompiler, Node[] nodeArray) {
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].setNode(nodeArray[i]);
        }
        this.body.compile(nodeCompiler);
    }

    public MacroFunction(String string, MacroParameter[] macroParameterArray, Node node) {
        super(string);
        this.body = node;
        this.params = macroParameterArray;
    }
}

