/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.function;

import lt.monarch.function.AbstractIdentifier;
import lt.monarch.function.Identifier;
import lt.monarch.function.Node;
import lt.monarch.function.NodeCompiler;
import lt.monarch.function.Variable;
import lt.monarch.function.node.ConstantNode;

public class Function
extends AbstractIdentifier {
    protected Node body;
    protected Variable[] params;

    @Override
    public int parameterCount() {
        return this.params.length;
    }

    public Variable[] parameters() {
        return this.params;
    }

    @Override
    public boolean isConstant() {
        return this.body instanceof ConstantNode;
    }

    public Node body() {
        return this.body;
    }

    @Override
    public double evaluate(double[] dArray) {
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].setValue(dArray[i]);
        }
        return this.body.evaluate();
    }

    @Override
    public Identifier derivative(int n) {
        return new Function(this.name() + "'" + (n + 1), this.params, this.body.derivative(this.params[n]));
    }

    public String javaFunctionName() {
        return this.name().replace('\'', '_');
    }

    public String javaFunctionDescriptor() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.params.length; ++i) {
            stringBuffer.append('D');
        }
        return "(" + stringBuffer.toString() + ")D";
    }

    public void compile(NodeCompiler nodeCompiler) {
        nodeCompiler.setParameters(this.params);
        nodeCompiler.compile(this.body);
    }

    @Override
    public void compileRef(NodeCompiler nodeCompiler, Node[] nodeArray) {
        if (!nodeCompiler.functionSet().hasMethod(this.javaFunctionName(), this.javaFunctionDescriptor())) {
            NodeCompiler nodeCompiler2 = new NodeCompiler(nodeCompiler.functionSet(), this.javaFunctionName());
            nodeCompiler2.setParameters(true, this.javaFunctionDescriptor(), this.params);
            nodeCompiler2.compile(this.body);
            nodeCompiler.functionSet().addMethod(nodeCompiler2);
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i].compile(nodeCompiler);
        }
        nodeCompiler.appendStaticCall(null, this.javaFunctionName(), this.javaFunctionDescriptor());
        nodeCompiler.freeStack(2 * (this.params.length - 1));
    }

    public Function(String string, Variable[] variableArray, Node node) {
        super(string);
        this.body = node.simplify();
        this.params = variableArray;
    }
}

