/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.debug;

import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import lt.monarch.debug.ErrorLogEngine;
import lt.monarch.debug.SwingLogTreeModel;

public class SwingListLogEngine
extends JDialog
implements ErrorLogEngine {
    private SwingLogTreeModel log;
    private JButton button;
    private boolean initialized = false;
    private boolean logEmpty = true;
    private boolean logClosed = false;
    private boolean disposeOnLogClose = false;

    private void setup() {
        this.setTitle("Log");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new _cls1());
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.log = new SwingLogTreeModel();
        JTree jTree = new JTree(this.log);
        jTree.setCellRenderer(new SwingLogTreeModel.CellRenderer());
        jTree.setRootVisible(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(jTree);
        jScrollPane.getViewport().setBackingStoreEnabled(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.button = new JButton();
        jPanel2.add(this.button);
        jPanel.add("Center", jScrollPane);
        jPanel.add("South", jPanel2);
        this.button.addActionListener(new _cls2());
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.logEmpty && this.button.getText() != "Close") {
            this.button.setText("Close");
        }
        if (!this.logEmpty && this.button.getText() != "Clear") {
            this.button.setText("Clear");
        }
    }

    private void closeClicked() {
        if (this.logClosed) {
            this.dispose();
        } else {
            this.setVisible(false);
        }
    }

    public void setDisposeOnLogClose(boolean bl) {
        this.disposeOnLogClose = bl;
    }

    @Override
    public void close() {
        if (this.disposeOnLogClose) {
            SwingUtilities.invokeLater(new _cls3());
        }
    }

    @Override
    public void log(ErrorLogEngine.LogPacket logPacket) {
        SwingUtilities.invokeLater(new _cls4(logPacket));
    }

    private void safeLog(ErrorLogEngine.LogPacket logPacket) {
        this.log.add(logPacket);
        this.logEmpty = false;
        this.updateButtons();
        if (!this.initialized) {
            this.initialized = true;
            this.setBounds(new Rectangle(this.getToolkit().getScreenSize().width / 6, this.getToolkit().getScreenSize().height / 6, this.getToolkit().getScreenSize().width / 2, this.getToolkit().getScreenSize().height / 3));
        }
        if (!this.isVisible()) {
            this.show();
        }
    }

    public SwingListLogEngine() {
        this((Frame)null);
        this.setup();
    }

    public SwingListLogEngine(Frame frame) {
        super(frame);
        this.setup();
    }

    private class _cls4
    implements Runnable {
        private ErrorLogEngine.LogPacket packet;

        @Override
        public void run() {
            SwingListLogEngine.this.safeLog(this.packet);
        }

        public void constructor$0(SwingListLogEngine swingListLogEngine) {
        }

        public _cls4(ErrorLogEngine.LogPacket logPacket) {
            this.packet = logPacket;
            this.constructor$0(SwingListLogEngine.this);
        }
    }

    private class _cls3
    implements Runnable {
        @Override
        public void run() {
            SwingListLogEngine.this.logClosed = true;
            SwingListLogEngine.this.dispose();
        }

        public void constructor$0(SwingListLogEngine swingListLogEngine) {
        }

        public _cls3() {
            this.constructor$0(SwingListLogEngine.this);
        }
    }

    private class _cls2
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SwingListLogEngine.this.logEmpty) {
                SwingListLogEngine.this.log.clear();
                SwingListLogEngine.this.logEmpty = true;
                SwingListLogEngine.this.updateButtons();
                return;
            }
            SwingListLogEngine.this.closeClicked();
        }

        public void constructor$0(SwingListLogEngine swingListLogEngine) {
        }

        public _cls2() {
            this.constructor$0(SwingListLogEngine.this);
        }
    }

    private class _cls1
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            SwingListLogEngine.this.closeClicked();
        }

        public void constructor$0(SwingListLogEngine swingListLogEngine) {
        }

        public _cls1() {
            this.constructor$0(SwingListLogEngine.this);
        }
    }
}

