/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.debug;

import java.util.Date;

public interface ErrorLogEngine {
    public void log(LogPacket var1);

    public void close();

    public static class LogPacket {
        private Date timestamp = new Date();
        private Throwable exception;
        private String text;

        public Date timestamp() {
            return this.timestamp;
        }

        public Throwable exception() {
            return this.exception;
        }

        public String text() {
            if (this.exception == null) {
                return this.text;
            }
            if (this.exception.getMessage() == null) {
                return this.debugText();
            }
            return this.text != null ? this.text + " (" + this.exception.getMessage() + ")" : this.exception.getMessage();
        }

        public String debugText() {
            if (this.exception == null) {
                return this.text;
            }
            return this.text != null ? this.text + " (" + this.exception.toString() + ")" : this.exception.toString();
        }

        public LogPacket(String string, Throwable throwable) {
            this.exception = throwable;
            this.text = string;
        }

        public LogPacket(String string) {
            this(string, null);
        }

        public LogPacket(Throwable throwable) {
            this(null, throwable);
        }
    }
}

