/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import lt.monarch.chart.AbstractChartObject;
import lt.monarch.chart.NormalizedMatrix;
import lt.monarch.chart.NormalizedPoint;
import lt.monarch.chart.PlainMapper;

public class DensityMap
extends AbstractChartObject {
    protected PlainMapper mapper;
    protected NormalizedMatrix matrix;
    protected Color[] palette;

    public DensityMap(PlainMapper plainMapper, NormalizedMatrix normalizedMatrix) {
        this.mapper = plainMapper;
        this.matrix = normalizedMatrix;
        this.setPalette(DensityMap.createDefaultPalette(128));
    }

    public static Color[] createDefaultPalette(int n) {
        Color[] colorArray = new Color[n];
        float[] fArray = new float[]{0.46875f, 0.9765625f, 0.0390625f};
        float[] fArray2 = new float[]{0.1757813f, 0.9375f, 0.9960938f};
        float[] fArray3 = new float[3];
        for (int i = 0; i < n; ++i) {
            float f = (float)i / (float)(n - 1);
            fArray3[0] = (1.0f + fArray2[0] - fArray[0]) * f + fArray[0];
            fArray3[1] = (fArray[1] - fArray2[1]) * f + fArray2[1];
            fArray3[2] = (fArray2[2] - fArray[2]) * f + fArray[2];
            if (fArray3[0] > 1.0f) {
                fArray3[0] = fArray3[0] - 1.0f;
            }
            colorArray[i] = Color.getHSBColor(fArray3[0], fArray3[1], fArray3[2]);
        }
        return colorArray;
    }

    public static Color[] createGrayPalette(int n) {
        return DensityMap.createGrayPalette(n, 0.5f);
    }

    public static Color[] createGrayPalette(int n, float f) {
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            float f2 = (float)i / (float)(n - 1) / 2.0f + f;
            int n2 = (int)(255.0f * f2);
            colorArray[i] = new Color(n2, n2, n2);
        }
        return colorArray;
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.mapper == null) {
            this.drawImageMap(graphics);
        } else {
            this.drawPolygonMap(graphics);
        }
    }

    private void drawImageMap(Graphics graphics) {
        int n;
        int n2 = this.matrix.resolutionX;
        int n3 = this.matrix.resolutionY;
        byte[] byArray = new byte[n2 * n3];
        byte[] byArray2 = new byte[this.palette.length];
        byte[] byArray3 = new byte[this.palette.length];
        byte[] byArray4 = new byte[this.palette.length];
        for (n = 0; n < this.palette.length; ++n) {
            byArray2[n] = (byte)(this.palette[n].getRed() & 0xFF);
            byArray3[n] = (byte)(this.palette[n].getGreen() & 0xFF);
            byArray4[n] = (byte)(this.palette[n].getBlue() & 0xFF);
        }
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = 50;
        }
        n = 0;
        int n4 = this.palette.length - 1;
        for (int i = n3 - 1; i >= 0; --i) {
            for (int j = 0; j < n2; ++j) {
                byArray[n++] = (byte)((int)(this.matrix.z[j][i] * (double)n4) & 0xFF);
            }
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, this.palette.length, byArray2, byArray3, byArray4);
        MemoryImageSource memoryImageSource = new MemoryImageSource(n2, n3, (ColorModel)indexColorModel, byArray, 0, n2);
        Image image = this.chart().container().getComponent().createImage(memoryImageSource);
        MediaTracker mediaTracker = new MediaTracker(this.chart().container().getComponent());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        mediaTracker.removeImage(image, 0);
        Rectangle rectangle = this.chart().projector().getProjectionArea();
        graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        image.flush();
    }

    private void drawPolygonMap(Graphics graphics) {
        NormalizedPoint normalizedPoint = this.mapper.map(0.0, 0.0);
        Point point = new Point();
        double[] dArray = new double[2];
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        double d = this.matrix.resolutionX;
        double d2 = this.matrix.resolutionY;
        int n = this.palette.length - 1;
        for (int i = 0; i < this.matrix.resolutionX; ++i) {
            int n2;
            dArray[0] = ((double)i - 0.0) / d;
            dArray[1] = ((double)i + 1.0) / d;
            for (n2 = 0; n2 < 2; ++n2) {
                Point point2 = this.chart().projector().project(this.mapper.map(dArray[n2], 0.0, normalizedPoint), point);
                nArray[2 + n2] = point2.x;
                nArray2[2 + n2] = point2.y;
            }
            for (n2 = 0; n2 < this.matrix.resolutionY; ++n2) {
                double d3 = ((double)n2 + 1.0) / d2;
                nArray[0] = nArray[3];
                nArray2[0] = nArray2[3];
                nArray[1] = nArray[2];
                nArray2[1] = nArray2[2];
                for (int j = 0; j < 2; ++j) {
                    Point point3 = this.chart().projector().project(this.mapper.map(dArray[j], d3, normalizedPoint), point);
                    nArray[2 + j] = point3.x;
                    nArray2[2 + j] = point3.y;
                }
                graphics.setColor(this.palette[(int)(this.matrix.z[i][n2] * (double)n)]);
                graphics.fillPolygon(nArray, nArray2, 4);
            }
        }
    }

    public void setPalette(Color[] colorArray) {
        this.palette = colorArray;
    }
}

