/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart.chart2D;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.Projector;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart2D.NormalizedPoint2D;

public class Axis2DY
extends Axis2D {
    boolean alignRight;

    public Axis2DY(AxisMapper axisMapper) {
        super(axisMapper);
    }

    @Override
    public void draw(Graphics graphics) {
        int n;
        int n2;
        Projector projector = this.chart().projector();
        Point point = projector.project(new NormalizedPoint2D(0.0, 0.0));
        Point point2 = projector.project(new NormalizedPoint2D(1.0, 1.0));
        graphics.setColor(Color.black);
        if (this.alignRight) {
            graphics.drawLine(point2.x, point.y, point2.x, point2.y);
        } else {
            graphics.drawLine(point.x, point.y, point.x, point2.y);
        }
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(" ");
        int n4 = 0;
        for (n2 = 0; n2 < this.mapper.labelCount(); ++n2) {
            n4 += fontMetrics.getHeight();
        }
        n2 = n4 / Math.abs(point.y - point2.y) + 1;
        int n5 = this.label == null ? 0 : n2;
        for (n = 0; n < this.mapper.labelCount() - n5; n += n2) {
            String string = this.mapper.label(n);
            Point point3 = projector.project(new NormalizedPoint2D(this.alignRight ? 1.0 : 0.0, this.mapper.mapLabel(n)));
            if (this.alignRight) {
                graphics.drawString(string, point3.x + n3 * 2, point3.y + fontMetrics.getHeight() / 3);
                graphics.drawLine(point3.x, point3.y, point3.x + n3, point3.y);
                continue;
            }
            graphics.drawString(string, point3.x - n3 * 2 - fontMetrics.stringWidth(string), point3.y + fontMetrics.getHeight() / 3);
            graphics.drawLine(point3.x, point3.y, point3.x - n3, point3.y);
        }
        if (this.label != null) {
            n = this.alignRight ? point2.x + n3 : point.x - n3 - fontMetrics.stringWidth(this.label);
            graphics.drawString(this.label, n, point2.y + fontMetrics.getHeight() / 2);
        }
    }

    public int width(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n = fontMetrics.stringWidth(" ");
        int n2 = 0;
        for (int i = 0; i < this.mapper.labelCount(); ++i) {
            n2 = Math.max(n2, fontMetrics.stringWidth(this.mapper.label(i)));
        }
        if (this.label != null) {
            n2 = Math.max(n2, fontMetrics.stringWidth(this.label));
        }
        return n2 + n;
    }
}

