/*
 * Decompiled with CFR 0.152.
 */
package lt.monarch.chart;

public class NormalizedMatrix {
    public final int resolutionX;
    public final int resolutionY;
    public double[][] z;

    public void normalize(double d, double d2) {
        double d3 = d2 - d;
        for (int i = 0; i < this.resolutionY; ++i) {
            for (int j = 0; j < this.resolutionX; ++j) {
                this.z[j][i] = (this.z[j][i] - d) / d3;
            }
        }
    }

    public void normalize() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < this.resolutionY; ++i) {
            for (int j = 0; j < this.resolutionX; ++j) {
                if (this.z[j][i] > d2 && this.z[j][i] != Double.POSITIVE_INFINITY) {
                    d2 = this.z[j][i];
                }
                if (!(this.z[j][i] < d) || this.z[j][i] == Double.NEGATIVE_INFINITY) continue;
                d = this.z[j][i];
            }
        }
        this.normalize(d, d2);
    }

    public void logBase(double d) {
        for (int i = 0; i < this.resolutionY; ++i) {
            for (int j = 0; j < this.resolutionX; ++j) {
                this.z[j][i] = Math.log(this.z[j][i] + d);
            }
        }
    }

    public void soften3x3() {
        int n;
        double[][] dArray = new double[this.resolutionX + 2][this.resolutionY + 2];
        for (n = 0; n < this.resolutionX; ++n) {
            System.arraycopy(this.z[n], 0, dArray[n + 1], 1, this.resolutionY);
            dArray[n][0] = dArray[n][1];
            dArray[n][this.resolutionY + 1] = dArray[n][this.resolutionY];
        }
        System.arraycopy(dArray[1], 0, dArray[0], 0, this.resolutionY + 2);
        System.arraycopy(dArray[this.resolutionX], 0, dArray[this.resolutionX + 1], 0, this.resolutionY + 2);
        for (n = 0; n < this.resolutionY; ++n) {
            for (int i = 0; i < this.resolutionX; ++i) {
                this.z[i][n] = (dArray[i][n] * 1.0 + dArray[i + 1][n] * 2.0 + dArray[i + 2][n] * 1.0 + dArray[i][n + 1] * 2.0 + dArray[i + 1][n + 1] * 3.0 + dArray[i + 2][n + 1] * 2.0 + dArray[i][n + 2] * 1.0 + dArray[i + 1][n + 2] * 2.0 + dArray[i + 2][n + 2] * 1.0) / 15.0;
            }
        }
    }

    public void soften5x5() {
        int n;
        double[][] dArray = new double[this.resolutionX + 4][this.resolutionY + 4];
        for (n = 0; n < this.resolutionX; ++n) {
            System.arraycopy(this.z[n], 0, dArray[n + 2], 2, this.resolutionY);
            double d = dArray[n][2];
            dArray[n][1] = d;
            dArray[n][0] = d;
            double d2 = dArray[n][this.resolutionY + 1];
            dArray[n][this.resolutionY + 2] = d2;
            dArray[n][this.resolutionY + 3] = d2;
        }
        System.arraycopy(dArray[2], 0, dArray[0], 0, this.resolutionY + 4);
        System.arraycopy(dArray[2], 0, dArray[1], 0, this.resolutionY + 4);
        System.arraycopy(dArray[this.resolutionX + 2], 0, dArray[this.resolutionX + 2], 0, this.resolutionY + 4);
        System.arraycopy(dArray[this.resolutionX + 2], 0, dArray[this.resolutionX + 3], 0, this.resolutionY + 4);
        for (n = 0; n < this.resolutionY; ++n) {
            for (int i = 0; i < this.resolutionX; ++i) {
                this.z[i][n] = (dArray[i][n] * 0.0 + dArray[i + 1][n] * 1.0 + dArray[i + 2][n] * 2.0 + dArray[i + 3][n] * 1.0 + dArray[i + 4][n] * 0.0 + dArray[i][n + 1] * 1.0 + dArray[i + 1][n + 1] * 2.0 + dArray[i + 2][n + 1] * 3.0 + dArray[i + 3][n + 1] * 2.0 + dArray[i + 4][n + 1] * 1.0 + dArray[i][n + 2] * 2.0 + dArray[i + 1][n + 2] * 3.0 + dArray[i + 2][n + 2] * 4.0 + dArray[i + 3][n + 2] * 3.0 + dArray[i + 4][n + 2] * 2.0 + dArray[i][n + 3] * 1.0 + dArray[i + 1][n + 3] * 2.0 + dArray[i + 2][n + 3] * 3.0 + dArray[i + 3][n + 3] * 2.0 + dArray[i + 4][n + 3] * 1.0 + dArray[i][n + 4] * 0.0 + dArray[i + 1][n + 4] * 1.0 + dArray[i + 2][n + 4] * 2.0 + dArray[i + 3][n + 4] * 1.0 + dArray[i + 4][n + 4] * 0.0) / 40.0;
            }
        }
    }

    public NormalizedMatrix(int n, int n2) {
        this.resolutionX = n;
        this.resolutionY = n2;
        this.z = new double[this.resolutionX][this.resolutionY];
    }
}

