/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.propertySheet;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import lt.ktu.gmj.propertySheet.Property;
import lt.ktu.gmj.propertySheet.PropertyManager;

public class PropertySheet
extends JScrollPane
implements PropertyManager {
    protected Vector properties = new Vector();
    protected JPanel panel;
    GridBagLayout bag = new GridBagLayout();

    @Override
    public void removeAll() {
        this.properties.removeAllElements();
        this.panel.removeAll();
    }

    @Override
    public void add(Property property) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 2, 2);
        gridBagConstraints.gridy = this.properties.size();
        JComponent jComponent = property.label();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.bag.setConstraints(jComponent, gridBagConstraints);
        this.panel.add(jComponent);
        JComponent jComponent2 = property.editor().component();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.bag.setConstraints(jComponent2, gridBagConstraints);
        this.panel.add(jComponent2);
        this.properties.addElement(property);
    }

    @Override
    public void complete() {
        this.panel.revalidate();
        this.revalidate();
        this.repaint();
    }

    public PropertySheet() {
        this.panel = new PropertyPanel();
        this.getViewport().setView(this.panel);
        this.setBackground(this.panel.getBackground());
        this.getViewport().setBackground(this.panel.getBackground());
    }

    class PropertyPanel
    extends JPanel
    implements Scrollable {
        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            Font font = this.getFont();
            return font == null ? 1 : font.getSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return n != 0 ? rectangle.height : rectangle.width;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public PropertyPanel() {
            super(PropertySheet.this.bag);
        }
    }
}

