/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.methods;

import lt.ktu.gmj.Domain;
import lt.ktu.gmj.Point;
import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultLogger;
import lt.ktu.gmj.Task;
import lt.ktu.gmj.methods.ExkorMethodBase;

public class Exkor
extends ExkorMethodBase {
    private static final int I100 = 100;
    private static final double CON = 1.28;
    private static final double LTONE = 7.0;
    private static final double UTZERO = 18.66;
    private static final double V1 = 0.398942280444;
    private static final double V2 = 0.399903438504;
    private static final double V3 = 5.75885480458;
    private static final double V4 = 29.8213557808;
    private static final double V5 = 2.62433121679;
    private static final double V6 = 48.6959930692;
    private static final double V7 = 5.92885724438;
    private static final double V11 = 0.398942280385;
    private static final double V12 = 3.8052E-8;
    private static final double V13 = 1.00000615302;
    private static final double V14 = 3.98063794E-4;
    private static final double V15 = 1.98615381364;
    private static final double V16 = 0.151679116635;
    private static final double V17 = 5.29330324926;
    private static final double V18 = 4.8385912808;
    private static final double V19 = 15.1508972451;
    private static final double V20 = 0.742380924027;
    private static final double V21 = 30.789933034;
    private static final double V22 = 3.99019417011;
    private double RMAXS;
    private double RMAX;
    private int K;
    private double CUND;
    private double K1;
    private double CP5;
    private double CP6;
    private double CM6;
    private double CM5;
    private double DM17;
    private double CM17;
    private int n_of_points;
    private double[] x1 = new double[106];
    private double[] x2 = new double[106];
    private double[] y2 = new double[106];
    private double[] y3 = new double[106];

    public Exkor() {
        this.RMAXS = Math.sqrt(Double.MAX_VALUE);
        this.RMAX = Math.log(Double.MAX_VALUE) / Math.log(10.0);
        this.K = (int)this.RMAX + 1;
        this.CUND = -2.0 * (double)this.K;
        this.K1 = this.K / 3;
        this.CP5 = Math.pow(10.0, this.K1 - 1.0);
        this.CP6 = 10.0 * this.CP5;
        this.CM6 = 1.0 / this.CP6;
        this.CM5 = 1.0 / this.CP5;
        this.CM17 = this.DM17 = Math.pow(10.0, 2.0 - (double)this.K);
        System.out.println("Exkor. (Nerijus Remeikis, 1999, Kaunas)");
    }

    private double alnorm(double d) {
        double d1;
        boolean flag = false;
        if (d < 0.0) {
            d = -d;
            flag = true;
        }
        if (d <= 7.0 || flag && d <= 18.66) {
            double d2 = 0.5 * d * d;
            if (d <= 1.28) {
                d1 = d2 + 5.92885724438;
                d1 = d2 + 2.62433121679 + 48.6959930692 / d1;
                d1 = d2 + 5.75885480458 - 29.8213557808 / d1;
                d1 = 0.5 - d * (0.398942280444 - 0.399903438504 * d2 / d1);
            } else {
                d1 = d + 3.99019417011;
                d1 = d + 0.742380924027 + 30.789933034 / d1;
                d1 = d + 4.8385912808 - 15.1508972451 / d1;
                d1 = d - 0.151679116635 + 5.29330324926 / d1;
                d1 = d + 3.98063794E-4 + 1.98615381364 / d1;
                d1 = d - 3.8052E-8 + 1.00000615302 / d1;
                d1 = 0.398942280385 * Math.exp(-d2) / d1;
            }
        } else {
            d1 = 0.0;
        }
        if (!flag) {
            d1 = 1.0 - d1;
        }
        return d1;
    }

    protected int array_maximum(double[] ad, int i, int j) {
        double d = ad[--j + i];
        int k = j;
        while (j-- > 0) {
            double d1 = ad[j + i];
            if (!(d1 > d)) continue;
            d = d1;
            k = j;
        }
        return k;
    }

    protected int array_minimum(double[] ad, int i, int j) {
        double d = ad[--j + i];
        int k = j;
        while (j-- > 0) {
            double d1 = ad[j + i];
            if (!(d1 < d)) continue;
            d = d1;
            k = j;
        }
        return k;
    }

    private double calculate_yh(double d, double d1) {
        return d - 0.5 * (d1 - d);
    }

    protected void copy_array(double[] ad, double[] ad1, int i) {
        while (i-- > 0) {
            ad[i] = ad1[i];
        }
    }

    private void cor(double d, double d1, double d2, double d3, double d4, double d5, double[] ad, int i, double[] ad1, int j) {
        double d6 = d1 - d;
        ad[i] = 0.5 * (d + d1 + d6 * (d2 - d3) / (d2 + d3 - 2.0 * d5));
        double d7 = d1 - ad[i];
        double d8 = ad[i] - d;
        double d9 = (d2 * d7 + d3 * d8) / d6;
        double d10 = Math.sqrt(d7 * d8 / d6) * d4;
        ad1[j] = -this.alnorm((d5 - d9) / d10);
    }

    protected void double_array_fill(double[] ad, int i, double d) {
        while (i-- > 0) {
            ad[i] = d;
        }
    }

    protected void double_array_fill(double[] ad, int i, int j, double d) {
        while (j-- > 0) {
            ad[j + i] = d;
        }
    }

    private Result exkor(ResultLogger resultlogger, Task task) {
        int i1;
        int[] ai = new int[1];
        int i = this.iterations();
        int j = this.initialPoints();
        int k = this.it_w();
        Domain domain = task.domain();
        int l = domain.min.length;
        Point point = new Point(task.domain());
        Result result = new Result(this.n_of_points, point, task.f(point));
        resultlogger.log(result);
        ++this.n_of_points;
        --i;
        if (k == 0) {
            i1 = 100;
        } else {
            i1 = k;
            if (i < k * l) {
                i = k * l;
            }
        }
        int j1 = Math.min(i1, i);
        int k1 = 0;
        while (k1 < l) {
            if (this.extrk0(domain.min[k1], domain.max[k1], result, j1, j, 1.0E-6, 1.0E-6, k1, this.x1, this.y3, this.y2, this.x2, ai, resultlogger, task) == -1) {
                return result;
            }
            if ((i -= ai[0]) <= 0 || k != 0 && k1 == l - 1) {
                return result;
            }
            j1 = Math.min(i1, i);
            ++k1;
        }
        return result;
    }

    private double extrapolate(double d, double d1) {
        return 0.5 * (3.0 * d - d1);
    }

    private int extrk0(double d, double d1, Result result, int i, int j, double d2, double d3, int k, double[] ad, double[] ad1, double[] ad2, double[] ad3, int[] ai, ResultLogger resultlogger, Task task) {
        System.out.println(" lb = " + d + " ub = " + d1);
        Domain domain = task.domain();
        boolean flag = false;
        double d4 = d1 - d;
        int[] ai1 = new int[1];
        int[] ai2 = new int[1];
        double[] ad4 = new double[1];
        double[] ad5 = new double[1];
        double[] ad6 = new double[1];
        double[] ad7 = new double[1];
        double[] ad8 = new double[1];
        double[] ad9 = new double[result.point.x.length];
        this.copy_array(ad9, result.point.x, ad9.length);
        ai1[0] = 0;
        ai2[0] = 0;
        ad4[0] = result.point.x[k];
        double d5 = ad4[0];
        double d6 = result.value;
        double d7 = d4 * 0.04;
        if (d4 < this.CM5 || d4 > this.CP5) {
            ai[0] = ai2[0];
            ad9[k] = ad4[0];
            return 0;
        }
        double d8 = d4 / (double)(j - 1);
        ad5[0] = d;
        int l = 3;
        while (l < j + 3) {
            ad9[k] = ad[l] = ad5[0];
            ai1[0] = ai1[0] + 1;
            Point point = new Point(domain);
            this.copy_array(point.x, ad9, ad9.length);
            ad6[0] = ad1[l] = task.f(point);
            Result result1 = new Result(this.n_of_points, point, ad6[0]);
            resultlogger.log(result1);
            ai2[0] = ai2[0] + 1;
            if (Math.abs(ad6[0]) > this.RMAXS) {
                ai[0] = ai2[0];
                ad9[k] = ad4[0];
                return -1;
            }
            if (ad6[0] < result.value) {
                result.value = ad6[0];
                ad4[0] = ad5[0];
                this.copy_array(result.point.x, ad9, ad9.length);
            }
            ++this.n_of_points;
            ad5[0] = ad5[0] + d8;
            ++l;
        }
        double d9 = this.wiener_process_parameter(ad, 3, ad1, 3, j) * 20.0;
        if (d9 < this.CM6 || d9 > this.CP6) {
            ai[0] = ai2[0];
            ad9[k] = ad4[0];
            return 0;
        }
        int i1 = this.array_maximum(ad1, 3, j);
        double d10 = ad1[i1 + 3];
        ad8[0] = this.calculate_yh(result.value, d10);
        int j1 = 0;
        d2 = Math.min(d2, 0.1 * d9 * Math.sqrt(d7));
        ad5[0] = d5;
        double d11 = d4 * 0.001;
        int k1 = 3;
        while (k1 < ai1[0] + 3) {
            if (!(ad5[0] > ad[k1 + 1])) {
                if (!(ad5[0] > ad[k1] + d11) || !(ad5[0] < ad[k1 + 1] - d11)) break;
                int l1 = ai1[0] + 2;
                while (l1 > k1) {
                    ad[l1 + 1] = ad[l1];
                    ad1[l1 + 1] = ad1[l1];
                    --l1;
                }
                ai1[0] = ai1[0] + 1;
                ad[k1 + 1] = ad5[0];
                ad1[k1 + 1] = d6;
                if (!(d6 < result.value)) break;
                result.value = d6;
                ad4[0] = ad5[0];
                ad8[0] = this.calculate_yh(result.value, d10);
                break;
            }
            ++k1;
        }
        this.double_array_fill(ad3, i + 6, 0.0);
        block3: while (true) {
            int byte0;
            int i2 = 3;
            while (i2 < ai1[0] + 2) {
                if (ad3[i2] <= 0.0) {
                    this.cor(ad[i2], ad[i2 + 1], ad1[i2], ad1[i2 + 1], d9, ad8[0], ad2, i2, ad3, i2);
                }
                ++i2;
            }
            do {
                int j2 = this.array_minimum(ad3, 3, ai1[0] - 1);
                ad7[0] = ad3[j2 + 3];
                j2 += 3;
                int k2 = ai1[0] + 2;
                while (k2 > j2) {
                    ad[k2 + 1] = ad[k2];
                    ad1[k2 + 1] = ad1[k2];
                    ad2[k2] = ad2[k2 - 1];
                    ad3[k2] = ad3[k2 - 1];
                    --k2;
                }
                ad9[k] = ad5[0] = ad2[j2];
                ad[j2 + 1] = ad5[0];
                ai1[0] = ai1[0] + 1;
                Point point1 = new Point(domain);
                this.copy_array(point1.x, ad9, ad9.length);
                ad1[j2 + 1] = ad6[0] = task.f(point1);
                Result result2 = new Result(this.n_of_points, point1, ad6[0]);
                resultlogger.log(result2);
                ++this.n_of_points;
                ai2[0] = ai2[0] + 1;
                if (Math.abs(ad6[0]) > this.RMAXS) {
                    ai[0] = ai2[0];
                    result.point.x[k] = ad9[k] = ad4[0];
                    return -1;
                }
                if (ad6[0] < result.value) {
                    result.value = ad6[0];
                    ad4[0] = ad5[0];
                    byte0 = 2;
                    this.copy_array(result.point.x, ad9, ad9.length);
                } else {
                    byte0 = 1;
                }
                if (ai2[0] >= i) {
                    ai[0] = ai2[0];
                    ad9[k] = ad4[0];
                    return 0;
                }
                d10 = Math.max(d10, ad6[0]);
                double d12 = this.probability(ad, 3, ad1, 3, result.value, d2, d9, ad3, 3, ai1[0]);
                ad8[0] = this.calculate_yh(result.value, d10);
                if (Math.abs(result.value - ad6[0]) < 4.94E-321) {
                    byte0 = 2;
                    d9 = this.wiener_process_parameter(ad, 3, ad1, 3, ai1[0]) * 20.0;
                } else {
                    if (d12 >= 0.95) {
                        ai[0] = ai2[0];
                        ad9[k] = ad4[0];
                        return 0;
                    }
                    if (ai1[0] % 5 == 0 && j1 == 0) {
                        byte0 = 2;
                        d9 = this.wiener_process_parameter(ad, 3, ad1, 3, ai1[0]) * 20.0;
                    }
                }
                ad[1] = ad[2] = this.extrapolate(ad[3], ad[4]);
                ad[0] = ad[2];
                double d13 = this.extrapolate(ad[ai1[0] + 2], ad[ai1[0] + 1]);
                ad[ai1[0] + 5] = d13;
                ad[ai1[0] + 4] = d13;
                ad[ai1[0] + 3] = d13;
                ad1[1] = ad1[2] = ad1[4];
                ad1[0] = ad1[2];
                double d14 = ad1[ai1[0] + 1];
                ad1[ai1[0] + 5] = d14;
                ad1[ai1[0] + 4] = d14;
                ad1[ai1[0] + 3] = d14;
                double d132 = d4 * 0.2;
                boolean flag1 = false;
                int l2 = Math.max(0, j2 - 5);
                while (l2 < Math.min(ai1[0], j2 + 2)) {
                    if (!(ad1[l2] < ad1[l2 + 1] || ad1[l2 + 1] < ad1[l2 + 2] || ad1[l2 + 2] <= ad1[l2 + 3] || ad1[l2 + 3] >= ad1[l2 + 4] || ad1[l2 + 4] > ad1[l2 + 5] || ad1[l2 + 5] > ad1[l2 + 6] || ad[l2 + 6] - ad[l2] > d132)) {
                        flag1 = true;
                        break;
                    }
                    ++l2;
                }
                if (flag1) {
                    this.double_array_fill(ad3, l2, 6, 1.0);
                    ++j1;
                    int i3 = this.local_optimization(ai2, ad4, result, l2 += 3, ad5, ad6, ad, ad1, ad7, k, ai1, ad8, d10, i, d3, d2, task, resultlogger, ad9);
                    if (i3 < 1) {
                        ai[0] = ai2[0];
                        ad9[k] = ad4[0];
                        return i3;
                    }
                    ad[l2] = ad5[0];
                    ad1[l2] = ad6[0];
                    byte0 = 2;
                }
                if (byte0 == 2) continue block3;
                int j3 = j2;
                while (j3 < j2 + 2) {
                    if (ad[j3 + 1] - ad[j3] < d7 && ad3[j3 - 1] > 0.0 && ad1[j3] < ad1[j3 + 1]) {
                        ad3[j3] = 1.0;
                    } else {
                        this.cor(ad[j3], ad[j3 + 1], ad1[j3], ad1[j3 + 1], d9, ad8[0], ad2, j3, ad3, j3);
                    }
                    ++j3;
                }
                this.unimodality(ad3, ad, ad1, j2 + 1, d7);
                this.unimodality(ad3, ad, ad1, j2, d7);
            } while (byte0 == 1);
        }
    }

    private int local_optimization(int[] ai, double[] ad, Result result, int i, double[] ad1, double[] ad2, double[] ad3, double[] ad4, double[] ad5, int j, int[] ai1, double[] ad6, double d, int k, double d1, double d2, Task task, ResultLogger resultlogger, double[] ad7) {
        boolean flag = false;
        boolean flag1 = false;
        double d3 = ad3[0];
        double d4 = ad3[i - 1];
        double d5 = ad3[i];
        double d6 = ad3[i + 1];
        double d7 = ad4[i - 1];
        double d8 = ad4[i];
        double d9 = ad4[i + 1];
        while (true) {
            double d13;
            double d12;
            double d14;
            double d10 = d7 - d8;
            double d11 = d4 - d5;
            if (Math.abs(d10) <= this.DM17 || Math.abs(d11) <= this.DM17 || Math.abs(d14 = 2.0 * ((d12 = d7 - d9) / d10 - (d13 = d4 - d6) / d11)) <= this.DM17) break;
            ad1[0] = ((d4 + d5) * d12 / d10 - (d4 + d6) * d13 / d11) / d14;
            d12 = d5 - ad1[0];
            d11 = d4 - ad1[0];
            ad5[0] = Math.abs(d11) < this.DM17 ? d7 : (Math.abs(d12 = 1.0 - d12 / d11 * (d12 / d11)) < this.DM17 ? (d10 > Math.abs(d12) * 1000000.0 ? d7 - 100000.0 : d7 - d10 / d12) : d7 - d10 / d12);
            ad7[j] = ad1[0];
            Point point = new Point(task.domain());
            this.copy_array(point.x, ad7, ad7.length);
            ad2[0] = task.f(point);
            Result result1 = new Result(this.n_of_points, point, ad2[0]);
            resultlogger.log(result1);
            ++this.n_of_points;
            ai[0] = ai[0] + 1;
            if (Math.abs(ad2[0]) > this.RMAXS) {
                return -1;
            }
            if (ad2[0] < result.value) {
                result.value = ad2[0];
                ad[0] = ad1[0];
                this.copy_array(result.point.x, ad7, ad7.length);
                ad6[0] = this.calculate_yh(result.value, d);
            }
            if (ai[0] >= k) {
                return 0;
            }
            d3 = Math.abs(ad1[0] - d3);
            byte byte0 = (byte)(ad1[0] > d5 ? 2 : 1);
            ad5[0] = Math.abs(ad5[0] - ad2[0]);
            if (ad5[0] <= d2 && d3 <= d1 || ad5[0] <= this.CM17 || d3 <= this.CM17) break;
            if (ad2[0] < d8) {
                if (byte0 == 2) {
                    d4 = d5;
                    d7 = d8;
                    d5 = ad1[0];
                    d8 = ad2[0];
                    if (i == ai1[0] + 2 && !flag) {
                        d6 = this.extrapolate(d5, d4);
                        d9 = d7;
                    } else {
                        flag = true;
                    }
                } else {
                    d6 = d5;
                    d9 = d8;
                    d5 = ad1[0];
                    d8 = ad2[0];
                    if (i == 3 && !flag) {
                        d4 = this.extrapolate(d5, d6);
                        d7 = d9;
                    } else {
                        flag = true;
                    }
                }
            } else if (byte0 == 2) {
                d6 = ad1[0];
                d9 = ad2[0];
                if (i == 3 && !flag) {
                    d4 = this.extrapolate(d5, d6);
                    d7 = d9;
                } else {
                    flag = true;
                }
            } else {
                d4 = ad1[0];
                d7 = ad2[0];
                if (i == ai1[0] + 2 && !flag) {
                    d6 = this.extrapolate(d5, d4);
                    d9 = d7;
                } else {
                    flag = true;
                }
            }
            d3 = ad1[0];
        }
        return 1;
    }

    private double probability(double[] ad, int i, double[] ad1, int j, double d, double d1, double d2, double[] ad2, int k, int l) {
        double d3 = 1.0;
        double d4 = -800.0 / d2 * d2;
        --l;
        while (l-- > 0) {
            if (!(ad2[l + k] < 0.0)) continue;
            double d5 = d4;
            d5 *= (ad1[l + j + 1] - d + d1) * (ad1[l + j] - d + d1);
            if (!((d5 /= ad[l + i + 1] - ad[l + i]) > this.CUND)) continue;
            d3 *= 1.0 - Math.exp(d5);
        }
        return d3;
    }

    public Result run(ResultLogger resultlogger, Task task) {
        return this.exkor(resultlogger, task);
    }

    private void unimodality(double[] ad, double[] ad1, double[] ad2, int i, double d) {
        if (ad[i + 1] > 0.0 && ad2[i] > ad2[i + 1] && ad1[i + 1] - ad1[i] < d) {
            ad[i] = 1.0;
        }
    }

    private double wiener_process_parameter(double[] ad, int i, double[] ad1, int j, int k) {
        double d = 0.0;
        int l = 1;
        while (l < k) {
            double d1 = ad1[l + j] - ad1[l + j - 1];
            d += d1 * d1 / (ad[l + i] - ad[l + i - 1]);
            ++l;
        }
        return Math.sqrt(d / (double)(k - 1));
    }
}

