/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.methods;

import lt.ktu.gmj.Domain;
import lt.ktu.gmj.Point;
import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultLogger;
import lt.ktu.gmj.Task;
import lt.ktu.gmj.methods.IPMethodBase;
import lt.ktu.gmj.methods.LPPoint;
import lt.ktu.gmj.methods.RandomPoint;

public class Bayes
extends IPMethodBase {
    private static final int NOT_SEC_POINT = 0;
    private static final int SEC_POINT = 1;
    private static final int PAR1 = 10;
    private static final int PAR2 = 50;
    private static final double VAL = 1.0E-6;
    private static final double COEF = 1.0E-14;
    private static final double RMAX = 8.988465674311579E307;
    private Point x2;
    private Point mz;
    private int ix;

    public Bayes() {
        this.iterations = 100;
        this.initialPoints = 5;
    }

    private double fiap1(Point point, ResultLogger resultLogger, double d, Result result, int n) {
        double d2 = resultLogger.logAt((int)0).value;
        double d3 = result.value;
        double d4 = d3 - Math.max(1.0E-6, 1.0E-14 * Math.abs(d3));
        double d5 = Math.min(8.988465674311579E307, 8.988465674311579E307 / (d2 - d4));
        for (int i = 0; i < n; ++i) {
            double d6;
            Result result2 = resultLogger.logAt(i);
            double d7 = point.distance(result2.point);
            double d8 = d7 * d7;
            if (!(d8 < Math.min(8.988465674311579E307, (d6 = result2.value - d4) * d5)) || !((d5 = d8 / d6) <= -d)) continue;
            return -d5;
        }
        return -d5;
    }

    private Point mig2f2(ResultLogger resultLogger, Task task, Result result, int n) {
        Point point = null;
        Domain domain = task.domain();
        int n2 = Math.min(50, Math.max(10, n)) * domain.dimensions().length;
        double d = 0.0;
        double d2 = 0.0;
        if (this.ix == 0) {
            this.x2 = new RandomPoint(domain);
            --n2;
            this.ix = 1;
        }
        double d3 = this.fiap1(this.x2, resultLogger, d, result, n);
        for (int i = 0; i < n2; ++i) {
            this.mz = new RandomPoint(domain);
            double d4 = this.fiap1(this.mz, resultLogger, d, result, n);
            if (i == 0) {
                if (d4 >= d3) {
                    point = this.x2;
                    this.x2 = this.mz;
                    d2 = d3;
                    d = d3 = d4;
                    continue;
                }
                point = this.mz;
                d2 = d4;
                d = d3;
                continue;
            }
            if (!(d4 < d3)) continue;
            if (d4 < d2) {
                this.x2 = point;
                point = this.mz;
                d = d3 = d2;
                d2 = d4;
                continue;
            }
            this.x2 = this.mz;
            d = d3 = d4;
        }
        return point;
    }

    @Override
    public Result run(ResultLogger resultLogger, Task task) {
        Result result;
        Point point;
        int n;
        Domain domain = task.domain();
        Result result2 = new Result();
        this.ix = 0;
        for (n = 0; n < this.initialPoints; ++n) {
            point = new LPPoint(domain, n);
            result = new Result(n, point, task.f(point));
            resultLogger.log(result);
            if (!(result.value < result2.value)) continue;
            result2 = result;
        }
        for (n = this.initialPoints; n < this.iterations; ++n) {
            point = this.mig2f2(resultLogger, task, result2, n);
            result = new Result(n, point, task.f(point));
            resultLogger.log(result);
            if (!(result.value < result2.value)) continue;
            result2 = result;
        }
        return result2;
    }
}

