/*
 * Decompiled with CFR 0.152.
 */
package lt.ktu.gmj.analysis;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import lt.ktu.gmj.Result;
import lt.ktu.gmj.ResultRepository;
import lt.ktu.gmj.analysis.FrequencyMatrix;
import lt.ktu.gmj.analysis.ResultFrame;
import lt.monarch.chart.ChartObject;
import lt.monarch.chart.Grid;
import lt.monarch.chart.MathAxisMapper;
import lt.monarch.chart.chart2D.Axis2DX;
import lt.monarch.chart.chart2D.Axis2DY;
import lt.monarch.chart.chart2D.Chart2D;
import lt.monarch.chart.chart2D.DensityMap;
import lt.monarch.swing.JChartPanel;

public class Spectrum
extends ResultFrame {
    protected Chart2D chart = new Chart2D();
    protected int iterationStep;
    protected int iterationGrid;
    protected FrequencyMatrix spectrum;
    protected ChartObject spectrumSeries;
    protected JComboBox projectionChoice;
    protected int projection = 0;

    protected void setupChart() {
        Vector vector = new Vector();
        MathAxisMapper mathAxisMapper = new MathAxisMapper();
        MathAxisMapper mathAxisMapper2 = new MathAxisMapper();
        Axis2DX axis2DX = new Axis2DX(mathAxisMapper2);
        Axis2DY axis2DY = new Axis2DY(mathAxisMapper);
        Grid grid = new Grid(axis2DX, axis2DY);
        grid.setFillColor(null);
        this.spectrum = new FrequencyMatrix(this.iterationGrid, 60, mathAxisMapper2, mathAxisMapper);
        this.spectrumSeries = new DensityMap(null, this.spectrum);
        axis2DY.setLabel("f(x)");
        mathAxisMapper.range.setRange(this.results.minValue(), this.results.maxValue());
        if (this.projection == 0) {
            axis2DX.setLabel("Iteration");
            mathAxisMapper2.range.setRange(0.0, this.results.method().iterations());
        } else {
            axis2DX.setLabel(this.results.task().domain().dimensions()[this.projection - 1]);
            mathAxisMapper2.range.setRange(this.results.task().domain().min[this.projection - 1], this.results.task().domain().max[this.projection - 1]);
        }
        this.chart.reset();
        this.chart.setLAxis(axis2DY);
        this.chart.setXAxis(axis2DX);
        this.chart.setObjects(new ChartObject[]{axis2DX, axis2DY, this.spectrumSeries, grid});
        for (int i = 0; i < this.results.resultCount(); ++i) {
            Result result = this.results.resultAt(i);
            if (this.projection == 0) {
                this.spectrum.addPoint(new Double(result.iteration), new Double(result.value));
                continue;
            }
            this.spectrum.addPoint(new Double(result.point.x[this.projection - 1]), new Double(result.value));
        }
        this.spectrum.refresh();
        this.chart.invalidate();
    }

    @Override
    public void newResult(ResultRepository resultRepository) {
        Result result = this.results.lastResult();
        if (this.projection == 0) {
            this.spectrum.addPoint(new Double(result.iteration), new Double(result.value));
        } else {
            this.spectrum.addPoint(new Double(result.point.x[this.projection - 1]), new Double(result.value));
        }
        if (this.results.lastResult().iteration % this.iterationStep == 0) {
            this.updateView();
        }
    }

    @Override
    public void newProgressResult(ResultRepository resultRepository) {
    }

    @Override
    public void finalResult(ResultRepository resultRepository) {
        this.updateView();
    }

    protected void updateView() {
        this.spectrum.refresh();
        this.chart.invalidate();
    }

    @Override
    public void prepare(ResultRepository resultRepository) {
        super.prepare(resultRepository);
        this.iterationGrid = resultRepository.method().iterations() / 5 + 1;
        if (this.iterationGrid > 100) {
            this.iterationGrid = 100;
        }
        this.iterationStep = resultRepository.method().iterations() / this.iterationGrid * 5;
        if (this.iterationStep < 1) {
            this.iterationStep = 1;
        }
        this.projectionChoice.addItem("Iteration");
        String[] stringArray = resultRepository.task().domain().dimensions();
        for (int i = 0; i < stringArray.length; ++i) {
            this.projectionChoice.addItem(stringArray[i]);
        }
        this.setupChart();
        this.show();
        resultRepository.addObserver(this);
    }

    @Override
    public void logStarted(ResultRepository resultRepository) {
        this.spectrum.clear();
        this.chart.invalidate();
    }

    public Spectrum() {
        super("Spectrum");
        this.getContentPane().add("Center", new JChartPanel(this.chart));
        this.projectionChoice = new JComboBox();
        this.getContentPane().add("South", this.projectionChoice);
        this.projectionChoice.addItemListener(new _cls1());
    }

    private class _cls1
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Spectrum.this.projection = Spectrum.this.projectionChoice.getSelectedIndex();
            Spectrum.this.setupChart();
        }

        public void constructor$0(Spectrum spectrum) {
        }

        public _cls1() {
            this.constructor$0(Spectrum.this);
        }
    }
}

