package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.*;
import javax.swing.*;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.NumberFormatter;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;

public class StartApplet extends JApplet {
    private JPanel main_Panel;
    public JPanel data_Panel, AR_Panel, ABS_Panel, ARMA_Panel, ARMAABS_Panel, exp_Panel;
    private JRadioButton your_Button, XML_Button, CSV_Button, Yahoo_Button, NASDAQ_Button;
    private ButtonGroup choice_Group;
    public JTextArea your_data_Area, exp_p_Area;
    private JScrollPane your_data_Scroll, exp_p_Scroll;
    
    private String data[][];
    private JTabbedPane tabbedPane;
    public JTable table1, data_AR_Table, data_ABS_Table, data_ARMA_Table, data_ARMAABS_Table;
    public JTable coef_AR_Table, coef_ABS_Table, coef_ARMA_Table, coef_ARMAABS_Table;
    public JScrollPane scrollPanel1;
    public JScrollPane data_table_AR_Scroll, data_table_ABS_Scroll, data_table_ARMA_Scroll, data_table_ARMAABS_Scroll;
    public JScrollPane coef_table_AR_Scroll, coef_table_ABS_Scroll, coef_table_ARMA_Scroll, coef_table_ARMAABS_Scroll;
    public JLabel column_Label;
    private NumberFormatter column_Formatter;
    public JFormattedTextField column_Field;
    private JButton CSV_load_Button;
    private JLabel stock_name_Label;
    public JTextField stock_name_Field;
    private JLabel start_date_Label, end_date_Label;
    private NumberFormatter start_day_Formatter, end_day_Formatter;
    public JComboBox start_month_Box, end_month_Box, stock_list_Box;
    public JFormattedTextField start_day_Field, end_day_Field;
    private NumberFormatter start_year_Formatter, end_year_Formatter;
    public ButtonGroup type_Group;
    public JFormattedTextField start_year_Field, end_year_Field;
    private JRadioButton daily_Button, weekly_Button;
    private JButton button2;
    private NumberFormatter p_Formatter, q_Formatter, b_from_Formatter, b_to_Formatter, b_step_Formatter;
    private JLabel p_Label, q_Label, b_from_Label, b_to_Label, b_step_Label;
    private JButton Yahoo_data_load_Button;
    private ActionListener myActionListener;
    private Calendar cal;
    private JRadioButton monthly_Button;
    public JFormattedTextField p_AR_Field, p_ABS_Field, p_ARMA_Field, p_ARMAABS_Field;
    public JFormattedTextField q_ARMA_Field, q_ARMAABS_Field;
    public JFormattedTextField b_from_ARMA_Field, b_from_ARMAABS_Field;
    public JFormattedTextField b_to_ARMA_Field, b_to_ARMAABS_Field;
    public JFormattedTextField b_step_ARMA_Field, b_step_ARMAABS_Field;
    public JButton graphic_AR_Button, graphic_ABS_Button, graphic_ARMA_Button, graphic_ARMAABS_Button;
    public JFrame graphicFrame;
    public TimeSeries real_AR_Series, real_ABS_Series, real_ARMA_Series, real_ARMAABS_Series;
    public TimeSeries forecast_AR_Series, forecast_ABS_Series, forecast_ARMA_Series, forecast_ARMAABS_Series;
    public TimeSeries forecast_test_AR_Series, forecast_test_ABS_Series, forecast_test_ARMA_Series, forecast_test_ARMAABS_Series;
    public JLabel forecast_AR_Label, forecast_ABS_Label, forecast_ARMA_Label, forecast_ARMAABS_Label;
    private NumberFormatter forecast_Formatter;
    public JFormattedTextField forecast_AR_Field, forecast_ABS_Field, forecast_ARMA_Field, forecast_ARMAABS_Field;
    public JLabel title_Label;
    public JRadioButton title_yes_Button, title_no_Button;
    private ButtonGroup title_Group;
    public String title_value = "no";
    public String filepath = "";
    public JLabel read_Label;
    public JRadioButton read_top_Button, read_bottom_Button;
    public ButtonGroup read_Group;
    private JButton NASDAQ_data_load_Button;
    private JLabel currency_Label;
    private JRadioButton currency_EUR_Button, currency_LTL_Button, currency_LVL_Button, currency_EEK_Button, currency_No_Button;
    public ButtonGroup currency_Group;
    private JLabel MAE_AR_Label, MAPE_AR_Label, PMAD_AR_Label, MSE_AR_Label, RMSE_AR_Label, residual_variance_AR_Label;
    private JLabel MAE_ABS_Label, MAPE_ABS_Label, PMAD_ABS_Label, MSE_ABS_Label, RMSE_ABS_Label, residual_variance_ABS_Label;
    public JLabel MAE_ARMA_Label, MAPE_ARMA_Label, PMAD_ARMA_Label, MSE_ARMA_Label, RMSE_ARMA_Label, residual_variance_ARMA_Label;
    public JLabel MAE_ARMAABS_Label, MAPE_ARMAABS_Label, PMAD_ARMAABS_Label, MSE_ARMAABS_Label, RMSE_ARMAABS_Label, residual_variance_ARMAABS_Label;
    public JButton test_AR_Button, test_ABS_Button, test_ARMA_Button, test_ARMAABS_Button;
    public double used_data_AR[], used_data_ABS[], used_data_ARMA[], used_data_ARMAABS[];
    private double suma_array[];
    public double entered_data_AR[], entered_data_ABS[], entered_data_ARMA[], entered_data_ARMAABS[];
    public double[] coef_AR, coef_ABS, coef_ABS2, coef_ARMA, coef_ARMAABS;
    public int p_value_AR, p_value_ABS, p_value_ARMA, p_value_ARMAABS;
    public int q_value_ARMAABS;
    private JLabel MAE_value_AR_Label, MAPE_value_AR_Label, PMAD_value_AR_Label, MSE_value_AR_Label, RMSE_value_AR_Label, residual_variance_value_AR_Label;
    private JLabel MAE_value_ABS_Label, MAPE_value_ABS_Label, PMAD_value_ABS_Label, MSE_value_ABS_Label, RMSE_value_ABS_Label, residual_variance_value_ABS_Label;
    public JLabel MAE_value_ARMA_Label, MAPE_value_ARMA_Label, PMAD_value_ARMA_Label, MSE_value_ARMA_Label, RMSE_value_ARMA_Label, residual_variance_value_ARMA_Label;
    public JLabel MAE_value_ARMAABS_Label, MAPE_value_ARMAABS_Label, PMAD_value_ARMAABS_Label, MSE_value_ARMAABS_Label, RMSE_value_ARMAABS_Label, residual_variance_value_ARMAABS_Label;
    public JFrame test_data_AR_Frame, test_data_ABS_Frame, test_data_ARMA_Frame, test_data_ARMAABS_Frame;
    public JTable test_data_AR_Table, test_data_ABS_Table, test_data_ARMA_Table, test_data_ARMAABS_Table;
    public JFormattedTextField entry_AR_Field, entry_ABS_Field, entry_ARMA_Field, entry_ARMAABS_Field;
    private JButton XML_load_Button;
    public JButton save_CSV_AR_Button, save_CSV_ABS_Button, save_CSV_ARMA_Button, save_CSV_ARMAABS_Button, exp_run_Button;
    public JLabel recalc_Label;
    public JRadioButton recalc_yes_AR_Button, recalc_yes_ABS_Button, recalc_yes_ARMA_Button, recalc_yes_ARMAABS_Button;
    public JRadioButton recalc_no_AR_Button, recalc_no_ABS_Button, recalc_no_ARMA_Button, recalc_no_ARMAABS_Button;
    public ButtonGroup recalc_AR_Group, recalc_ABS_Group, recalc_ARMA_Group, recalc_ARMAABS_Group;
    public JLabel data_count_AR_Label, data_count_ABS_Label, data_count_ARMA_Label, data_count_ARMAABS_Label;
    public int entered_data_Count;
    public int testing_data_AR_Count, testing_data_ABS_Count, testing_data_ARMA_Count, testing_data_ARMAABS_Count;
    public int training_data_AR_Count, training_data_ABS_Count, training_data_ARMA_Count, training_data_ARMAABS_Count;
    private NumberFormatter training_data_Formatter;
    public JFormattedTextField training_data_AR_Field, training_data_ABS_Field, training_data_ARMA_Field, training_data_ARMAABS_Field;
    public JLabel half_data_AR_Label, half_data_ABS_Label, half_data_ARMA_Label, half_data_ARMAABS_Label;
    public String type;
    public int column_number;
    private JLabel virtual_data_AR_Label, virtual_data_ABS_Label, virtual_data_ARMA_Label, virtual_data_ARMAABS_Label;
    private JRadioButton virtual_data_yes_AR_Button, virtual_data_yes_ABS_Button, virtual_data_yes_ARMA_Button, virtual_data_yes_ARMAABS_Button;
    private JRadioButton virtual_data_no_AR_Button, virtual_data_no_ABS_Button, virtual_data_no_ARMA_Button, virtual_data_no_ARMAABS_Button;
    public ButtonGroup virtual_data_AR_Group, virtual_data_ABS_Group, virtual_data_ARMA_Group, virtual_data_ARMAABS_Group;
    public JLabel data_mean_AR_Label, data_mean_ABS_Label, data_mean_ARMA_Label, data_mean_ARMAABS_Label;
    public JLabel data_mean_value_AR_Label, data_mean_value_ABS_Label, data_mean_value_ARMA_Label, data_mean_value_ARMAABS_Label;
    public JLabel data_variance_AR_Label, data_variance_ABS_Label, data_variance_ARMA_Label, data_variance_ARMAABS_Label;
    public JLabel data_variance_value_AR_Label, data_variance_value_ABS_Label, data_variance_value_ARMA_Label, data_variance_value_ARMAABS_Label;
    public JCheckBox data_mean_CheckBox, data_standard_CheckBox;
    public JCheckBox MAE_CheckBox, MAPE_CheckBox, PMAD_CheckBox, MSE_CheckBox, RMSE_CheckBox;
    public JCheckBox residual_variance_CheckBox;
    private JLabel exp_p_Label;
    private JLabel select_indicators_Label;
    private JLabel exp_start_date_Label, exp_end_date_Label;
    private NumberFormatter exp_start_year_Formatter, exp_end_year_Formatter;
    public JFormattedTextField exp_start_year_Field, exp_end_year_Field;
    public JComboBox exp_start_month_Box, exp_end_month_Box;
    private NumberFormatter exp_start_day_Formatter, exp_end_day_Formatter;
    public JFormattedTextField exp_start_day_Field, exp_end_day_Field;

    private void createDataPage() {
        Locale.setDefault(Locale.ENGLISH);
        
        data_Panel = new JPanel();
        data_Panel.setLayout(null);

        myActionListener = new ActionListener() {
            public void actionPerformed(ActionEvent actionEvent) {
                type = choice_Group.getSelection().getActionCommand();
                switch (Integer.parseInt(type)) {
                    case 1: //nuskaitant vartotojo įvestus duomenis išjungiam šiuos laukus:
                        XML_load_Button.setVisible(false);
                        CSV_load_Button.setVisible(false);
                        stock_name_Label.setVisible(false);
                        stock_name_Field.setVisible(false);
                        start_date_Label.setVisible(false);
                        start_month_Box.setVisible(false);
                        start_day_Field.setVisible(false);
                        start_year_Field.setVisible(false);
                        end_date_Label.setVisible(false);
                        end_month_Box.setVisible(false);
                        end_day_Field.setVisible(false);
                        end_year_Field.setVisible(false);
                        daily_Button.setVisible(false);
                        weekly_Button.setVisible(false);
                        monthly_Button.setVisible(false);
                        Yahoo_data_load_Button.setVisible(false);
                        NASDAQ_data_load_Button.setVisible(false);
                        your_data_Area.setVisible(true);
                        your_data_Scroll.setVisible(true);
                        column_Label.setVisible(false);
                        column_Field.setVisible(false);
                        title_Label.setVisible(false);
                        title_yes_Button.setVisible(false);
                        title_no_Button.setVisible(false);
                        read_Label.setVisible(false);
                        read_top_Button.setVisible(false);
                        read_bottom_Button.setVisible(false);
                        stock_list_Box.setVisible(false);
                        currency_Label.setVisible(false);
                        currency_EUR_Button.setVisible(false);
                        currency_LTL_Button.setVisible(false);
                        currency_LVL_Button.setVisible(false);
                        currency_EEK_Button.setVisible(false);
                        currency_No_Button.setVisible(false);
                        scrollPanel1.setVisible(false);
                        break;
                    case 2: //nuskaitant duomenis iš CSV failo išjungiam šiuos laukus:
                        XML_load_Button.setVisible(false);
                        CSV_load_Button.setVisible(true);
                        stock_name_Label.setVisible(false);
                        stock_name_Field.setVisible(false);
                        start_date_Label.setVisible(false);
                        start_month_Box.setVisible(false);
                        start_day_Field.setVisible(false);
                        start_year_Field.setVisible(false);
                        end_date_Label.setVisible(false);
                        end_month_Box.setVisible(false);
                        end_day_Field.setVisible(false);
                        end_year_Field.setVisible(false);
                        daily_Button.setVisible(false);
                        weekly_Button.setVisible(false);
                        monthly_Button.setVisible(false);
                        Yahoo_data_load_Button.setVisible(false);
                        NASDAQ_data_load_Button.setVisible(false);
                        your_data_Area.setText("");
                        your_data_Scroll.setVisible(false);
                        column_Label.setVisible(false);
                        column_Field.setVisible(false);
                        title_Label.setVisible(false);
                        title_yes_Button.setVisible(false);
                        title_no_Button.setVisible(false);
                        read_Label.setVisible(false);
                        read_top_Button.setVisible(false);
                        read_bottom_Button.setVisible(false);
                        stock_list_Box.setVisible(false);
                        currency_Label.setVisible(false);
                        currency_EUR_Button.setVisible(false);
                        currency_LTL_Button.setVisible(false);
                        currency_LVL_Button.setVisible(false);
                        currency_EEK_Button.setVisible(false);
                        currency_No_Button.setVisible(false);
                        scrollPanel1.setVisible(false);
                        break;
                    case 3: //nuskaitant duomenis iš Yahoo išjungiam šiuos laukus:
                        XML_load_Button.setVisible(false);
                        CSV_load_Button.setVisible(false);
                        stock_name_Label.setVisible(true);
                        stock_name_Field.setVisible(true);
                        daily_Button.setVisible(true);
                        weekly_Button.setVisible(true);
                        monthly_Button.setVisible(true);
                        start_date_Label.setVisible(true);
                        start_month_Box.setVisible(true);
                        start_day_Field.setVisible(true);
                        start_year_Field.setVisible(true);
                        end_date_Label.setVisible(true);
                        end_month_Box.setVisible(true);
                        end_day_Field.setVisible(true);
                        end_year_Field.setVisible(true);
                        daily_Button.setVisible(true);
                        weekly_Button.setVisible(true);
                        monthly_Button.setVisible(true);
                        Yahoo_data_load_Button.setVisible(true);
                        NASDAQ_data_load_Button.setVisible(false);
                        your_data_Area.setText("");
                        your_data_Scroll.setVisible(false);
                        column_Label.setVisible(false);
                        column_Field.setVisible(false);
                        title_Label.setVisible(false);
                        title_yes_Button.setVisible(false);
                        title_no_Button.setVisible(false);
                        read_Label.setVisible(false);
                        read_top_Button.setVisible(false);
                        read_bottom_Button.setVisible(false);
                        stock_list_Box.setVisible(false);
                        currency_Label.setVisible(false);
                        currency_EUR_Button.setVisible(false);
                        currency_LTL_Button.setVisible(false);
                        currency_LVL_Button.setVisible(false);
                        currency_EEK_Button.setVisible(false);
                        currency_No_Button.setVisible(false);
                        scrollPanel1.setVisible(false);
                        break;
                    case 4: //nuskaitant duomenis iš NASDAQ išjungiam šiuos laukus:
                        XML_load_Button.setVisible(false);
                        CSV_load_Button.setVisible(false);
                        stock_name_Label.setVisible(true);
                        stock_name_Field.setVisible(false);
                        start_date_Label.setVisible(true);
                        start_month_Box.setVisible(true);
                        start_day_Field.setVisible(true);
                        start_year_Field.setVisible(true);
                        end_date_Label.setVisible(true);
                        end_month_Box.setVisible(true);
                        end_day_Field.setVisible(true);
                        end_year_Field.setVisible(true);
                        daily_Button.setVisible(false);
                        weekly_Button.setVisible(false);
                        monthly_Button.setVisible(false);
                        Yahoo_data_load_Button.setVisible(false);
                        NASDAQ_data_load_Button.setVisible(true);
                        your_data_Area.setText("");
                        your_data_Scroll.setVisible(false);
                        column_Label.setVisible(false);
                        column_Field.setVisible(false);
                        title_Label.setVisible(false);
                        title_yes_Button.setVisible(false);
                        title_no_Button.setVisible(false);
                        read_Label.setVisible(false);
                        read_top_Button.setVisible(false);
                        read_bottom_Button.setVisible(false);
                        stock_list_Box.setVisible(true);
                        currency_Label.setVisible(true);
                        currency_EUR_Button.setVisible(true);
                        currency_LTL_Button.setVisible(true);
                        currency_LVL_Button.setVisible(true);
                        currency_EEK_Button.setVisible(true);
                        currency_No_Button.setVisible(true);
                        scrollPanel1.setVisible(false);
                        break;
                    case 5: //nuskaitant duomenis iš XML failo išjungiam šiuos laukus:
                        XML_load_Button.setVisible(true);
                        CSV_load_Button.setVisible(false);
                        stock_name_Label.setVisible(false);
                        stock_name_Field.setVisible(false);
                        start_date_Label.setVisible(false);
                        start_month_Box.setVisible(false);
                        start_day_Field.setVisible(false);
                        start_year_Field.setVisible(false);
                        end_date_Label.setVisible(false);
                        end_month_Box.setVisible(false);
                        end_day_Field.setVisible(false);
                        end_year_Field.setVisible(false);
                        daily_Button.setVisible(false);
                        weekly_Button.setVisible(false);
                        monthly_Button.setVisible(false);
                        Yahoo_data_load_Button.setVisible(false);
                        NASDAQ_data_load_Button.setVisible(false);
                        your_data_Area.setText("");
                        your_data_Scroll.setVisible(false);
                        column_Label.setVisible(false);
                        column_Field.setVisible(false);
                        title_Label.setVisible(false);
                        title_yes_Button.setVisible(false);
                        title_no_Button.setVisible(false);
                        read_Label.setVisible(false);
                        read_top_Button.setVisible(false);
                        read_bottom_Button.setVisible(false);
                        stock_list_Box.setVisible(false);
                        currency_Label.setVisible(false);
                        currency_EUR_Button.setVisible(false);
                        currency_LTL_Button.setVisible(false);
                        currency_LVL_Button.setVisible(false);
                        currency_EEK_Button.setVisible(false);
                        currency_No_Button.setVisible(false);
                        scrollPanel1.setVisible(false);
                        break;
                }
            }
        };

        //ivairūs programos elementai:

        your_Button = new JRadioButton("Load your data");
        your_Button.setActionCommand("1");
        your_Button.setSelected(true);
        your_Button.addActionListener(myActionListener);
        your_Button.setBounds(10, 10, 300, 20);
        data_Panel.add(your_Button);

        XML_Button = new JRadioButton("Load data from Stock Rate Game Model (*.xml file)");
        XML_Button.setActionCommand("5");
        XML_Button.setSelected(false);
        XML_Button.addActionListener(myActionListener);
        XML_Button.setBounds(10, 30, 380, 20);
        data_Panel.add(XML_Button);

        CSV_Button = new JRadioButton("Load any data from *.csv file");
        CSV_Button.setActionCommand("2");
        CSV_Button.setSelected(false);
        CSV_Button.addActionListener(myActionListener);
        CSV_Button.setBounds(10, 50, 300, 20);
        data_Panel.add(CSV_Button);

        Yahoo_Button = new JRadioButton("Load stock data from Yahoo! Finance");
        Yahoo_Button.setActionCommand("3");
        Yahoo_Button.setSelected(false);
        Yahoo_Button.addActionListener(myActionListener);
        Yahoo_Button.setBounds(10, 70, 300, 20);
        data_Panel.add(Yahoo_Button);

        NASDAQ_Button = new JRadioButton("Load stock data from NASDAQ OMX Baltic");
        NASDAQ_Button.setActionCommand("4");
        NASDAQ_Button.setSelected(false);
        NASDAQ_Button.addActionListener(myActionListener);
        NASDAQ_Button.setBounds(10, 90, 320, 20);
        data_Panel.add(NASDAQ_Button);

        choice_Group = new ButtonGroup();
        choice_Group.add(your_Button);
        choice_Group.add(XML_Button);
        choice_Group.add(CSV_Button);
        choice_Group.add(Yahoo_Button);
        choice_Group.add(NASDAQ_Button);

        your_data_Area = new JTextArea(300,200);
        your_data_Area.setLineWrap(true);
        your_data_Area.setBorder(new CompoundBorder(new LineBorder(Color.GRAY), new EmptyBorder(1, 3, 1, 1)));
        your_data_Scroll = new JScrollPane(your_data_Area);
        your_data_Scroll.setVerticalScrollBarPolicy(22);
        your_data_Scroll.setBounds(10, 120, 300, 200);
        data_Panel.add(your_data_Scroll);
        
        your_data_Area.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                String line = your_data_Area.getText();
                StringTokenizer t = new StringTokenizer(line, "\n");
                entered_data_Count = t.countTokens();
                data_count_AR_Label.setText("You have2 " + entered_data_Count + " data.");
                data_count_ABS_Label.setText("You have " + entered_data_Count + " data.");
                data_count_ARMA_Label.setText("You have " + entered_data_Count + " data.");
                data_count_ARMAABS_Label.setText("You have " + entered_data_Count + " data.");

                training_data_AR_Count = (int)round((entered_data_Count / 2.0), 0);
                training_data_AR_Field.setValue(training_data_AR_Count);
                half_data_AR_Label.setText("data used for training, and " + (entered_data_Count - Integer.parseInt(training_data_AR_Field.getText())) + " data used for testing");

                training_data_ABS_Count = (int)round((entered_data_Count / 2.0), 0);
                training_data_ABS_Field.setValue(training_data_ABS_Count);
                half_data_ABS_Label.setText("data used for training, and " + (entered_data_Count - Integer.parseInt(training_data_ABS_Field.getText())) + " data used for testing");
                
                training_data_ARMA_Count = (int)round((entered_data_Count / 2.0), 0);
                training_data_ARMA_Field.setValue(training_data_ARMA_Count);
                half_data_ARMA_Label.setText("data used for training, and " + (entered_data_Count - Integer.parseInt(training_data_ARMA_Field.getText())) + " data used for testing");
                
                training_data_ARMAABS_Count = (int)round((entered_data_Count / 2.0), 0);
                training_data_ARMAABS_Field.setValue(training_data_ARMAABS_Count);
                half_data_ARMAABS_Label.setText("data used for training, and " + (entered_data_Count - Integer.parseInt(training_data_ARMAABS_Field.getText())) + " data used for testing");
            }
        });
        
        XML_load_Button = new JButton("Load *.xml file");
        LoadXMLFileListener XML_Listener = new LoadXMLFileListener(this);
        XML_load_Button.addActionListener(XML_Listener);
        XML_load_Button.setVisible(false);
        XML_load_Button.setBounds(10, 120, 140, 20);
        data_Panel.add(XML_load_Button);

        CSV_load_Button = new JButton("Load *.csv file");
        CSVFileLoadListener CSV_Listener = new CSVFileLoadListener(this);
        CSV_load_Button.addActionListener(CSV_Listener);
        CSV_load_Button.setVisible(false);
        CSV_load_Button.setBounds(10, 120, 140, 20);
        data_Panel.add(CSV_load_Button);

        stock_name_Label = new JLabel("Stock name:");
        stock_name_Label.setVisible(false);
        stock_name_Label.setBounds(10, 120, 90, 20);
        data_Panel.add(stock_name_Label);

        stock_name_Field = new JTextField();
        stock_name_Field.setText("AAPL");
        stock_name_Field.setVisible(false);
        stock_name_Field.setBounds(100, 120, 100, 20);
        data_Panel.add(stock_name_Field);

        start_date_Label = new JLabel("Start date:");
        start_date_Label.setVisible(false);
        start_date_Label.setBounds(10, 150, 80, 20);
        data_Panel.add(start_date_Label);

        cal = Calendar.getInstance();
        int day_now = cal.get(Calendar.DAY_OF_MONTH);
        int month_now = cal.get(Calendar.MONTH);
        int year_now = cal.get(Calendar.YEAR);

        Calendar cal2 = Calendar.getInstance();
        cal2.add(Calendar.MONTH, -18);
        int day_before = cal2.get(Calendar.DAY_OF_MONTH);
        int month_before = cal2.get(Calendar.MONTH);
        int year_before = cal2.get(Calendar.YEAR);

        start_year_Formatter = new NumberFormatter(new DecimalFormat("####"));
        start_year_Formatter.setMinimum(1800);
        start_year_Formatter.setMaximum(3000);
        start_year_Formatter.setValueClass(Integer.class);
        start_year_Field = new JFormattedTextField(start_year_Formatter);
        start_year_Field.setColumns(4);
        start_year_Field.setText("" + year_before);
        start_year_Field.setVisible(false);
        start_year_Field.setBounds(100, 150, 50, 20);
        data_Panel.add(start_year_Field);

        String[] months_String = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
        start_month_Box = new JComboBox(months_String);
        start_month_Box.setSelectedIndex(month_before);
        start_month_Box.setVisible(false);
        start_month_Box.setBounds(155, 150, 55, 20);
        data_Panel.add(start_month_Box);

        start_day_Formatter = new NumberFormatter(new DecimalFormat("##"));
        start_day_Formatter.setMinimum(1);
        start_day_Formatter.setMaximum(31);
        start_day_Formatter.setValueClass(Integer.class);
        start_day_Field = new JFormattedTextField(start_day_Formatter);
        start_day_Field.setColumns(2);
        start_day_Field.setText("" + day_before);
        start_day_Field.setVisible(false);
        start_day_Field.setBounds(215, 150, 30, 20);
        data_Panel.add(start_day_Field);

        end_date_Label = new JLabel("End date:");
        end_date_Label.setVisible(false);
        end_date_Label.setBounds(260, 150, 150, 20);
        data_Panel.add(end_date_Label);

        end_year_Formatter = new NumberFormatter(new DecimalFormat("####"));
        end_year_Formatter.setMinimum(1800);
        end_year_Formatter.setMaximum(3000);
        end_year_Formatter.setValueClass(Integer.class);
        end_year_Field = new JFormattedTextField(end_year_Formatter);
        end_year_Field.setColumns(4);
        end_year_Field.setText("" + year_now);
        end_year_Field.setVisible(false);
        end_year_Field.setBounds(335, 150, 50, 20);
        data_Panel.add(end_year_Field);

        end_month_Box = new JComboBox(months_String);
        end_month_Box.setSelectedIndex(month_now);
        end_month_Box.setVisible(false);
        end_month_Box.setBounds(390, 150, 55, 20);
        data_Panel.add(end_month_Box);

        end_day_Formatter = new NumberFormatter(new DecimalFormat("##"));
        end_day_Formatter.setMinimum(1);
        end_day_Formatter.setMaximum(31);
        end_day_Formatter.setValueClass(Integer.class);
        end_day_Field = new JFormattedTextField(end_day_Formatter);
        end_day_Field.setColumns(2);
        end_day_Field.setText("" + day_now);
        end_day_Field.setVisible(false);
        end_day_Field.setBounds(450, 150, 30, 20);
        data_Panel.add(end_day_Field);

        daily_Button = new JRadioButton("Daily");
        daily_Button.setActionCommand("d");
        daily_Button.setSelected(true);
        daily_Button.setVisible(false);
        daily_Button.setBounds(500, 120, 100, 20);
        data_Panel.add(daily_Button);

        weekly_Button = new JRadioButton("Weekly");
        weekly_Button.setActionCommand("w");
        weekly_Button.setVisible(false);
        weekly_Button.setBounds(500, 140, 100, 20);
        data_Panel.add(weekly_Button);

        monthly_Button = new JRadioButton("Monthly");
        monthly_Button.setActionCommand("m");
        monthly_Button.setVisible(false);
        monthly_Button.setBounds(500, 160, 100, 20);
        data_Panel.add(monthly_Button);

        type_Group = new ButtonGroup();
        type_Group.add(daily_Button);
        type_Group.add(weekly_Button);
        type_Group.add(monthly_Button);

        column_Label = new JLabel("Column number to use for forecasting:");
        column_Label.setVisible(false);
        data_Panel.add(column_Label);

        column_Formatter = new NumberFormatter(new DecimalFormat("###"));
        column_Formatter.setMinimum(1);
        column_Formatter.setMaximum(100);
        column_Formatter.setValueClass(Integer.class);
        column_Field = new JFormattedTextField(column_Formatter);
        column_Field.setColumns(3);
        column_Field.setVisible(false);
        data_Panel.add(column_Field);

        title_Label = new JLabel("First row is title");
        title_Label.setVisible(false);
        data_Panel.add(title_Label);

        title_yes_Button = new JRadioButton("yes");
        title_yes_Button.setActionCommand("y");
        title_yes_Button.setVisible(false);
        data_Panel.add(title_yes_Button);

        title_no_Button = new JRadioButton("no");
        title_no_Button.setActionCommand("n");
        title_no_Button.setSelected(true);
        title_no_Button.setVisible(false);
        data_Panel.add(title_no_Button);

        TableTitleListener table_title_Listener = new TableTitleListener(this);
        title_yes_Button.addActionListener(table_title_Listener);
        title_no_Button.addActionListener(table_title_Listener);

        title_Group = new ButtonGroup();
        title_Group.add(title_yes_Button);
        title_Group.add(title_no_Button);

        read_Label = new JLabel("Data read from");
        read_Label.setVisible(false);
        data_Panel.add(read_Label);

        read_top_Button = new JRadioButton("top to bottom");
        read_top_Button.setActionCommand("1");
        read_top_Button.setVisible(false);
        data_Panel.add(read_top_Button);

        read_bottom_Button = new JRadioButton("bottom to top");
        read_bottom_Button.setActionCommand("2");
        read_bottom_Button.setVisible(false);
        data_Panel.add(read_bottom_Button);

        read_Group = new ButtonGroup();
        read_Group.add(read_top_Button);
        read_Group.add(read_bottom_Button);

        Yahoo_data_load_Button = new JButton("Load data from Yahoo");
        LoadYahooDataListener Yahoo_Listener = new LoadYahooDataListener(this);
        Yahoo_data_load_Button.addActionListener(Yahoo_Listener);
        Yahoo_data_load_Button.setVisible(false);
        Yahoo_data_load_Button.setBounds(10, 180, 190, 20);
        data_Panel.add(Yahoo_data_load_Button);

        Select[] stock_list = new Select[]{
            new Select("LT0000102337", "APG1L - Apranga (Lithuania)"),
            new Select("EE3100034653", "ARC1T - Arco Vara (Estonia)"),
            new Select("EE3100003609", "BLT1T - Baltika (Estonia)"),
            new Select("LT0000127375", "CTS1L - City Service AB (Lithuania)"),
            new Select("EE3100016965", "EEG1T - Ekspress Grupp (Estonia)"),
            new Select("LV0000100659", "GRD1R - Grindeks (Latvia)"),
            new Select("LT0000102030", "GRG1L - Grigiškės (Lithuania)"),
            new Select("EE3100004250", "HAE1T - Harju Elekter (Estonia)"),
            new Select("LT0000102279", "IVL1L - Invalda (Lithuania)"),
            new Select("LT0000116220", "LDJ1L - Lietuvos dujos (Lithuania)"),
            new Select("LT0000128449", "LES1L - LESTO AB (Lithuania)"),
            new Select("LT0000128092", "LNA1L - Linas Agro Group (Lithuania)"),
            new Select("LV0000101103", "LSC1R - Latvijas kuģniecība (Latvia)"),
            new Select("EE3100098328", "MRK1T - Merko Ehitus (Estonia)"),
            new Select("EE3100039496", "NCN1T - Nordecon AS (Estonia)"),
            new Select("EE3100084021", "OEG1T - Olympic Entertainment Group (Estonia)"),
            new Select("LV0000100501", "OLF1R - Olainfarm (Latvia)"),
            new Select("EE3100101031", "PRF1T - Premia Foods AS (Estonia)"),
            new Select("LT0000101446", "PTR1L - Panevėžio statybos trestas (Lithuania)"),
            new Select("LT0000111676", "PZV1L - Pieno žvaigždės (Lithuania)"),
            new Select("LT0000100372", "RSU1L - Rokiškio sūris (Lithuania)"),
            new Select("LT0000102253", "SAB1L - Šiaulių bankas (Lithuania)"),
            new Select("LV0000101129", "SAF1R - SAF Tehnika (Latvia)"),
            new Select("LT0000106171", "SAN1L - Sanitas (Lithuania)"),
            new Select("EE3100001751", "SFGAT - Silvano Fashion Group (Estonia)"),
            new Select("EE3100001751", "SRS1L - Snoras (Lithuania)"),
            new Select("EE3100004466", "TAL1T - Tallink Grupp (Estonia)"),
            new Select("LT0000123911", "TEO1L - TEO LT (Lithuania)"),
            new Select("EE0000001105", "TKM1T - Tallinna Kaubamaja (Estonia)"),
            new Select("EE3100003443", "TPD1T - Trigon Property Development (Estonia)"),
            new Select("EE3100026436", "TVEAT - Tallinna Vesi (Estonia)"),
            new Select("LT0000102352", "UKB1L - Ūkio bankas (Lithuania)"),
            new Select("LT0000109324", "UTR1L - Utenos trikotažas (Lithuania)"),
            new Select("LT0000104267", "VBL1L - Vilniaus baldai (Lithuania)"),
            new Select("LT0000127508", "VLP1L - Vilkyškių pieninė (Lithuania)"),
            new Select("LV0000100816", "VNF1R - Ventspils nafta (Latvia)"),
            new Select("EE3100092503", "VSN1T - Viisnurk (Estonia)"),
            new Select("LT0000128266", "AGP1L - Įmonių grupė ALITA (Lithuania)"),
            new Select("LT0000112773", "ANK1L - Anykščių vynas (Lithuania)"),
            new Select("LT0000127466", "AVG1L - Agrowill Group (Lithuania)"),
            new Select("LV0000100808", "BAL1R - Latvijas balzams (Latvia)"),
            new Select("LV0000100824", "BRV1R - Brivais Vilnis (Latvia)"),
            new Select("LT0000122319", "DKR1L - Dvarčionių keramika (Lithuania)"),
            new Select("LV0000100212", "DPK1R - Ditton pievadķēžu rūpnīca (Latvia)"),
            new Select("LV0000100782", "FRM1R - Rīgas farmaceitiskā fabrika (Latvia)"),
            new Select("LV0000100527", "GRZ1R - Grobiņa (Latvia)"),
            new Select("LT0000114357", "GUB1L - Gubernija (Lithuania)"),
            new Select("LV0000100899", "GZE1R - Latvijas Gāze (Latvia)"),
            new Select("EE3100003559", "JRV1T - Järvevana (Estonia)"),
            new Select("LV0000100402", "KA11R - Kurzemes atslēga 1 (Latvia)"),
            new Select("LT0000102972", "KBL1L - Klaipėdos baldai (Lithuania)"),
            new Select("LV0000100949", "KCM1R - Kurzemes CMAS (Latvia)"),
            new Select("LT0000111650", "KNF1L - Klaipėdos nafta (Lithuania)"),
            new Select("LT0000123010", "KNR1L - Kauno energija (Lithuania)"),
            new Select("LV0000100907", "LAP1R - Liepājas autobusu parks (Latvia)"),
            new Select("LT0000126351", "LEL1L - Lietuvos elektrinė (Lithuania)"),
            new Select("LT0000117681", "LEN1L - Lietuvos energija (Lithuania)"),
            new Select("LT0000116691", "LFO1L - Lifosa (Lithuania)"),
            new Select("LT0000128415", "LGD1L - LITGRID AB (Lithuania)"),
            new Select("LT0000125999", "LJL1L - Lietuvos jūrų laivininkystė (Lithuania)"),
            new Select("LV0000100741", "LJM1R - Latvijas Jūras medicīnas centrs (Latvia)"),
            new Select("LT0000119646", "LLK1L - Limarko laivininkystės kompanija (Lithuania)"),
            new Select("LV0000100535", "LME1R - Liepājas metalurgs (Latvia)"),
            new Select("LT0000100661", "LNS1L - Linas (Lithuania)"),
            new Select("LV0000101061", "LOK1R - Daugavpils Lokomotīvju remonta rūpnīca (Latvia)"),
            new Select("LV0000100311", "LTT1R - Latvijas tilti (Latvia)"),
            new Select("LV0000100915", "NKA1R - Nordeka (Latvia)"),
            new Select("LV0000100568", "OLK1R - Olaines kūdra (Latvia)"),
            new Select("LV0000100881", "RAR1R - Rīgas autoelektroaparātu rūpnīca (Latvia)"),
            new Select("LV0000101012", "RER1R - Rigas elektromasinbuves rupnica (Latvia)"),
            new Select("LV0000100543", "RJR1R - Rīgas juvelierizstrādājumu rūpnīca (Latvia)"),
            new Select("LV0000100378", "RKB1R - Rīgas kuģu būvētava (Latvia)"),
            new Select("LV0000100972", "RRR1R - VEF Radiotehnika RRR (Latvia)"),
            new Select("LV0000100600", "SCM1R - Siguldas CMAS (Latvia)"),
            new Select("LV0000100154", "SMA1R - Saldus mežrūpniecība (Latvia)"),
            new Select("LT0000109274", "SNG1L - Snaigė (Lithuania)"),
            new Select("LT0000127623", "SRS2L - Snoras (Lithuania)"),
            new Select("LT0000119430", "STU1L - Stumbras (Lithuania)"),
            new Select("LV0000101095", "TKB1R - Tosmares kuģubūvētava (Latvia)"),
            new Select("LV0000100139", "TMA1R - Talsu mezrupnieciba (Latvia)"),
            new Select("LT0000112450", "VDG1L - Vilniaus degtinė (Lithuania)"),
            new Select("LV0000101079", "VEF1R - VEF (Latvia)"),
            new Select("LV0000100485", "VSS1R - Valmieras stikla šķiedra (Latvia)"),
            new Select("LT0000121865", "ZMP1L - Žemaitijos pienas (Lithuania)"),
            new Select("LV0000100758", "ZOV1R - Latvijas Zoovetapgāde (Latvia)")
        };
        stock_list_Box = new JComboBox(stock_list);
        stock_list_Box.setVisible(false);
        stock_list_Box.setBounds(100, 120, 400, 20);
        data_Panel.add(stock_list_Box);
        
        currency_Label = new JLabel("Currency:");
        currency_Label.setVisible(false);
        currency_Label.setBounds(10, 180, 70, 20);
        data_Panel.add(currency_Label);

        currency_EUR_Button = new JRadioButton("EUR");
        currency_EUR_Button.setActionCommand("EUR");
        currency_EUR_Button.setSelected(true);
        currency_EUR_Button.setVisible(false);
        currency_EUR_Button.setBounds(90, 180, 55, 20);
        data_Panel.add(currency_EUR_Button);

        currency_LTL_Button = new JRadioButton("LTL");
        currency_LTL_Button.setActionCommand("LTL");
        currency_LTL_Button.setVisible(false);
        currency_LTL_Button.setBounds(145, 180, 55, 20);
        data_Panel.add(currency_LTL_Button);

        currency_LVL_Button = new JRadioButton("LVL");
        currency_LVL_Button.setActionCommand("LVL");
        currency_LVL_Button.setVisible(false);
        currency_LVL_Button.setBounds(200, 180, 55, 20);
        data_Panel.add(currency_LVL_Button);

        currency_EEK_Button = new JRadioButton("EEK");
        currency_EEK_Button.setActionCommand("EEK");
        currency_EEK_Button.setVisible(false);
        currency_EEK_Button.setBounds(255, 180, 55, 20);
        data_Panel.add(currency_EEK_Button);

        currency_No_Button = new JRadioButton("Original currency");
        currency_No_Button.setActionCommand("0");
        currency_No_Button.setVisible(false);
        currency_No_Button.setBounds(310, 180, 150, 20);
        data_Panel.add(currency_No_Button);

        currency_Group = new ButtonGroup();
        currency_Group.add(currency_EUR_Button);
        currency_Group.add(currency_EEK_Button);
        currency_Group.add(currency_LVL_Button);
        currency_Group.add(currency_LTL_Button);
        currency_Group.add(currency_No_Button);

        NASDAQ_data_load_Button = new JButton("Load data from NASDAQ");
        LoadNASDAQDataListener NASDAQ_Listener = new LoadNASDAQDataListener(this);
        NASDAQ_data_load_Button.addActionListener(NASDAQ_Listener);
        NASDAQ_data_load_Button.setVisible(false);
        NASDAQ_data_load_Button.setBounds(10, 210, 210, 20);
        data_Panel.add(NASDAQ_data_load_Button);
    }

    private void createARpage() {
        AR_Panel = new JPanel();
        AR_Panel.setLayout(null);

        p_Label = new JLabel("p value");
        p_Label.setBounds(10, 10, 150, 20);
        AR_Panel.add(p_Label);

        p_Formatter = new NumberFormatter(new DecimalFormat("###"));
        p_Formatter.setMinimum(1);
        p_Formatter.setMaximum(100);
        p_Formatter.setValueClass(Integer.class);
        p_AR_Field = new JFormattedTextField(p_Formatter);
        p_AR_Field.setColumns(3);
        p_AR_Field.setValue(2);
        p_AR_Field.setBounds(70, 10, 40, 20);
        AR_Panel.add(p_AR_Field);

        recalc_Label = new JLabel("Recalculate coefficients after each step:");
        recalc_Label.setBounds(10, 40, 240, 20);
        AR_Panel.add(recalc_Label);

        recalc_yes_AR_Button = new JRadioButton("yes");
        recalc_yes_AR_Button.setActionCommand("1");
        recalc_yes_AR_Button.setBounds(250, 40, 50, 20);
        AR_Panel.add(recalc_yes_AR_Button);

        recalc_no_AR_Button = new JRadioButton("no (recommended)");
        recalc_no_AR_Button.setActionCommand("2");
        recalc_no_AR_Button.setSelected(true);
        recalc_no_AR_Button.setBounds(300, 40, 200, 20);
        AR_Panel.add(recalc_no_AR_Button);

        recalc_AR_Group = new ButtonGroup();
        recalc_AR_Group.add(recalc_yes_AR_Button);
        recalc_AR_Group.add(recalc_no_AR_Button);

        virtual_data_AR_Label = new JLabel("Use virtual data (for finding all predictions)");
        virtual_data_AR_Label.setBounds(10, 70, 270, 20);
        AR_Panel.add(virtual_data_AR_Label);

        virtual_data_yes_AR_Button = new JRadioButton("yes");
        virtual_data_yes_AR_Button.setActionCommand("1");
        virtual_data_yes_AR_Button.setBounds(290, 70, 50, 20);
        AR_Panel.add(virtual_data_yes_AR_Button);

        virtual_data_no_AR_Button = new JRadioButton("no (recommended)");
        virtual_data_no_AR_Button.setActionCommand("2");
        virtual_data_no_AR_Button.setSelected(true);
        virtual_data_no_AR_Button.setBounds(350, 70, 200, 20);
        AR_Panel.add(virtual_data_no_AR_Button);

        virtual_data_AR_Group = new ButtonGroup();
        virtual_data_AR_Group.add(virtual_data_yes_AR_Button);
        virtual_data_AR_Group.add(virtual_data_no_AR_Button);

        data_count_AR_Label = new JLabel();
        data_count_AR_Label.setBounds(10, 100, 110, 20);
        AR_Panel.add(data_count_AR_Label);

        training_data_Formatter = new NumberFormatter(new DecimalFormat("###"));
        training_data_Formatter.setMinimum(1);
        training_data_Formatter.setMaximum(100);
        training_data_Formatter.setValueClass(Integer.class);
        training_data_AR_Field = new JFormattedTextField(training_data_Formatter);
        training_data_AR_Field.setColumns(3);
        training_data_AR_Field.setBounds(130, 100, 40, 20);
        AR_Panel.add(training_data_AR_Field);

        training_data_AR_Field.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                half_data_AR_Label.setText("data used for training, and " + (entered_data_Count - Integer.parseInt(training_data_AR_Field.getText())) + " data used for testing");
                training_data_AR_Count = Integer.parseInt(training_data_AR_Field.getText());
                testing_data_AR_Count = entered_data_Count - Integer.parseInt(training_data_AR_Field.getText());
            }
        });

        half_data_AR_Label = new JLabel();
        half_data_AR_Label.setBounds(180, 100, 300, 20);
        AR_Panel.add(half_data_AR_Label);

        data_mean_AR_Label = new JLabel("Data mean");
        data_mean_AR_Label.setVisible(false);
        data_mean_AR_Label.setBounds(10, 565, 300, 20);
        AR_Panel.add(data_mean_AR_Label);

        data_mean_value_AR_Label = new JLabel();
        data_mean_value_AR_Label.setBounds(300, 565, 300, 20);
        AR_Panel.add(data_mean_value_AR_Label);

        data_variance_AR_Label = new JLabel("Data standard");
        data_variance_AR_Label.setVisible(false);
        data_variance_AR_Label.setBounds(10, 590, 300, 20);
        AR_Panel.add(data_variance_AR_Label);

        data_variance_value_AR_Label = new JLabel();
        data_variance_value_AR_Label.setBounds(300, 590, 300, 20);
        AR_Panel.add(data_variance_value_AR_Label);

        MAE_AR_Label = new JLabel("Mean absolute error (MAE)");
        MAE_AR_Label.setVisible(false);
        MAE_AR_Label.setBounds(10, 615, 300, 20);
        AR_Panel.add(MAE_AR_Label);

        MAE_value_AR_Label = new JLabel();
        MAE_value_AR_Label.setBounds(300, 615, 300, 20);
        AR_Panel.add(MAE_value_AR_Label);

        MAPE_AR_Label = new JLabel("Mean absolute percentage error (MAPE)");
        MAPE_AR_Label.setVisible(false);
        MAPE_AR_Label.setBounds(10, 640, 300, 20);
        AR_Panel.add(MAPE_AR_Label);

        MAPE_value_AR_Label = new JLabel();
        MAPE_value_AR_Label.setBounds(300, 640, 300, 20);
        AR_Panel.add(MAPE_value_AR_Label);

        PMAD_AR_Label = new JLabel("Percent mean absolute deviation (PMAD)");
        PMAD_AR_Label.setVisible(false);
        PMAD_AR_Label.setBounds(10, 665, 300, 20);
        AR_Panel.add(PMAD_AR_Label);

        PMAD_value_AR_Label = new JLabel();
        PMAD_value_AR_Label.setBounds(300, 665, 300, 20);
        AR_Panel.add(PMAD_value_AR_Label);

        MSE_AR_Label = new JLabel("Mean squared error (MSE)");
        MSE_AR_Label.setVisible(false);
        MSE_AR_Label.setBounds(10, 690, 300, 20);
        AR_Panel.add(MSE_AR_Label);

        MSE_value_AR_Label = new JLabel();
        MSE_value_AR_Label.setBounds(300, 690, 300, 20);
        AR_Panel.add(MSE_value_AR_Label);

        RMSE_AR_Label = new JLabel("Root mean squared error (RMSE)");
        RMSE_AR_Label.setVisible(false);
        RMSE_AR_Label.setBounds(10, 715, 300, 20);
        AR_Panel.add(RMSE_AR_Label);

        RMSE_value_AR_Label = new JLabel();
        RMSE_value_AR_Label.setBounds(300, 715, 300, 20);
        AR_Panel.add(RMSE_value_AR_Label);

        residual_variance_AR_Label = new JLabel("Residual variance");
        residual_variance_AR_Label.setVisible(false);
        residual_variance_AR_Label.setBounds(10, 740, 300, 20);
        AR_Panel.add(residual_variance_AR_Label);

        residual_variance_value_AR_Label = new JLabel();
        residual_variance_value_AR_Label.setBounds(300, 740, 300, 20);
        AR_Panel.add(residual_variance_value_AR_Label);

        button2 = new JButton("Calculate");
        button2.addActionListener(new ActionListener() {
            private String data[][];
            private int start_AR;
            private String info_msg;
            public void actionPerformed(ActionEvent evt) {
                start_AR = 0;
                info_msg = "";
                real_AR_Series = new TimeSeries("Actual value", Day.class);
                
                /* Kusok dlia Igoria
                 * 
                    loadYahooData yahoo = new loadYahooData("GOOG",2011,5,1,2011,9,30);
                    String yahoo_data[][] = yahoo.rezult();
                    double my_data[] = new double[yahoo_data.length];
                    int j_ = 0;
                    for (int i = yahoo_data.length-1; i >= 0; i--) {
                        my_data[j_] = Double.parseDouble(yahoo_data[i][4]);
                        j_++;
                    }
                 *
                */

                int k = 0;
                if (!your_data_Area.getText().equals("")) { //jeigu duomenis nuskaitom iš textArea lauko
                    String line = your_data_Area.getText();
                    StringTokenizer t = new StringTokenizer(line, "\n");
                    data = new String[entered_data_Count][5];
                    entered_data_AR = new double[entered_data_Count];
                    while (t.hasMoreTokens()) {
                        entered_data_AR[k] = Double.parseDouble(t.nextToken());
                        data[k][0] = Integer.toString(k+1) + ".";
                        data[k][1] = Double.toString(entered_data_AR[k]);
                        Date now = new Date();
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(now);
                        cal.add(Calendar.DAY_OF_YEAR, k+1);
                        Date tomorrow = cal.getTime();
                        real_AR_Series.add(new Day(tomorrow), entered_data_AR[k]);
                        k++;
                    }
                }
                else { //jeigu duomenis nuskaitom iš lentelės
                    String read_from = read_Group.getSelection().getActionCommand();
                    if ( type.equals("5") ) column_number = 1;
                    else column_number = Integer.parseInt(column_Field.getText());
                    data = new String[entered_data_Count][5];
                    entered_data_AR = new double[entered_data_Count];

                    if (Integer.parseInt(read_from) == 1) { //jeigu duomenis nuskaitom iš viršaus į apačią
                        for (int i = 0; i < entered_data_Count; i++) {
                            entered_data_AR[k] = Double.parseDouble(table1.getValueAt(i, column_number-1).toString());
                            data[k][0] = Integer.toString(k+1) + "."; //numeracija
                            data[k][1] = String.valueOf(table1.getValueAt(i, column_number-1));  //realūs duomenys
                            Date now = new Date();
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(now);
                            cal.add(Calendar.DAY_OF_YEAR, k+1);
                            Date tomorrow = cal.getTime();
                            real_AR_Series.add(new Day(tomorrow), entered_data_AR[k]);
                            k++;
                        }
                    }
                    else { //jeigu duomenis nuskaitom iš apačios į viršų
                        for (int i = entered_data_Count-1; i >= 0; i--) {
                            entered_data_AR[k] = Double.parseDouble(table1.getValueAt(i, column_number-1).toString());
                            data[k][0] = Integer.toString(k+1) + "."; //numeracija
                            data[k][1] = String.valueOf(table1.getValueAt(i, column_number-1)); //realūs duomenys
                            Date now = new Date();
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(now);
                            cal.add(Calendar.DAY_OF_YEAR, k+1);
                            Date tomorrow = cal.getTime();
                            real_AR_Series.add(new Day(tomorrow), entered_data_AR[k]);
                            k++;
                        }
                    }
                }

                String titles[] = new String[4];
                titles[0] = "No.";
                titles[1] = "Actual value";
                titles[2] = "Forecast";
                titles[3] = "Error";

                p_value_AR = Integer.parseInt(p_AR_Field.getText());

                double training_error_sum = 0;
                double bendra_suma2 = 0;
                double bendra_suma3 = 0;
                double bendra_suma4 = 0;
                double bendra_suma5 = 0;
                forecast_AR_Series = new TimeSeries("Forecast", Day.class);

                String recalc = recalc_AR_Group.getSelection().getActionCommand();
                String virtual_data = virtual_data_AR_Group.getSelection().getActionCommand();
                AR_method ar_ = null;
                if (recalc.equals("2")) { //jeigu koeficientus kas žingsnį neperskaičiuojam
                    if (virtual_data.equals("1")) { //jeigu naudojam atbulinius duomenis
                        start_AR = 0;
                        double[] back_data_array = back_data_array(training_data_AR_Count+p_value_AR, training_data_AR_Count, entered_data_AR);
                        ar_ = new AR_method(back_data_array, p_value_AR);
                        coef_AR = ar_.rezult();
                        if ( coef_AR.length < p_value_AR ) info_msg = "1. No optimal solution\np value was reduced to " + coef_AR.length;
                    }
                    else { //jeigu nenaudojam atbulinių duomenų
                        start_AR = p_value_AR;
                        double[] use_array = new double[training_data_AR_Count];
                        System.arraycopy(entered_data_AR, 0, use_array, 0, training_data_AR_Count);
                        if ( use_array.length < p_value_AR*2 )
                            JOptionPane.showMessageDialog(AR_Panel, "Too few data.", "Error", JOptionPane.ERROR_MESSAGE);
                        else {
                            ar_ = new AR_method(use_array, p_value_AR);
                            coef_AR = ar_.rezult();
                            if ( coef_AR.length < p_value_AR ) info_msg = "2. No optimal solution\np value was reduced to " + coef_AR.length;
                        }
                    } 
                }
                else {
                    if (virtual_data.equals("1")) start_AR = 0;
                    else start_AR = p_value_AR;
                }

                int count = 0;
                suma_array = new double[training_data_AR_Count];
                int msg_count = 0;
                for (int i = start_AR; i < training_data_AR_Count; i++) {
                    used_data_AR = new double[i];
                    System.arraycopy(entered_data_AR, 0, used_data_AR, 0, i);
                    if (used_data_AR.length < p_value_AR*2) {
                        used_data_AR = back_data_array(p_value_AR*2, used_data_AR.length, entered_data_AR);
                    }
                        
                    if ( recalc.equals("1") ) { //jeigu koeficientus kas žingsnį perskaičiuojam
                        ar_ = new AR_method(used_data_AR, p_value_AR);
                        coef_AR = ar_.rezult();
                        if ( coef_AR.length < p_value_AR ) {
                            msg_count++;
                            if ( msg_count == 1 ) info_msg = "No optimal solutions in few steps:\n";
                            info_msg = info_msg + "In " + (i+1) + " step p value was reduced to " + coef_AR.length + "\n";
                        } 
                    }
                    
                    double suma = 0;
                    for (int j = 0; j < coef_AR.length; j++) {
                        suma += coef_AR[j] * used_data_AR[used_data_AR.length-j-1];
                        //System.out.println( coef_AR[j] + " * " + used_data_AR[used_data_AR.length-j-1] );
                    }
                    
                    suma_array[count] = suma;
                   
                    if (i < training_data_AR_Count) {
                        data[i][2] = Double.toString(round(suma_array[count],3)); //prognozuojami duomenys
                        Date now = new Date();
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(now);
                        cal.add(Calendar.DAY_OF_YEAR, i+1);
                        Date tomorrow = cal.getTime();
                        forecast_AR_Series.add(new Day(tomorrow), suma_array[count]);
                        double error = entered_data_AR[i] - suma_array[count];
                        bendra_suma5 += error;
                        if (error < 0) error = error * (-1);
                        data[i][3] = Double.toString(round(error,3)); //paklaida
                        training_error_sum += error;
                        bendra_suma2 += error / entered_data_AR[i];
                        bendra_suma3 += entered_data_AR[i];
                        bendra_suma4 += error * error;
                    }
                    count++;
                }

                data_mean_AR_Label.setVisible(true);
                data_variance_AR_Label.setVisible(true);
                MAE_AR_Label.setVisible(true);
                MAPE_AR_Label.setVisible(true);
                PMAD_AR_Label.setVisible(true);
                MSE_AR_Label.setVisible(true);
                RMSE_AR_Label.setVisible(true);
                residual_variance_AR_Label.setVisible(true);
                test_AR_Button.setVisible(true);
                graphic_AR_Button.setVisible(true);
                save_CSV_AR_Button.setVisible(true);
                forecast_AR_Label.setVisible(true);
                forecast_AR_Field.setVisible(true);

                if (data_AR_Table != null) {
                    data_table_AR_Scroll.remove(data_AR_Table);
                    data_AR_Table = null;
                }
                data_AR_Table = new JTable(data, titles) {
                    @Override
                    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                        Component c = super.prepareRenderer(renderer, row, column);
                        if (row < training_data_AR_Count) c.setBackground(new Color(200,221,242));
                        else c.setBackground(null);
                        return c;
                    }
                };
                if (data_table_AR_Scroll != null) {
                    AR_Panel.remove(data_table_AR_Scroll);
                    data_table_AR_Scroll = null;
                }
                data_table_AR_Scroll = new JScrollPane(data_AR_Table);
                data_table_AR_Scroll.setVerticalScrollBarPolicy(22);
                data_table_AR_Scroll.setBounds(10, 160, 400, 337);
                AR_Panel.add(data_table_AR_Scroll);

                String titles2[] = new String[2];
                titles2[0] = "No.";
                titles2[1] = "Coefficient";

                String data2 [][] = new String[p_value_AR][2];

                for (int i = 0; i < coef_AR.length; i++) {
                    data2[i][0] = Integer.toString(i+1) + ".";
                    //data2[i][1] = Double.toString(round(coef_AR[i],3));
                    data2[i][1] = Double.toString(coef_AR[i]);
                }
                if (p_value_AR > coef_AR.length) {
                    for (int i = coef_AR.length; i < p_value_AR; i++) {
                        data2[i][0] = Integer.toString(i+1) + ".";
                        data2[i][1] = "0.0";
                    }
                }

                if (coef_AR_Table != null) {
                    coef_table_AR_Scroll.remove(coef_AR_Table);
                    coef_AR_Table = null;
                }
                coef_AR_Table = new JTable(data2, titles2);
                if (coef_table_AR_Scroll != null) {
                    AR_Panel.remove(coef_table_AR_Scroll);
                    coef_table_AR_Scroll = null;
                }
                coef_table_AR_Scroll = new JScrollPane(coef_AR_Table);
                coef_table_AR_Scroll.setVerticalScrollBarPolicy(22);
                coef_table_AR_Scroll.setBounds(430, 160, 200, 337);
                AR_Panel.add(coef_table_AR_Scroll);

                double data_mean = 0;
                int c = 0;
                double training_data_sum = 0, training_data_sum2 = 0;
                for (int i = 0; i < entered_data_AR.length; i++) {
                    training_data_sum += entered_data_AR[i];
                    training_data_sum2 += entered_data_AR[i]*entered_data_AR[i];
                    c++;
                }
                data_mean = training_data_sum / entered_data_AR.length;
                data_mean_value_AR_Label.setText(" = " + Double.toString(round(data_mean, 3)));

                double data_variance = 0;
                data_variance = (training_data_sum2 - ((training_data_sum*training_data_sum)/c)) / (c - 1);
                data_variance_value_AR_Label.setText(" = " + Double.toString(round(data_variance, 3)));

                double MAE = 0;
                if (training_error_sum == Double.NaN || training_error_sum == Double.POSITIVE_INFINITY || training_error_sum == Double.NEGATIVE_INFINITY ||
                    training_error_sum == 0.0)
                    MAE = 0;
                else MAE = training_error_sum / count;
                MAE_value_AR_Label.setText(" = " + Double.toString(round(MAE, 3)));

                double MAPE = 0;
                if (bendra_suma2 == Double.NaN || bendra_suma2 == Double.POSITIVE_INFINITY || bendra_suma2 == Double.NEGATIVE_INFINITY ||
                    training_error_sum == 0.0)
                    MAPE = 0;
                else MAPE = bendra_suma2 / count;
                MAPE_value_AR_Label.setText(" = " + Double.toString(round(MAPE, 3)));

                double PMAD = 0;
                if (training_error_sum == Double.NaN || training_error_sum == Double.POSITIVE_INFINITY || training_error_sum == Double.NEGATIVE_INFINITY ||
                    bendra_suma3 == Double.NaN || bendra_suma3 == Double.POSITIVE_INFINITY || bendra_suma3 == Double.NEGATIVE_INFINITY ||
                    training_error_sum == 0.0 || bendra_suma3 == 0.0)
                        PMAD = 0;
                else PMAD = training_error_sum / bendra_suma3;
                PMAD_value_AR_Label.setText(" = " + Double.toString(round(PMAD, 3)));

                double MSE = 0;
                if (bendra_suma4 == Double.NaN || bendra_suma4 == Double.POSITIVE_INFINITY || bendra_suma4 == Double.NEGATIVE_INFINITY ||
                    bendra_suma4 == 0.0)
                    MSE = 0;
                else MSE = bendra_suma4 / count;
                MSE_value_AR_Label.setText(" = " + Double.toString(round(MSE, 3)));

                double RMSE = 0;
                if (MSE == 0.0) RMSE = 0;
                else RMSE = Math.sqrt(MSE);
                RMSE_value_AR_Label.setText(" = " + Double.toString(round(RMSE, 3)));

                double residual_variance = 0;
                if ( count-1 > 0 ) residual_variance = (bendra_suma4 - ((bendra_suma5*bendra_suma5)/count)) / (count - 1);
                else residual_variance = 0;
                residual_variance_value_AR_Label.setText(" = " + Double.toString(round(residual_variance, 3)));
                
                if ( !info_msg.isEmpty() ) JOptionPane.showMessageDialog(AR_Panel, info_msg, "Information", JOptionPane.INFORMATION_MESSAGE);
            }
        });
        button2.setBounds(10, 130, 100, 20);
        AR_Panel.add(button2);

        graphic_AR_Button = new JButton("Graphic");
        LoadGraphicListener Graphic_Listener = new LoadGraphicListener(this, "AR graphic", 1);
        graphic_AR_Button.addActionListener(Graphic_Listener);
        graphic_AR_Button.setVisible(false);
        graphic_AR_Button.setBounds(10, 505, 90, 20);
        AR_Panel.add(graphic_AR_Button);

        save_CSV_AR_Button = new JButton("Save CSV file");
        CSVFileSaveListener CSV_file_AR_Listener = new CSVFileSaveListener(this, 1);
        save_CSV_AR_Button.addActionListener(CSV_file_AR_Listener);
        save_CSV_AR_Button.setVisible(false);
        save_CSV_AR_Button.setBounds(110, 505, 120, 20);
        AR_Panel.add(save_CSV_AR_Button);

        forecast_AR_Label = new JLabel("Number of forecasting data");
        forecast_AR_Label.setVisible(false);
        forecast_AR_Label.setBounds(10, 535, 200, 20);
        AR_Panel.add(forecast_AR_Label);

        forecast_Formatter = new NumberFormatter(new DecimalFormat("###"));
        forecast_Formatter.setMinimum(1);
        forecast_Formatter.setMaximum(100);
        forecast_Formatter.setValueClass(Integer.class);
        forecast_AR_Field = new JFormattedTextField(forecast_Formatter);
        forecast_AR_Field.setColumns(3);
        forecast_AR_Field.setValue(1);
        forecast_AR_Field.setVisible(false);
        forecast_AR_Field.setBounds(210, 535, 40, 20);
        AR_Panel.add(forecast_AR_Field);

        test_AR_Button = new JButton("Test data");
        LoadTestDataARListener test_data_AR_Listener = new LoadTestDataARListener(this);
        test_AR_Button.addActionListener(test_data_AR_Listener);
        test_AR_Button.setVisible(false);
        test_AR_Button.setBounds(260, 535, 100, 20);
        AR_Panel.add(test_AR_Button);
    }

    private void createABSpage() {
        ABS_Panel = new JPanel();
        ABS_Panel.setLayout(null);

        p_Label = new JLabel("p value");
        p_Label.setBounds(10, 10, 150, 20);
        ABS_Panel.add(p_Label);

        p_Formatter = new NumberFormatter(new DecimalFormat("###"));
        p_Formatter.setMinimum(1);
        p_Formatter.setMaximum(100);
        p_Formatter.setValueClass(Integer.class);
        p_ABS_Field = new JFormattedTextField(p_Formatter);
        p_ABS_Field.setColumns(3);
        p_ABS_Field.setValue(2);
        p_ABS_Field.setBounds(70, 10, 40, 20);
        ABS_Panel.add(p_ABS_Field);

        recalc_Label = new JLabel("Recalculate coefficients after each step:");
        recalc_Label.setBounds(10, 40, 240, 20);
        ABS_Panel.add(recalc_Label);

        recalc_yes_ABS_Button = new JRadioButton("yes");
        recalc_yes_ABS_Button.setActionCommand("1");
        recalc_yes_ABS_Button.setBounds(250, 40, 50, 20);
        ABS_Panel.add(recalc_yes_ABS_Button);

        recalc_no_ABS_Button = new JRadioButton("no (recommended)");
        recalc_no_ABS_Button.setActionCommand("2");
        recalc_no_ABS_Button.setSelected(true);
        recalc_no_ABS_Button.setBounds(300, 40, 200, 20);
        ABS_Panel.add(recalc_no_ABS_Button);

        recalc_ABS_Group = new ButtonGroup();
        recalc_ABS_Group.add(recalc_yes_ABS_Button);
        recalc_ABS_Group.add(recalc_no_ABS_Button);

        virtual_data_ABS_Label = new JLabel("Use virtual data (for finding all predictions)");
        virtual_data_ABS_Label.setBounds(10, 70, 270, 20);
        ABS_Panel.add(virtual_data_ABS_Label);

        virtual_data_yes_ABS_Button = new JRadioButton("yes");
        virtual_data_yes_ABS_Button.setActionCommand("1");
        virtual_data_yes_ABS_Button.setBounds(290, 70, 50, 20);
        ABS_Panel.add(virtual_data_yes_ABS_Button);

        virtual_data_no_ABS_Button = new JRadioButton("no (recommended)");
        virtual_data_no_ABS_Button.setActionCommand("2");
        virtual_data_no_ABS_Button.setSelected(true);
        virtual_data_no_ABS_Button.setBounds(350, 70, 200, 20);
        ABS_Panel.add(virtual_data_no_ABS_Button);

        virtual_data_ABS_Group = new ButtonGroup();
        virtual_data_ABS_Group.add(virtual_data_yes_ABS_Button);
        virtual_data_ABS_Group.add(virtual_data_no_ABS_Button);

        data_count_ABS_Label = new JLabel();
        data_count_ABS_Label.setBounds(10, 100, 110, 20);
        ABS_Panel.add(data_count_ABS_Label);

        training_data_Formatter = new NumberFormatter(new DecimalFormat("###"));
        training_data_Formatter.setMinimum(1);
        training_data_Formatter.setMaximum(100);
        training_data_Formatter.setValueClass(Integer.class);
        training_data_ABS_Field = new JFormattedTextField(training_data_Formatter);
        training_data_ABS_Field.setColumns(3);
        training_data_ABS_Field.setBounds(130, 100, 40, 20);
        ABS_Panel.add(training_data_ABS_Field);

        training_data_ABS_Field.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                half_data_ABS_Label.setText("data used for training, and " + (entered_data_Count - Integer.parseInt(training_data_ABS_Field.getText())) + " data used for testing");
                training_data_ABS_Count = Integer.parseInt(training_data_ABS_Field.getText());
                testing_data_ABS_Count = entered_data_Count - Integer.parseInt(training_data_ABS_Field.getText());
            }
        });

        half_data_ABS_Label = new JLabel();
        half_data_ABS_Label.setBounds(180, 100, 300, 20);
        ABS_Panel.add(half_data_ABS_Label);

        data_mean_ABS_Label = new JLabel("Data mean");
        data_mean_ABS_Label.setVisible(false);
        data_mean_ABS_Label.setBounds(10, 565, 300, 20);
        ABS_Panel.add(data_mean_ABS_Label);

        data_mean_value_ABS_Label = new JLabel();
        data_mean_value_ABS_Label.setBounds(300, 565, 300, 20);
        ABS_Panel.add(data_mean_value_ABS_Label);

        data_variance_ABS_Label = new JLabel("Data standard");
        data_variance_ABS_Label.setVisible(false);
        data_variance_ABS_Label.setBounds(10, 590, 300, 20);
        ABS_Panel.add(data_variance_ABS_Label);

        data_variance_value_ABS_Label = new JLabel();
        data_variance_value_ABS_Label.setBounds(300, 590, 300, 20);
        ABS_Panel.add(data_variance_value_ABS_Label);

        MAE_ABS_Label = new JLabel("Mean absolute error (MAE)");
        MAE_ABS_Label.setVisible(false);
        MAE_ABS_Label.setBounds(10, 615, 300, 20);
        ABS_Panel.add(MAE_ABS_Label);

        MAE_value_ABS_Label = new JLabel();
        MAE_value_ABS_Label.setBounds(300, 615, 300, 20);
        ABS_Panel.add(MAE_value_ABS_Label);

        MAPE_ABS_Label = new JLabel("Mean absolute percentage error (MAPE)");
        MAPE_ABS_Label.setVisible(false);
        MAPE_ABS_Label.setBounds(10, 640, 300, 20);
        ABS_Panel.add(MAPE_ABS_Label);

        MAPE_value_ABS_Label = new JLabel();
        MAPE_value_ABS_Label.setBounds(300, 640, 300, 20);
        ABS_Panel.add(MAPE_value_ABS_Label);

        PMAD_ABS_Label = new JLabel("Percent mean absolute deviation (PMAD)");
        PMAD_ABS_Label.setVisible(false);
        PMAD_ABS_Label.setBounds(10, 665, 300, 20);
        ABS_Panel.add(PMAD_ABS_Label);

        PMAD_value_ABS_Label = new JLabel();
        PMAD_value_ABS_Label.setBounds(300, 665, 300, 20);
        ABS_Panel.add(PMAD_value_ABS_Label);

        MSE_ABS_Label = new JLabel("Mean squared error (MSE)");
        MSE_ABS_Label.setVisible(false);
        MSE_ABS_Label.setBounds(10, 690, 300, 20);
        ABS_Panel.add(MSE_ABS_Label);

        MSE_value_ABS_Label = new JLabel();
        MSE_value_ABS_Label.setBounds(300, 690, 300, 20);
        ABS_Panel.add(MSE_value_ABS_Label);

        RMSE_ABS_Label = new JLabel("Root mean squared error (RMSE)");
        RMSE_ABS_Label.setVisible(false);
        RMSE_ABS_Label.setBounds(10, 715, 300, 20);
        ABS_Panel.add(RMSE_ABS_Label);

        RMSE_value_ABS_Label = new JLabel();
        RMSE_value_ABS_Label.setBounds(300, 715, 300, 20);
        ABS_Panel.add(RMSE_value_ABS_Label);

        residual_variance_ABS_Label = new JLabel("Residual variance");
        residual_variance_ABS_Label.setVisible(false);
        residual_variance_ABS_Label.setBounds(10, 740, 300, 20);
        ABS_Panel.add(residual_variance_ABS_Label);

        residual_variance_value_ABS_Label = new JLabel();
        residual_variance_value_ABS_Label.setBounds(300, 740, 300, 20);
        ABS_Panel.add(residual_variance_value_ABS_Label);

        button2 = new JButton("Calculate");
        button2.addActionListener(new ActionListener() {
            private String data[][];
            private int new_p;
            private int start_ABS;
            private String info_msg;
            public void actionPerformed(ActionEvent evt) {
                start_ABS = 0;
                info_msg = "";
                real_ABS_Series = new TimeSeries("Actual value", Day.class);

                int k = 0;
                if (!your_data_Area.getText().equals("")) { //jeigu duomenis nuskaitom iš textArea lauko
                    String line = your_data_Area.getText();
                    StringTokenizer t = new StringTokenizer(line, "\r\n");
                    data = new String[entered_data_Count][5];
                    entered_data_ABS = new double[entered_data_Count];
                    while (t.hasMoreTokens()) {
                        entered_data_ABS[k] = Double.parseDouble(t.nextToken());
                        data[k][0] = Integer.toString(k+1) + ".";
                        data[k][1] = Double.toString(entered_data_ABS[k]);
                        Date now = new Date();
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(now);
                        cal.add(Calendar.DAY_OF_YEAR, k+1);
                        Date tomorrow = cal.getTime();
                        real_ABS_Series.add(new Day(tomorrow), entered_data_ABS[k]);
                        k++;
                    }
                }
                else { //jeigu duomenis nuskaitom iš lentelės
                    String read_from = read_Group.getSelection().getActionCommand();
                    if ( type.equals("5") ) column_number = 1;
                    else column_number = Integer.parseInt(column_Field.getText());
                    data = new String[entered_data_Count][5];
                    entered_data_ABS = new double[entered_data_Count];

                    if (Integer.parseInt(read_from) == 1) { //jeigu duomenis nuskaitom iš viršaus į apačią
                        for (int i = 0; i < entered_data_Count; i++) {
                            entered_data_ABS[k] = Double.parseDouble(table1.getValueAt(i, column_number-1).toString());
                            data[k][0] = Integer.toString(k+1) + "."; //numeracija
                            data[k][1] = String.valueOf(table1.getValueAt(i, column_number-1)); //realūs duomenys
                            Date now = new Date();
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(now);
                            cal.add(Calendar.DAY_OF_YEAR, k+1);
                            Date tomorrow = cal.getTime();
                            real_ABS_Series.add(new Day(tomorrow), entered_data_ABS[k]);
                            k++;
                        }
                    }
                    else { //jeigu duomenis nuskaitom iš apačios į viršų
                        for (int i = entered_data_Count-1; i >= 0; i--) {
                            entered_data_ABS[k] = Double.parseDouble(table1.getValueAt(i, column_number-1).toString());
                            data[k][0] = Integer.toString(k+1) + "."; //numeracija
                            data[k][1] = String.valueOf(table1.getValueAt(i, column_number-1)); //realūs duomenys
                            Date now = new Date();
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(now);
                            cal.add(Calendar.DAY_OF_YEAR, k+1);
                            Date tomorrow = cal.getTime();
                            real_ABS_Series.add(new Day(tomorrow), entered_data_ABS[k]);
                            k++;
                        }
                    }
                }

                String titles[] = new String[4];
                titles[0] = "No.";
                titles[1] = "Actual value";
                titles[2] = "Forecast";
                titles[3] = "Error";

                p_value_ABS = Integer.parseInt(p_ABS_Field.getText());

                double training_error_sum = 0;
                double bendra_suma2 = 0;
                double bendra_suma3 = 0;
                double bendra_suma4 = 0;
                double bendra_suma5 = 0;
                forecast_ABS_Series = new TimeSeries("Forecast", Day.class);

                String recalc = recalc_ABS_Group.getSelection().getActionCommand();
                //System.out.println("recalc = " + recalc);
                String virtual_data = virtual_data_ABS_Group.getSelection().getActionCommand();
                //System.out.println("virtual_data = " + virtual_data);
                MyLp lp = null;
                double[] use_array;
                if (recalc.equals("2")) { //jeigu koeficientus kas žingsnį neperskaičiuojam
                    if (virtual_data.equals("1")) { //jeigu naudojam atbulinius duomenis
                        start_ABS = 0;
                        use_array = back_data_array(training_data_ABS_Count+p_value_ABS, training_data_ABS_Count, entered_data_ABS);
                    }
                    else {
                        start_ABS = p_value_ABS;
                        use_array = new double[training_data_ABS_Count];
                        System.arraycopy(entered_data_ABS, 0, use_array, 0, training_data_ABS_Count);
                    }

                    lp = new MyLp();
                    coef_ABS = lp.predict(use_array, p_value_ABS);
                    
                    new_p = p_value_ABS;
                    for (int n = coef_ABS.length - 1; n >= 0; n--) {
                        if ( coef_ABS[n] == 0) {
                            new_p = new_p - 1;
                        }
                        else break;
                    }
                    
                    if ( new_p < p_value_ABS ) {
                        info_msg = "No optimal solution\np value was reduced to " + new_p;
                    }

                    /*coef_ABS2 = new double[p_value_ABS];
                    new_p = 0;
                    //jeigu ABS neranda koeficientų prie duoto p, tai mažinam p reikšmę -1
                    while (coef_ABS.length == 0) {
                        new_p++;
                        coef_ABS = lp.predict(use_array, p_value_ABS - new_p);
                    }
                    if (coef_ABS.length < p_value_ABS) {
                        System.arraycopy(coef_ABS, 0, coef_ABS2, 0, p_value_ABS - new_p);
                        coef_ABS = coef_ABS2;
                        System.out.println("2. p = " + p_value_ABS + ". Buvo sumazintas iki " + (p_value_ABS - new_p));
                    }*/

                    System.out.println("matrica DATA2 ------------------------");
                    for (int n = 0; n < use_array.length; n++)
                         System.out.println(use_array[n]);
                    System.out.println("matrica DATA2 ------------------------");

                    System.out.println("AR-ABS coef ------------------------");
                    for (int n = 0; n < coef_ABS.length; n++)
                        System.out.println(coef_ABS[n]);
                    System.out.println("AR-ABS coef ------------------------");
                }
                else {
                    if (virtual_data.equals("1")) start_ABS = 0;
                    else start_ABS = p_value_ABS;
                }

                int count = 0;
                suma_array = new double[training_data_ABS_Count];
                int a = 0;
                for (int i = start_ABS; i < training_data_ABS_Count; i++) {
                    used_data_ABS = new double[i];
                    //System.out.println("i = " +i);
                    System.arraycopy(entered_data_ABS, 0, used_data_ABS, 0, i);
                    //if (used_data_ABS.length < p_value_ABS*2) {
                    if (virtual_data.equals("1") && i < p_value_ABS) {
                        used_data_ABS = back_data_array(p_value_ABS*2-p_value_ABS, used_data_ABS.length, entered_data_ABS);
                    }

                    //gaunam AR-ABS modelio koeficientus
                    if (recalc.equals("1")) { //jeigu koeficientus kas žingsnį perskaičiuojam
                        lp = new MyLp();
                        coef_ABS = lp.predict(used_data_ABS, p_value_ABS);
                        
                        new_p = p_value_ABS;
                        for (int n = coef_ABS.length - 1; n >= 0; n--) {
                            if ( coef_ABS[n] == 0 ) new_p = new_p - 1;
                            else break;
                        }
                        
                        if ( new_p < p_value_ABS ) {
                            if ( a == 0 ) info_msg = "No optimal solutions in few steps:\n";
                            info_msg = info_msg + "In " + (i+1) + " step p value was reduced to " + new_p + "\n";
                            a++;
                        }
                        
                        /*coef_ABS2 = new double[p_value_ABS];
                        new_p = 0;
                        while ( coef_ABS.length == 0 ) {
                            new_p++;
                            coef_ABS = lp.predict(used_data_ABS, p_value_ABS - new_p);
                        }
                        if ( coef_ABS.length < p_value_ABS ) {
                            System.arraycopy(coef_ABS, 0, coef_ABS2, 0, p_value_ABS - new_p);
                            coef_ABS = coef_ABS2;
                            System.out.println("1. p = " + p_value_ABS + ". Buvo sumazintas iki " + (p_value_ABS - new_p));
                        }*/
                        

                        System.out.println("AR-ABS data ------------------------");
                        for (int n = 0; n < used_data_ABS.length; n++)
                             System.out.println(used_data_ABS[n]);
                        System.out.println("AR-ABS data ------------------------");

                        System.out.println("AR-ABS coef ------------------------");
                        for (int n = 0; n < coef_ABS.length; n++) {
                            System.out.println(coef_ABS[n]);
                        }
                        System.out.println("AR-ABS coef ------------------------");
                    }

                    double suma = 0;
                    for (int j = 0; j < coef_ABS.length; j++) {
                        suma += coef_ABS[j] * used_data_ABS[used_data_ABS.length-j-1];
                    }
                    
                    suma_array[count] = suma;
                    
                    if (i < training_data_ABS_Count) {
                        data[i][2] = Double.toString(round(suma_array[count],3)); //prognozuojami duomenys
                        Date now = new Date();
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(now);
                        cal.add(Calendar.DAY_OF_YEAR, i+1);
                        Date tomorrow = cal.getTime();
                        forecast_ABS_Series.add(new Day(tomorrow), suma_array[count]);
                        double error = entered_data_ABS[i] - suma_array[count];
                        bendra_suma5 += error;
                        if (error < 0) error = error * (-1);
                        data[i][3] = Double.toString(round(error,3)); //paklaida
                        training_error_sum += error;
                        bendra_suma2 += error / entered_data_ABS[i];
                        bendra_suma3 += entered_data_ABS[i];
                        bendra_suma4 += error * error;
                    }
                    count++;
                }

                data_mean_ABS_Label.setVisible(true);
                data_variance_ABS_Label.setVisible(true);
                MAE_ABS_Label.setVisible(true);
                MAPE_ABS_Label.setVisible(true);
                PMAD_ABS_Label.setVisible(true);
                MSE_ABS_Label.setVisible(true);
                RMSE_ABS_Label.setVisible(true);
                residual_variance_ABS_Label.setVisible(true);
                test_ABS_Button.setVisible(true);
                graphic_ABS_Button.setVisible(true);
                save_CSV_ABS_Button.setVisible(true);
                forecast_ABS_Label.setVisible(true);
                forecast_ABS_Field.setVisible(true);

                if (data_ABS_Table != null) {
                    data_table_ABS_Scroll.remove(data_ABS_Table);
                    data_ABS_Table = null;
                }
                data_ABS_Table = new JTable(data, titles) {
                    @Override
                    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                        Component c = super.prepareRenderer(renderer, row, column);
                        if (row < training_data_ABS_Count) c.setBackground(new Color(200,221,242));
                        else c.setBackground(null);
                        return c;
                    }
                };
                if (data_table_ABS_Scroll != null) {
                    ABS_Panel.remove(data_table_ABS_Scroll);
                    data_table_ABS_Scroll = null;
                }
                data_table_ABS_Scroll = new JScrollPane(data_ABS_Table);
                data_table_ABS_Scroll.setVerticalScrollBarPolicy(22);
                data_table_ABS_Scroll.setBounds(10, 160, 400, 337);
                ABS_Panel.add(data_table_ABS_Scroll);

                String titles2[] = new String[2];
                titles2[0] = "No.";
                titles2[1] = "Coefficient";

                String data2 [][] = new String[p_value_ABS][2];

                for (int i = 0; i < p_value_ABS; i++) {
                    data2[i][0] = Integer.toString(i+1) + ".";
                    //data2[i][1] = Double.toString(round(coef_ABS[i], 3));
                    data2[i][1] = Double.toString(coef_ABS[i]);
                }

                if (coef_ABS_Table != null) {
                    coef_table_ABS_Scroll.remove(coef_ABS_Table);
                    coef_ABS_Table = null;
                }
                coef_ABS_Table = new JTable(data2, titles2);
                if (coef_table_ABS_Scroll != null) {
                    ABS_Panel.remove(coef_table_ABS_Scroll);
                    coef_table_ABS_Scroll = null;
                }
                coef_table_ABS_Scroll = new JScrollPane(coef_ABS_Table);
                coef_table_ABS_Scroll.setVerticalScrollBarPolicy(22);
                coef_table_ABS_Scroll.setBounds(430, 160, 200, 337);
                ABS_Panel.add(coef_table_ABS_Scroll);


                double data_mean = 0;
                int c = 0;
                double training_data_sum = 0, training_data_sum2 = 0;
                for (int i = 0; i < entered_data_ABS.length; i++) {
                    training_data_sum += entered_data_ABS[i];
                    training_data_sum2 += entered_data_ABS[i]*entered_data_ABS[i];
                    c++;
                }
                data_mean = training_data_sum / c;
                data_mean_value_ABS_Label.setText(" = " + Double.toString(round(data_mean, 3)));

                double data_variance = 0;
                data_variance = (training_data_sum2 - ((training_data_sum*training_data_sum)/c)) / (c - 1);
                data_variance_value_ABS_Label.setText(" = " + Double.toString(round(data_variance, 3)));

                double MAE = 0;
                if (training_error_sum == Double.NaN || training_error_sum == Double.POSITIVE_INFINITY || training_error_sum == Double.NEGATIVE_INFINITY ||
                    training_error_sum == 0.0)
                    MAE = 0;
                else MAE = training_error_sum / count;
                MAE_value_ABS_Label.setText(" = " + Double.toString(round(MAE, 3)));

                double MAPE = 0;
                if (bendra_suma2 == Double.NaN || bendra_suma2 == Double.POSITIVE_INFINITY || bendra_suma2 == Double.NEGATIVE_INFINITY ||
                    bendra_suma2 == 0.0)
                    MAPE = 0;
                else MAPE = bendra_suma2 / count;
                MAPE_value_ABS_Label.setText(" = " + Double.toString(round(MAPE, 3)));

                double PMAD = 0;
                if (training_error_sum == Double.NaN || training_error_sum == Double.POSITIVE_INFINITY || training_error_sum == Double.NEGATIVE_INFINITY ||
                    bendra_suma3 == Double.NaN || bendra_suma3 == Double.POSITIVE_INFINITY || bendra_suma3 == Double.NEGATIVE_INFINITY ||
                    training_error_sum == 0.0 || bendra_suma3 == 0.0)
                        PMAD = 0;
                else PMAD = training_error_sum / bendra_suma3;
                PMAD_value_ABS_Label.setText(" = " + Double.toString(round(PMAD, 3)));

                double MSE = 0;
                if (bendra_suma4 == Double.NaN || bendra_suma4 == Double.POSITIVE_INFINITY || bendra_suma4 == Double.NEGATIVE_INFINITY ||
                    bendra_suma4 == 0.0)
                    MSE = 0;
                else MSE = bendra_suma4 / count;
                MSE_value_ABS_Label.setText(" = " + Double.toString(round(MSE, 3)));

                double RMSE = 0;
                if (MSE == 0.0) RMSE = 0;
                else RMSE = Math.sqrt(MSE);
                RMSE_value_ABS_Label.setText(" = " + Double.toString(round(RMSE, 3)));

                double residual_variance = 0;
                if ( count-1 > 0 ) residual_variance = (bendra_suma4 - ((bendra_suma5*bendra_suma5)/count)) / (count - 1);
                else residual_variance = 0;
                residual_variance_value_ABS_Label.setText(" = " + Double.toString(round(residual_variance, 3)));
                
                if ( !info_msg.isEmpty() ) JOptionPane.showMessageDialog(ABS_Panel, info_msg, "Information", JOptionPane.INFORMATION_MESSAGE);
            }
        });
        button2.setBounds(10, 130, 100, 20);
        ABS_Panel.add(button2);

        graphic_ABS_Button = new JButton("Graphic");
        LoadGraphicListener Graphic_Listener = new LoadGraphicListener(this, "AR-ABS graphic", 2);
        graphic_ABS_Button.addActionListener(Graphic_Listener);
        graphic_ABS_Button.setVisible(false);
        graphic_ABS_Button.setBounds(10, 505, 90, 20);
        ABS_Panel.add(graphic_ABS_Button);

        save_CSV_ABS_Button = new JButton("Save CSV file");
        CSVFileSaveListener CSV_file_ABS_Listener = new CSVFileSaveListener(this, 2);
        save_CSV_ABS_Button.addActionListener(CSV_file_ABS_Listener);
        save_CSV_ABS_Button.setVisible(false);
        save_CSV_ABS_Button.setBounds(110, 505, 120, 20);
        ABS_Panel.add(save_CSV_ABS_Button);

        forecast_ABS_Label = new JLabel("Number of forecasting data");
        forecast_ABS_Label.setVisible(false);
        forecast_ABS_Label.setBounds(10, 535, 200, 20);
        ABS_Panel.add(forecast_ABS_Label);

        forecast_Formatter = new NumberFormatter(new DecimalFormat("###"));
        forecast_Formatter.setMinimum(1);
        forecast_Formatter.setMaximum(100);
        forecast_Formatter.setValueClass(Integer.class);
        forecast_ABS_Field = new JFormattedTextField(forecast_Formatter);
        forecast_ABS_Field.setColumns(3);
        forecast_ABS_Field.setValue(1);
        forecast_ABS_Field.setVisible(false);
        forecast_ABS_Field.setBounds(210, 535, 40, 20);
        ABS_Panel.add(forecast_ABS_Field);

        test_ABS_Button = new JButton("Test data");
        LoadTestDataABSListener test_data_ABS_Listener = new LoadTestDataABSListener(this);
        test_ABS_Button.addActionListener(test_data_ABS_Listener);
        test_ABS_Button.setVisible(false);
        test_ABS_Button.setBounds(260, 535, 100, 20);
        ABS_Panel.add(test_ABS_Button);
    }
    
    private void createARMApage() {
        ARMA_Panel = new JPanel();
        ARMA_Panel.setLayout(null);

        p_Label = new JLabel("p value");
        p_Label.setBounds(10, 10, 150, 20);
        ARMA_Panel.add(p_Label);

        p_Formatter = new NumberFormatter(new DecimalFormat("###"));
        p_Formatter.setMinimum(1);
        p_Formatter.setMaximum(100);
        p_Formatter.setValueClass(Integer.class);
        p_ARMA_Field = new JFormattedTextField(p_Formatter);
        p_ARMA_Field.setColumns(3);
        p_ARMA_Field.setValue(2);
        p_ARMA_Field.setBounds(70, 10, 40, 20);
        ARMA_Panel.add(p_ARMA_Field);
        
        q_Label = new JLabel("q value");
        q_Label.setBounds(130, 10, 150, 20);
        ARMA_Panel.add(q_Label);

        q_Formatter = new NumberFormatter(new DecimalFormat("###"));
        q_Formatter.setMinimum(0);
        q_Formatter.setMaximum(100);
        q_Formatter.setValueClass(Integer.class);
        q_ARMA_Field = new JFormattedTextField(q_Formatter);
        q_ARMA_Field.setColumns(3);
        q_ARMA_Field.setValue(2);
        q_ARMA_Field.setBounds(190, 10, 40, 20);
        ARMA_Panel.add(q_ARMA_Field);
        
        b_from_Label = new JLabel("b coefficients from");
        b_from_Label.setBounds(10, 40, 150, 20);
        ARMA_Panel.add(b_from_Label);
        
        b_from_Formatter = new NumberFormatter(new DecimalFormat("###.###;-###.###"));
        b_from_Formatter.setMinimum(-100.000);
        b_from_Formatter.setMaximum(100.000);
        b_from_Formatter.setValueClass(Double.class);
        b_from_ARMA_Field = new JFormattedTextField(b_from_Formatter);
        b_from_ARMA_Field.setColumns(7);
        b_from_ARMA_Field.setValue(new Double(-0.5));
        b_from_ARMA_Field.setBounds(140, 40, 40, 20);
        ARMA_Panel.add(b_from_ARMA_Field);
        
        b_to_Label = new JLabel("to");
        b_to_Label.setBounds(210, 40, 150, 20);
        ARMA_Panel.add(b_to_Label);
        
        b_to_Formatter = new NumberFormatter(new DecimalFormat("###.###;-###.###"));
        b_to_Formatter.setMinimum(-100.000);
        b_to_Formatter.setMaximum(100.000);
        b_to_Formatter.setValueClass(Double.class);
        b_to_ARMA_Field = new JFormattedTextField(b_to_Formatter);
        b_to_ARMA_Field.setColumns(7);
        b_to_ARMA_Field.setValue(new Double(0.5));
        b_to_ARMA_Field.setBounds(250, 40, 40, 20);
        ARMA_Panel.add(b_to_ARMA_Field);
        
        b_step_Label = new JLabel("step");
        b_step_Label.setBounds(320, 40, 150, 20);
        ARMA_Panel.add(b_step_Label);        
        
        b_step_Formatter = new NumberFormatter(new DecimalFormat("###.###"));
        b_step_Formatter.setMinimum(0.000);
        b_step_Formatter.setMaximum(100.000);
        b_step_Formatter.setValueClass(Integer.class);
        b_step_ARMA_Field = new JFormattedTextField(b_to_Formatter);
        b_step_ARMA_Field.setColumns(7);
        b_step_ARMA_Field.setValue(new Double(0.1));
        b_step_ARMA_Field.setBounds(360, 40, 40, 20);
        ARMA_Panel.add(b_step_ARMA_Field);
        
        recalc_ARMA_Group = new ButtonGroup();
        recalc_ARMA_Group.add(recalc_yes_ARMA_Button);
        recalc_ARMA_Group.add(recalc_no_ARMA_Button);

        virtual_data_ARMA_Label = new JLabel("Use virtual data (for finding all predictions)");
        virtual_data_ARMA_Label.setBounds(10, 70, 270, 20);
        ARMA_Panel.add(virtual_data_ARMA_Label);

        virtual_data_yes_ARMA_Button = new JRadioButton("yes");
        virtual_data_yes_ARMA_Button.setActionCommand("1");
        virtual_data_yes_ARMA_Button.setBounds(290, 70, 50, 20);
        ARMA_Panel.add(virtual_data_yes_ARMA_Button);

        virtual_data_no_ARMA_Button = new JRadioButton("no (recommended)");
        virtual_data_no_ARMA_Button.setActionCommand("2");
        virtual_data_no_ARMA_Button.setSelected(true);
        virtual_data_no_ARMA_Button.setBounds(350, 70, 200, 20);
        ARMA_Panel.add(virtual_data_no_ARMA_Button);

        virtual_data_ARMA_Group = new ButtonGroup();
        virtual_data_ARMA_Group.add(virtual_data_yes_ARMA_Button);
        virtual_data_ARMA_Group.add(virtual_data_no_ARMA_Button);

        data_count_ARMA_Label = new JLabel();
        data_count_ARMA_Label.setBounds(10, 100, 110, 20);
        ARMA_Panel.add(data_count_ARMA_Label);

        training_data_Formatter = new NumberFormatter(new DecimalFormat("###"));
        training_data_Formatter.setMinimum(1);
        training_data_Formatter.setMaximum(100);
        training_data_Formatter.setValueClass(Integer.class);
        training_data_ARMA_Field = new JFormattedTextField(training_data_Formatter);
        training_data_ARMA_Field.setColumns(3);
        training_data_ARMA_Field.setBounds(130, 100, 40, 20);
        ARMA_Panel.add(training_data_ARMA_Field);

        training_data_ARMA_Field.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                training_data_ARMA_Count = Integer.parseInt(training_data_ARMA_Field.getText());
                testing_data_ARMA_Count = entered_data_Count - Integer.parseInt(training_data_ARMA_Field.getText());
                half_data_ARMA_Label.setText("data used for training, and " + testing_data_ARMA_Count + " data used for testing");
            }
        });

        half_data_ARMA_Label = new JLabel();
        half_data_ARMA_Label.setBounds(180, 100, 300, 20);
        ARMA_Panel.add(half_data_ARMA_Label);

        data_mean_ARMA_Label = new JLabel("Data mean");
        data_mean_ARMA_Label.setVisible(false);
        data_mean_ARMA_Label.setBounds(10, 565, 300, 20);
        ARMA_Panel.add(data_mean_ARMA_Label);

        data_mean_value_ARMA_Label = new JLabel();
        data_mean_value_ARMA_Label.setBounds(300, 565, 300, 20);
        ARMA_Panel.add(data_mean_value_ARMA_Label);

        data_variance_ARMA_Label = new JLabel("Data standard");
        data_variance_ARMA_Label.setVisible(false);
        data_variance_ARMA_Label.setBounds(10, 590, 300, 20);
        ARMA_Panel.add(data_variance_ARMA_Label);

        data_variance_value_ARMA_Label = new JLabel();
        data_variance_value_ARMA_Label.setBounds(300, 590, 300, 20);
        ARMA_Panel.add(data_variance_value_ARMA_Label);

        MAE_ARMA_Label = new JLabel("Mean absolute error (MAE)");
        MAE_ARMA_Label.setVisible(false);
        MAE_ARMA_Label.setBounds(10, 615, 300, 20);
        ARMA_Panel.add(MAE_ARMA_Label);

        MAE_value_ARMA_Label = new JLabel();
        MAE_value_ARMA_Label.setBounds(300, 615, 300, 20);
        ARMA_Panel.add(MAE_value_ARMA_Label);

        MAPE_ARMA_Label = new JLabel("Mean absolute percentage error (MAPE)");
        MAPE_ARMA_Label.setVisible(false);
        MAPE_ARMA_Label.setBounds(10, 640, 300, 20);
        ARMA_Panel.add(MAPE_ARMA_Label);

        MAPE_value_ARMA_Label = new JLabel();
        MAPE_value_ARMA_Label.setBounds(300, 640, 300, 20);
        ARMA_Panel.add(MAPE_value_ARMA_Label);

        PMAD_ARMA_Label = new JLabel("Percent mean absolute deviation (PMAD)");
        PMAD_ARMA_Label.setVisible(false);
        PMAD_ARMA_Label.setBounds(10, 665, 300, 20);
        ARMA_Panel.add(PMAD_ARMA_Label);

        PMAD_value_ARMA_Label = new JLabel();
        PMAD_value_ARMA_Label.setBounds(300, 665, 300, 20);
        ARMA_Panel.add(PMAD_value_ARMA_Label);

        MSE_ARMA_Label = new JLabel("Mean squared error (MSE)");
        MSE_ARMA_Label.setVisible(false);
        MSE_ARMA_Label.setBounds(10, 690, 300, 20);
        ARMA_Panel.add(MSE_ARMA_Label);

        MSE_value_ARMA_Label = new JLabel();
        MSE_value_ARMA_Label.setBounds(300, 690, 300, 20);
        ARMA_Panel.add(MSE_value_ARMA_Label);

        RMSE_ARMA_Label = new JLabel("Root mean squared error (RMSE)");
        RMSE_ARMA_Label.setVisible(false);
        RMSE_ARMA_Label.setBounds(10, 715, 300, 20);
        ARMA_Panel.add(RMSE_ARMA_Label);

        RMSE_value_ARMA_Label = new JLabel();
        RMSE_value_ARMA_Label.setBounds(300, 715, 300, 20);
        ARMA_Panel.add(RMSE_value_ARMA_Label);

        residual_variance_ARMA_Label = new JLabel("Residual variance");
        residual_variance_ARMA_Label.setVisible(false);
        residual_variance_ARMA_Label.setBounds(10, 740, 300, 20);
        ARMA_Panel.add(residual_variance_ARMA_Label);

        residual_variance_value_ARMA_Label = new JLabel();
        residual_variance_value_ARMA_Label.setBounds(300, 740, 300, 20);
        ARMA_Panel.add(residual_variance_value_ARMA_Label);

        button2 = new JButton("Calculate");
        EstimateARMAModelListener estimate_ARMA_Model_Listener = new EstimateARMAModelListener(this);
        button2.addActionListener(estimate_ARMA_Model_Listener);
        button2.setBounds(10, 130, 100, 20);
        ARMA_Panel.add(button2);

        graphic_ARMA_Button = new JButton("Graphic");
        LoadGraphicListener Graphic_Listener = new LoadGraphicListener(this, "ARMA-ABS graphic", 5);
        graphic_ARMA_Button.addActionListener(Graphic_Listener);
        graphic_ARMA_Button.setVisible(false);
        graphic_ARMA_Button.setBounds(10, 505, 90, 20);
        ARMA_Panel.add(graphic_ARMA_Button);

        save_CSV_ARMA_Button = new JButton("Save CSV file");
        CSVFileSaveListener CSV_file_ARMA_Listener = new CSVFileSaveListener(this, 1);
        save_CSV_ARMA_Button.addActionListener(CSV_file_ARMA_Listener);
        save_CSV_ARMA_Button.setVisible(false);
        save_CSV_ARMA_Button.setBounds(110, 505, 120, 20);
        ARMA_Panel.add(save_CSV_ARMA_Button);

        forecast_ARMA_Label = new JLabel("Number of forecasting data");
        forecast_ARMA_Label.setVisible(false);
        forecast_ARMA_Label.setBounds(10, 535, 200, 20);
        ARMA_Panel.add(forecast_ARMA_Label);

        forecast_Formatter = new NumberFormatter(new DecimalFormat("###"));
        forecast_Formatter.setMinimum(1);
        forecast_Formatter.setMaximum(100);
        forecast_Formatter.setValueClass(Integer.class);
        forecast_ARMA_Field = new JFormattedTextField(forecast_Formatter);
        forecast_ARMA_Field.setColumns(3);
        forecast_ARMA_Field.setValue(1);
        forecast_ARMA_Field.setVisible(false);
        forecast_ARMA_Field.setBounds(210, 535, 40, 20);
        ARMA_Panel.add(forecast_ARMA_Field);

        test_ARMA_Button = new JButton("Test data");
        LoadTestDataARMAListener test_data_ARMA_Listener = new LoadTestDataARMAListener(this);
        test_ARMA_Button.addActionListener(test_data_ARMA_Listener);
        test_ARMA_Button.setVisible(false);
        test_ARMA_Button.setBounds(260, 535, 100, 20);
        ARMA_Panel.add(test_ARMA_Button);
    }

    private void createARMAABSpage() {
        ARMAABS_Panel = new JPanel();
        ARMAABS_Panel.setLayout(null);

        p_Label = new JLabel("p value");
        p_Label.setBounds(10, 10, 150, 20);
        ARMAABS_Panel.add(p_Label);

        p_Formatter = new NumberFormatter(new DecimalFormat("###"));
        p_Formatter.setMinimum(1);
        p_Formatter.setMaximum(100);
        p_Formatter.setValueClass(Integer.class);
        p_ARMAABS_Field = new JFormattedTextField(p_Formatter);
        p_ARMAABS_Field.setColumns(3);
        p_ARMAABS_Field.setValue(2);
        p_ARMAABS_Field.setBounds(70, 10, 40, 20);
        ARMAABS_Panel.add(p_ARMAABS_Field);
        
        q_Label = new JLabel("q value");
        q_Label.setBounds(130, 10, 150, 20);
        ARMAABS_Panel.add(q_Label);

        q_Formatter = new NumberFormatter(new DecimalFormat("###"));
        q_Formatter.setMinimum(0);
        q_Formatter.setMaximum(100);
        q_Formatter.setValueClass(Integer.class);
        q_ARMAABS_Field = new JFormattedTextField(q_Formatter);
        q_ARMAABS_Field.setColumns(3);
        q_ARMAABS_Field.setValue(2);
        q_ARMAABS_Field.setBounds(190, 10, 40, 20);
        ARMAABS_Panel.add(q_ARMAABS_Field);
        
        b_from_Label = new JLabel("b coefficients from");
        b_from_Label.setBounds(10, 40, 150, 20);
        ARMAABS_Panel.add(b_from_Label);
        
        b_from_Formatter = new NumberFormatter(new DecimalFormat("###.###;-###.###"));
        b_from_Formatter.setMinimum(-100.000);
        b_from_Formatter.setMaximum(100.000);
        b_from_Formatter.setValueClass(Double.class);
        b_from_ARMAABS_Field = new JFormattedTextField(b_from_Formatter);
        b_from_ARMAABS_Field.setColumns(7);
        b_from_ARMAABS_Field.setValue(new Double(-0.5));
        b_from_ARMAABS_Field.setBounds(140, 40, 40, 20);
        ARMAABS_Panel.add(b_from_ARMAABS_Field);
        
        b_to_Label = new JLabel("to");
        b_to_Label.setBounds(210, 40, 150, 20);
        ARMAABS_Panel.add(b_to_Label);
        
        b_to_Formatter = new NumberFormatter(new DecimalFormat("###.###;-###.###"));
        b_to_Formatter.setMinimum(-100.000);
        b_to_Formatter.setMaximum(100.000);
        b_to_Formatter.setValueClass(Double.class);
        b_to_ARMAABS_Field = new JFormattedTextField(b_to_Formatter);
        b_to_ARMAABS_Field.setColumns(7);
        b_to_ARMAABS_Field.setValue(new Double(0.5));
        b_to_ARMAABS_Field.setBounds(250, 40, 40, 20);
        ARMAABS_Panel.add(b_to_ARMAABS_Field);
        
        b_step_Label = new JLabel("step");
        b_step_Label.setBounds(320, 40, 150, 20);
        ARMAABS_Panel.add(b_step_Label);        
        
        b_step_Formatter = new NumberFormatter(new DecimalFormat("###.###"));
        b_step_Formatter.setMinimum(0.000);
        b_step_Formatter.setMaximum(100.000);
        b_step_Formatter.setValueClass(Integer.class);
        b_step_ARMAABS_Field = new JFormattedTextField(b_to_Formatter);
        b_step_ARMAABS_Field.setColumns(7);
        b_step_ARMAABS_Field.setValue(new Double(0.1));
        b_step_ARMAABS_Field.setBounds(360, 40, 40, 20);
        ARMAABS_Panel.add(b_step_ARMAABS_Field);
        
        recalc_ARMAABS_Group = new ButtonGroup();
        recalc_ARMAABS_Group.add(recalc_yes_ARMAABS_Button);
        recalc_ARMAABS_Group.add(recalc_no_ARMAABS_Button);

        virtual_data_ARMAABS_Label = new JLabel("Use virtual data (for finding all predictions)");
        virtual_data_ARMAABS_Label.setBounds(10, 70, 270, 20);
        ARMAABS_Panel.add(virtual_data_ARMAABS_Label);

        virtual_data_yes_ARMAABS_Button = new JRadioButton("yes");
        virtual_data_yes_ARMAABS_Button.setActionCommand("1");
        virtual_data_yes_ARMAABS_Button.setBounds(290, 70, 50, 20);
        ARMAABS_Panel.add(virtual_data_yes_ARMAABS_Button);

        virtual_data_no_ARMAABS_Button = new JRadioButton("no (recommended)");
        virtual_data_no_ARMAABS_Button.setActionCommand("2");
        virtual_data_no_ARMAABS_Button.setSelected(true);
        virtual_data_no_ARMAABS_Button.setBounds(350, 70, 200, 20);
        ARMAABS_Panel.add(virtual_data_no_ARMAABS_Button);

        virtual_data_ARMAABS_Group = new ButtonGroup();
        virtual_data_ARMAABS_Group.add(virtual_data_yes_ARMAABS_Button);
        virtual_data_ARMAABS_Group.add(virtual_data_no_ARMAABS_Button);

        data_count_ARMAABS_Label = new JLabel();
        data_count_ARMAABS_Label.setBounds(10, 100, 110, 20);
        ARMAABS_Panel.add(data_count_ARMAABS_Label);

        training_data_Formatter = new NumberFormatter(new DecimalFormat("###"));
        training_data_Formatter.setMinimum(1);
        training_data_Formatter.setMaximum(100);
        training_data_Formatter.setValueClass(Integer.class);
        training_data_ARMAABS_Field = new JFormattedTextField(training_data_Formatter);
        training_data_ARMAABS_Field.setColumns(3);
        training_data_ARMAABS_Field.setBounds(130, 100, 40, 20);
        ARMAABS_Panel.add(training_data_ARMAABS_Field);

        training_data_ARMAABS_Field.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                training_data_ARMAABS_Count = Integer.parseInt(training_data_ARMAABS_Field.getText());
                testing_data_ARMAABS_Count = entered_data_Count - Integer.parseInt(training_data_ARMAABS_Field.getText());
                half_data_ARMAABS_Label.setText("data used for training, and " + testing_data_ARMAABS_Count + " data used for testing");
            }
        });

        half_data_ARMAABS_Label = new JLabel();
        half_data_ARMAABS_Label.setBounds(180, 100, 300, 20);
        ARMAABS_Panel.add(half_data_ARMAABS_Label);

        data_mean_ARMAABS_Label = new JLabel("Data mean");
        data_mean_ARMAABS_Label.setVisible(false);
        data_mean_ARMAABS_Label.setBounds(10, 565, 300, 20);
        ARMAABS_Panel.add(data_mean_ARMAABS_Label);

        data_mean_value_ARMAABS_Label = new JLabel();
        data_mean_value_ARMAABS_Label.setBounds(300, 565, 300, 20);
        ARMAABS_Panel.add(data_mean_value_ARMAABS_Label);

        data_variance_ARMAABS_Label = new JLabel("Data standard");
        data_variance_ARMAABS_Label.setVisible(false);
        data_variance_ARMAABS_Label.setBounds(10, 590, 300, 20);
        ARMAABS_Panel.add(data_variance_ARMAABS_Label);

        data_variance_value_ARMAABS_Label = new JLabel();
        data_variance_value_ARMAABS_Label.setBounds(300, 590, 300, 20);
        ARMAABS_Panel.add(data_variance_value_ARMAABS_Label);

        MAE_ARMAABS_Label = new JLabel("Mean absolute error (MAE)");
        MAE_ARMAABS_Label.setVisible(false);
        MAE_ARMAABS_Label.setBounds(10, 615, 300, 20);
        ARMAABS_Panel.add(MAE_ARMAABS_Label);

        MAE_value_ARMAABS_Label = new JLabel();
        MAE_value_ARMAABS_Label.setBounds(300, 615, 300, 20);
        ARMAABS_Panel.add(MAE_value_ARMAABS_Label);

        MAPE_ARMAABS_Label = new JLabel("Mean absolute percentage error (MAPE)");
        MAPE_ARMAABS_Label.setVisible(false);
        MAPE_ARMAABS_Label.setBounds(10, 640, 300, 20);
        ARMAABS_Panel.add(MAPE_ARMAABS_Label);

        MAPE_value_ARMAABS_Label = new JLabel();
        MAPE_value_ARMAABS_Label.setBounds(300, 640, 300, 20);
        ARMAABS_Panel.add(MAPE_value_ARMAABS_Label);

        PMAD_ARMAABS_Label = new JLabel("Percent mean absolute deviation (PMAD)");
        PMAD_ARMAABS_Label.setVisible(false);
        PMAD_ARMAABS_Label.setBounds(10, 665, 300, 20);
        ARMAABS_Panel.add(PMAD_ARMAABS_Label);

        PMAD_value_ARMAABS_Label = new JLabel();
        PMAD_value_ARMAABS_Label.setBounds(300, 665, 300, 20);
        ARMAABS_Panel.add(PMAD_value_ARMAABS_Label);

        MSE_ARMAABS_Label = new JLabel("Mean squared error (MSE)");
        MSE_ARMAABS_Label.setVisible(false);
        MSE_ARMAABS_Label.setBounds(10, 690, 300, 20);
        ARMAABS_Panel.add(MSE_ARMAABS_Label);

        MSE_value_ARMAABS_Label = new JLabel();
        MSE_value_ARMAABS_Label.setBounds(300, 690, 300, 20);
        ARMAABS_Panel.add(MSE_value_ARMAABS_Label);

        RMSE_ARMAABS_Label = new JLabel("Root mean squared error (RMSE)");
        RMSE_ARMAABS_Label.setVisible(false);
        RMSE_ARMAABS_Label.setBounds(10, 715, 300, 20);
        ARMAABS_Panel.add(RMSE_ARMAABS_Label);

        RMSE_value_ARMAABS_Label = new JLabel();
        RMSE_value_ARMAABS_Label.setBounds(300, 715, 300, 20);
        ARMAABS_Panel.add(RMSE_value_ARMAABS_Label);

        residual_variance_ARMAABS_Label = new JLabel("Residual variance");
        residual_variance_ARMAABS_Label.setVisible(false);
        residual_variance_ARMAABS_Label.setBounds(10, 740, 300, 20);
        ARMAABS_Panel.add(residual_variance_ARMAABS_Label);

        residual_variance_value_ARMAABS_Label = new JLabel();
        residual_variance_value_ARMAABS_Label.setBounds(300, 740, 300, 20);
        ARMAABS_Panel.add(residual_variance_value_ARMAABS_Label);

        button2 = new JButton("Calculate");
        EstimateARMAABSModelListener estimate_ARMAABS_Model_Listener = new EstimateARMAABSModelListener(this);
        button2.addActionListener(estimate_ARMAABS_Model_Listener);
        button2.setBounds(10, 130, 100, 20);
        ARMAABS_Panel.add(button2);

        graphic_ARMAABS_Button = new JButton("Graphic");
        LoadGraphicListener Graphic_Listener = new LoadGraphicListener(this, "ARMA-ABS graphic", 5);
        graphic_ARMAABS_Button.addActionListener(Graphic_Listener);
        graphic_ARMAABS_Button.setVisible(false);
        graphic_ARMAABS_Button.setBounds(10, 505, 90, 20);
        ARMAABS_Panel.add(graphic_ARMAABS_Button);

        save_CSV_ARMAABS_Button = new JButton("Save CSV file");
        CSVFileSaveListener CSV_file_ARMAABS_Listener = new CSVFileSaveListener(this, 1);
        save_CSV_ARMAABS_Button.addActionListener(CSV_file_ARMAABS_Listener);
        save_CSV_ARMAABS_Button.setVisible(false);
        save_CSV_ARMAABS_Button.setBounds(110, 505, 120, 20);
        ARMAABS_Panel.add(save_CSV_ARMAABS_Button);

        forecast_ARMAABS_Label = new JLabel("Number of forecasting data");
        forecast_ARMAABS_Label.setVisible(false);
        forecast_ARMAABS_Label.setBounds(10, 535, 200, 20);
        ARMAABS_Panel.add(forecast_ARMAABS_Label);

        forecast_Formatter = new NumberFormatter(new DecimalFormat("###"));
        forecast_Formatter.setMinimum(1);
        forecast_Formatter.setMaximum(100);
        forecast_Formatter.setValueClass(Integer.class);
        forecast_ARMAABS_Field = new JFormattedTextField(forecast_Formatter);
        forecast_ARMAABS_Field.setColumns(3);
        forecast_ARMAABS_Field.setValue(1);
        forecast_ARMAABS_Field.setVisible(false);
        forecast_ARMAABS_Field.setBounds(210, 535, 40, 20);
        ARMAABS_Panel.add(forecast_ARMAABS_Field);

        test_ARMAABS_Button = new JButton("Test data");
        LoadTestDataARMAABSListener test_data_ARMAABS_Listener = new LoadTestDataARMAABSListener(this);
        test_ARMAABS_Button.addActionListener(test_data_ARMAABS_Listener);
        test_ARMAABS_Button.setVisible(false);
        test_ARMAABS_Button.setBounds(260, 535, 100, 20);
        ARMAABS_Panel.add(test_ARMAABS_Button);
    }
    
    private void createExpPage() {
        exp_Panel = new JPanel();
        exp_Panel.setLayout(null);
        
        exp_p_Label = new JLabel("Enter p values:");
        exp_p_Label.setBounds(10, 10, 110, 20);
        exp_Panel.add(exp_p_Label);
        
        exp_p_Area = new JTextArea(110,160);
        exp_p_Area.setLineWrap(true);
        exp_p_Area.setBorder(new CompoundBorder(new LineBorder(Color.GRAY), new EmptyBorder(1, 3, 1, 1)));
        exp_p_Scroll = new JScrollPane(exp_p_Area);
        exp_p_Scroll.setVerticalScrollBarPolicy(22);
        exp_p_Scroll.setBounds(10, 40, 110, 160);
        exp_Panel.add(exp_p_Scroll);
        
        select_indicators_Label = new JLabel("Select statistical indicators:");
        select_indicators_Label.setBounds(150, 10, 200, 20);
        exp_Panel.add(select_indicators_Label);
        
        data_mean_CheckBox = new JCheckBox("Data mean");
        data_mean_CheckBox.setBounds(150, 40, 110, 20);
        exp_Panel.add(data_mean_CheckBox);
        
        data_standard_CheckBox = new JCheckBox("Data standard");
        data_standard_CheckBox.setBounds(150, 60, 130, 20);
        exp_Panel.add(data_standard_CheckBox);
        
        MAE_CheckBox = new JCheckBox("Mean absolute error (MAE)");
        MAE_CheckBox.setBounds(150, 80, 220, 20);
        exp_Panel.add(MAE_CheckBox);
        
        MAPE_CheckBox = new JCheckBox("Mean absolute percentage error (MAPE)");
        MAPE_CheckBox.setBounds(150, 100, 310, 20);
        exp_Panel.add(MAPE_CheckBox);
        
        PMAD_CheckBox = new JCheckBox("Percent mean absolute deviation (PMAD)");
        PMAD_CheckBox.setBounds(150, 120, 320, 20);
        exp_Panel.add(PMAD_CheckBox);
        
        MSE_CheckBox = new JCheckBox("Mean squared error (MSE)");
        MSE_CheckBox.setBounds(150, 140, 220, 20);
        exp_Panel.add(MSE_CheckBox);
        
        RMSE_CheckBox = new JCheckBox("Root mean squared error (RMSE)");
        RMSE_CheckBox.setBounds(150, 160, 260, 20);
        exp_Panel.add(RMSE_CheckBox);
        
        residual_variance_CheckBox = new JCheckBox("Residual variance");
        residual_variance_CheckBox.setBounds(150, 180, 150, 20);
        exp_Panel.add(residual_variance_CheckBox);
        
              
        exp_start_date_Label = new JLabel("Start date:");
        exp_start_date_Label.setBounds(10, 210, 80, 20);
        exp_Panel.add(exp_start_date_Label);

        Calendar cal = Calendar.getInstance();
        cal = Calendar.getInstance();
        int day_now = cal.get(Calendar.DAY_OF_MONTH);
        int month_now = cal.get(Calendar.MONTH);
        int year_now = cal.get(Calendar.YEAR);

        Calendar cal2 = Calendar.getInstance();
        cal2.add(Calendar.MONTH, -18);
        int day_before = cal2.get(Calendar.DAY_OF_MONTH);
        int month_before = cal2.get(Calendar.MONTH);
        int year_before = cal2.get(Calendar.YEAR);

        exp_start_year_Formatter = new NumberFormatter(new DecimalFormat("####"));
        exp_start_year_Formatter.setMinimum(1800);
        exp_start_year_Formatter.setMaximum(3000);
        exp_start_year_Formatter.setValueClass(Integer.class);
        exp_start_year_Field = new JFormattedTextField(exp_start_year_Formatter);
        exp_start_year_Field.setColumns(4);
        exp_start_year_Field.setText("" + year_before);
        exp_start_year_Field.setBounds(100, 210, 50, 20);
        exp_Panel.add(exp_start_year_Field);

        String[] months_String = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
        exp_start_month_Box = new JComboBox(months_String);
        exp_start_month_Box.setSelectedIndex(month_before);
        exp_start_month_Box.setBounds(155, 210, 55, 20);
        exp_Panel.add(exp_start_month_Box);

        exp_start_day_Formatter = new NumberFormatter(new DecimalFormat("##"));
        exp_start_day_Formatter.setMinimum(1);
        exp_start_day_Formatter.setMaximum(31);
        exp_start_day_Formatter.setValueClass(Integer.class);
        exp_start_day_Field = new JFormattedTextField(exp_start_day_Formatter);
        exp_start_day_Field.setColumns(2);
        exp_start_day_Field.setText("" + day_before);
        exp_start_day_Field.setBounds(215, 210, 30, 20);
        exp_Panel.add(exp_start_day_Field);

        exp_end_date_Label = new JLabel("End date:");
        exp_end_date_Label.setBounds(260, 210, 150, 20);
        exp_Panel.add(exp_end_date_Label);

        exp_end_year_Formatter = new NumberFormatter(new DecimalFormat("####"));
        exp_end_year_Formatter.setMinimum(1800);
        exp_end_year_Formatter.setMaximum(3000);
        exp_end_year_Formatter.setValueClass(Integer.class);
        exp_end_year_Field = new JFormattedTextField(end_year_Formatter);
        exp_end_year_Field.setColumns(4);
        exp_end_year_Field.setText("" + year_now);
        exp_end_year_Field.setBounds(335, 210, 50, 20);
        exp_Panel.add(exp_end_year_Field);

        exp_end_month_Box = new JComboBox(months_String);
        exp_end_month_Box.setSelectedIndex(month_now);
        exp_end_month_Box.setBounds(390, 210, 55, 20);
        exp_Panel.add(exp_end_month_Box);

        exp_end_day_Formatter = new NumberFormatter(new DecimalFormat("##"));
        exp_end_day_Formatter.setMinimum(1);
        exp_end_day_Formatter.setMaximum(31);
        exp_end_day_Formatter.setValueClass(Integer.class);
        exp_end_day_Field = new JFormattedTextField(exp_end_day_Formatter);
        exp_end_day_Field.setColumns(2);
        exp_end_day_Field.setText("" + day_now);
        exp_end_day_Field.setBounds(450, 210, 30, 20);
        exp_Panel.add(exp_end_day_Field);
        
        exp_run_Button = new JButton("Run experiment");
        ExpRunListener exp_run_Listener = new ExpRunListener(this);
        exp_run_Button.addActionListener(exp_run_Listener);
        exp_run_Button.setBounds(10, 240, 150, 20);
        exp_Panel.add(exp_run_Button);
    }
    
    public ArrayList readFile2(String f) {
        ArrayList<String> a = new ArrayList();
        try {
            String aLine = "";
            URL source = new URL(getCodeBase(), f);
            BufferedReader br = new BufferedReader(new InputStreamReader(source.openStream()));
            while(null != (aLine = br.readLine())) {
                a.add(aLine);
            }
            br.close();
        }
        catch (Exception error) {
            System.out.println("Error: " + error);
        }
        return a;
    }

    @Override
    public void init() {
        main_Panel = new JPanel();
        main_Panel.setSize(800, 600);
        main_Panel.setLayout(new BorderLayout());
        getContentPane().add(main_Panel);

        createDataPage();
        createARpage();
        createABSpage();
        createARMApage();
        createARMAABSpage();
        createExpPage();

        tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Data", data_Panel);
        tabbedPane.addTab("AR(p)", AR_Panel);
        tabbedPane.addTab("AR-ABS(p)", ABS_Panel);
        tabbedPane.addTab("ARMA(p,q)", ARMA_Panel);
        tabbedPane.addTab("ARMA-ABS(p,q)", ARMAABS_Panel);
        tabbedPane.addTab("Experiment", exp_Panel);
        main_Panel.add(tabbedPane, BorderLayout.CENTER);
    }

    public double round(double d, int decimalPlace){
        BigDecimal bd = new BigDecimal(Double.toString(d));
        bd = bd.setScale(decimalPlace,BigDecimal.ROUND_HALF_EVEN);
        return bd.doubleValue();
    }
    
    public int power(int a, int b) {
        int result = 1;
        for (int i=b; i>0; i--) {
            result *= a;
        }
        return result;
    }

    public double[] back_data_array(int back_data_array_size, int size, double[] entered_data) {
        double back_data_array[] = new double[back_data_array_size];
        int s = size;
        double c = entered_data[0] / 100;
        int k = 1;
        for ( int i = back_data_array.length-1; i >= 0; i-- ) {
            s = s - 1;
            if ( s >= 0 ) back_data_array[i] = entered_data[s];
            else {
                back_data_array[i] = round( (entered_data[0] - c * k), 2); //jeigu trūksta duomenų imam į praeitį -1% nuo įvesto masyvo pirmos reikšmės
                k++;
            }
        }
        return back_data_array;
    }
    
    public void CSVTable() {
        CSVFileReader csv = new CSVFileReader(filepath);
        csv.ReadFile();
        ArrayList<String> a = csv.getArrayList();
        String titles[] = new String[7];

        if (title_value.equals("no")) {
            titles = a.get(0).split(",");
            data = new String[a.size()][7];
            for (int i = 0; i < a.size(); i++)
                data[i] = a.get(i).split(",");
        }
        else {
            titles = a.get(0).split(",");
            data = new String[a.size()-1][7];
            for (int i = 1; i < a.size(); i++)
                data[i-1] = a.get(i).split(",");
        }

        if (table1 != null) {
            scrollPanel1.remove(table1);
            table1 = null;
        }
        table1 = new JTable(data, titles);
        table1.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        entered_data_Count = table1.getRowCount();
        data_count_AR_Label.setText("You have1 " + entered_data_Count + " data.");
        data_count_ABS_Label.setText("You have " + entered_data_Count + " data.");
        data_count_ARMA_Label.setText("You have " + entered_data_Count + " data.");
        data_count_ARMAABS_Label.setText("You have " + entered_data_Count + " data.");

        training_data_AR_Count = (int)round((entered_data_Count / 2.0), 0);
        training_data_AR_Field.setValue(training_data_AR_Count);
        training_data_AR_Field.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                training_data_AR_Count = Integer.parseInt(training_data_AR_Field.getText());
                testing_data_AR_Count = entered_data_Count - Integer.parseInt(training_data_AR_Field.getText());
                half_data_AR_Label.setText("data used for training, and " + testing_data_AR_Count + " data used for testing");
            }
        });
        half_data_AR_Label.setText("data used for training, and " + (entered_data_Count - training_data_AR_Count) + " data used for testing");

        training_data_ABS_Count = (int)round((entered_data_Count / 2.0), 0);
        training_data_ABS_Field.setValue(training_data_ABS_Count);
        training_data_ABS_Field.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                training_data_ABS_Count = Integer.parseInt(training_data_ABS_Field.getText());
                testing_data_ABS_Count = entered_data_Count - Integer.parseInt(training_data_ABS_Field.getText());
                half_data_ABS_Label.setText("data used for training, and " + testing_data_ABS_Count + " data used for testing");
            }
        });
        half_data_ABS_Label.setText("data used for training, and " + (entered_data_Count - training_data_ABS_Count) + " data used for testing");
        
        training_data_ARMAABS_Count = (int)round((entered_data_Count / 2.0), 0);
        training_data_ARMAABS_Field.setValue(training_data_ARMAABS_Count);
        training_data_ARMAABS_Field.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                half_data_ARMAABS_Label.setText("data used for training, and " + (entered_data_Count - Integer.parseInt(training_data_ARMAABS_Field.getText())) + " data used for testing");
                training_data_ARMAABS_Count = Integer.parseInt(training_data_ARMAABS_Field.getText());
                testing_data_ARMAABS_Count = entered_data_Count - Integer.parseInt(training_data_ARMAABS_Field.getText());
            }
        });
        half_data_ARMAABS_Label.setText("data used for training, and " + (entered_data_Count - training_data_ARMAABS_Count) + " data used for testing");
        
        training_data_ARMA_Count = (int)round((entered_data_Count / 2.0), 0);
        training_data_ARMA_Field.setValue(training_data_ARMA_Count);
        training_data_ARMA_Field.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                half_data_ARMA_Label.setText("data used for training, and " + (entered_data_Count - Integer.parseInt(training_data_ARMA_Field.getText())) + " data used for testing");
                training_data_ARMA_Count = Integer.parseInt(training_data_ARMA_Field.getText());
                testing_data_ARMA_Count = entered_data_Count - Integer.parseInt(training_data_ARMA_Field.getText());
            }
        });
        half_data_ARMA_Label.setText("data used for training, and " + (entered_data_Count - training_data_ARMA_Count) + " data used for testing");

        if (scrollPanel1 != null) {
            data_Panel.remove(scrollPanel1);
            scrollPanel1 = null;
        }
        scrollPanel1 = new JScrollPane(table1);
        scrollPanel1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        scrollPanel1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        scrollPanel1.setBounds(10, 240, 600, 337);
        data_Panel.add(scrollPanel1);
    }
}