package main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class LoadYahooDataListener implements ActionListener {
    StartApplet applet;

    public LoadYahooDataListener(StartApplet applet) {
        this.applet = applet;
    }

    public void actionPerformed(ActionEvent e) {
        String stock_name = applet.stock_name_Field.getText();
        int start_month = applet.start_month_Box.getSelectedIndex();
        String start_day = applet.start_day_Field.getText();
        String start_year = applet.start_year_Field.getText();
        int end_month = applet.end_month_Box.getSelectedIndex();
        String end_day = applet.end_day_Field.getText();
        String end_year = applet.end_year_Field.getText();
        String type = applet.type_Group.getSelection().getActionCommand();

        try {
            applet.read_Label.setBounds(10, 210, 120, 20);
            applet.read_Label.setVisible(true);
            applet.read_top_Button.setBounds(125, 210, 125, 20);
            applet.read_top_Button.setVisible(true);
            applet.read_bottom_Button.setSelected(true);
            applet.read_bottom_Button.setBounds(250, 210, 130, 20);
            applet.read_bottom_Button.setVisible(true);
            applet.column_Label.setBounds(10, 240, 280, 20);
            applet.column_Label.setVisible(true);
            applet.column_Field.setValue(7);
            applet.column_Field.setBounds(290, 240, 40, 20);
            applet.column_Field.setVisible(true);

            //nuskaitom CSV failą iš Yahoo puslapio
            URL yahooUrl = new URL("http://ichart.finance.yahoo.com/table.csv?s=" + stock_name +
                "&a=" + start_month + "&b=" + start_day + "&c=" + start_year +
                "&d=" + end_month + "&e=" + end_day + "&f=" + end_year + "&g=" + type + "&ignore=.csv");
            URLConnection yc = yahooUrl.openConnection();
            CSVFileReader csv = new CSVFileReader(new InputStreamReader(yc.getInputStream()));
            csv.ReadFileFromURL();
            ArrayList<String> a = csv.getArrayList();
            String titles[] = new String[7];
            titles = a.get(0).split(","); //stulpelių pavadinimai
            String data[][] = new String[a.size()-1][7]; //duomenys
            for (int i = 1; i < a.size(); i++)
                data[i-1] = a.get(i).split(",");

            //atvaizduojam nuskaitytus duomenis lentelėje
            if ( applet.table1 != null ) {
                applet.scrollPanel1.remove(applet.table1);
                applet.table1 = null;
            }
            applet.table1 = new JTable(data, titles);
            applet.entered_data_Count = applet.table1.getRowCount();
            applet.data_count_AR_Label.setText("You have " + applet.entered_data_Count + " data.");
            applet.data_count_ABS_Label.setText("You have " + applet.entered_data_Count + " data.");
            applet.data_count_ARMA_Label.setText("You have " + applet.entered_data_Count + " data.");
            applet.data_count_ARMAABS_Label.setText("You have " + applet.entered_data_Count + " data.");
            
            //ExcelExporter exp = new ExcelExporter(); 
            //File file = new File("results1.xls"); 
            //exp.exportTable(applet.table1, file);  

            applet.training_data_AR_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_AR_Field.setValue(applet.training_data_AR_Count);
            applet.training_data_AR_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_AR_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_AR_Field.getText())) + " data used for testing");
                    applet.training_data_AR_Count = Integer.parseInt(applet.training_data_AR_Field.getText());
                    applet.testing_data_AR_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_AR_Field.getText());
                }
            });
            applet.half_data_AR_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_AR_Count) + " data used for testing");

            applet.training_data_ABS_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_ABS_Field.setValue(applet.training_data_ABS_Count);
            applet.training_data_ABS_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_ABS_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_ABS_Field.getText())) + " data used for testing");
                    applet.training_data_ABS_Count = Integer.parseInt(applet.training_data_ABS_Field.getText());
                    applet.testing_data_ABS_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_ABS_Field.getText());
                }
            });
            applet.half_data_ABS_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_ABS_Count) + " data used for testing");
            
            applet.training_data_ARMA_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_ARMA_Field.setValue(applet.training_data_ARMA_Count);
            applet.training_data_ARMA_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_ARMA_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMA_Field.getText())) + " data used for testing");
                    applet.training_data_ARMA_Count = Integer.parseInt(applet.training_data_ARMA_Field.getText());
                    applet.testing_data_ARMA_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMA_Field.getText());
                }
            });
            applet.half_data_ARMA_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_ARMAABS_Count) + " data used for testing");
            
            applet.training_data_ARMAABS_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_ARMAABS_Field.setValue(applet.training_data_ARMAABS_Count);
            applet.training_data_ARMAABS_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_ARMAABS_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMAABS_Field.getText())) + " data used for testing");
                    applet.training_data_ARMAABS_Count = Integer.parseInt(applet.training_data_ARMAABS_Field.getText());
                    applet.testing_data_ARMAABS_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMAABS_Field.getText());
                }
            });
            applet.half_data_ARMAABS_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_ARMAABS_Count) + " data used for testing");

            if ( applet.scrollPanel1 != null ) {
                applet.data_Panel.remove(applet.scrollPanel1);
                applet.scrollPanel1 = null;
            }
            applet.scrollPanel1 = new JScrollPane(applet.table1);
            applet.scrollPanel1.setVerticalScrollBarPolicy(22);
            applet.scrollPanel1.setBounds(10, 270, 600, 337);
            applet.data_Panel.add(applet.scrollPanel1);
        }
        catch(Exception ex) {
            System.out.println("Unable to get stock info: " + ex);
        }
    }
}