package main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.w3c.dom.*;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

class LoadXMLFileListener implements ActionListener {
    StartApplet applet;
    private String data[][];

    public LoadXMLFileListener(StartApplet applet) {
        this.applet = applet;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        int choice = fc.showOpenDialog(fc);
        if ( choice == JFileChooser.APPROVE_OPTION ) {
            try {
                applet.read_Label.setBounds(10, 150, 120, 20);
                applet.read_Label.setVisible(true);
                applet.read_top_Button.setSelected(true);
                applet.read_top_Button.setBounds(125, 150, 125, 20);
                applet.read_top_Button.setVisible(true);
                applet.read_bottom_Button.setBounds(250, 150, 130, 20);
                applet.read_bottom_Button.setVisible(true);
            
                applet.filepath = fc.getSelectedFile().getPath();
                File file = new File( applet.filepath );
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = (Document) db.parse(file);
                doc.getDocumentElement().normalize();
                NodeList data_List = doc.getElementsByTagName("data");

                data = new String[data_List.getLength()-1][1];
                
                for (int i = 0; i < data_List.getLength()-1; i++) {
                    Element data_Element = (Element) data_List.item(i);
                    NodeList data2 = data_Element.getChildNodes();
                    data[i][0] = ((Node) data2.item(0)).getNodeValue(); //duomenys
                }
            }
            catch (Exception error) {
                System.out.println("Error: " + error);
            }
            
            String title[] = new String[1];
            title[0] = "Data"; //stulpelio pavadinimas

            //atvaizduojam nuskaitytus duomenis lentelėje
            if ( applet.table1 != null ) {
                applet.scrollPanel1.remove(applet.table1);
                applet.table1 = null;
            }
            applet.table1 = new JTable(data, title);
            applet.table1.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
            applet.entered_data_Count = applet.table1.getRowCount();
            applet.data_count_AR_Label.setText("You have " + applet.entered_data_Count + " data.");
            applet.data_count_ABS_Label.setText("You have " + applet.entered_data_Count + " data.");
            applet.data_count_ARMA_Label.setText("You have " + applet.entered_data_Count + " data.");
            applet.data_count_ARMAABS_Label.setText("You have " + applet.entered_data_Count + " data.");

            applet.training_data_AR_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_AR_Field.setValue(applet.training_data_AR_Count);
            applet.training_data_AR_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_AR_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_AR_Field.getText())) + " data used for testing");
                    applet.training_data_AR_Count = Integer.parseInt(applet.training_data_AR_Field.getText());
                    applet.testing_data_AR_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_AR_Field.getText());
                }
            });
            applet.half_data_AR_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_AR_Count) + " data used for testing");

            applet.training_data_ABS_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_ABS_Field.setValue(applet.training_data_ABS_Count);
            applet.training_data_ABS_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_ABS_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_ABS_Field.getText())) + " data used for testing");
                    applet.training_data_ABS_Count = Integer.parseInt(applet.training_data_ABS_Field.getText());
                    applet.testing_data_ABS_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_ABS_Field.getText());
                }
            });
            applet.half_data_ABS_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_ABS_Count) + " data used for testing");
            
            applet.training_data_ARMA_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_ARMA_Field.setValue(applet.training_data_ARMA_Count);
            applet.training_data_ARMA_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_ARMA_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMA_Field.getText())) + " data used for testing");
                    applet.training_data_ARMA_Count = Integer.parseInt(applet.training_data_ARMA_Field.getText());
                    applet.testing_data_ARMA_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMA_Field.getText());
                }
            });
            applet.half_data_ARMA_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_ARMA_Count) + " data used for testing");
            
            applet.training_data_ARMAABS_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_ARMAABS_Field.setValue(applet.training_data_ARMAABS_Count);
            applet.training_data_ARMAABS_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_ARMAABS_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMAABS_Field.getText())) + " data used for testing");
                    applet.training_data_ARMAABS_Count = Integer.parseInt(applet.training_data_ARMAABS_Field.getText());
                    applet.testing_data_ARMAABS_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMAABS_Field.getText());
                }
            });
            applet.half_data_ARMAABS_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_ARMAABS_Count) + " data used for testing");

            if ( applet.scrollPanel1 != null ) {
                applet.data_Panel.remove(applet.scrollPanel1);
                applet.scrollPanel1 = null;
            }
            applet.scrollPanel1 = new JScrollPane(applet.table1);
            applet.scrollPanel1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            applet.scrollPanel1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
            applet.scrollPanel1.setBounds(10, 180, 600, 337);
            applet.data_Panel.add(applet.scrollPanel1);
        }
    }
}