package main;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.*;
import javax.swing.table.TableCellRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;

class LoadTestDataABSListener implements ActionListener {
    private StartApplet applet;
    private int forecast_ABS;
    private double test_error_sum, bendra_suma2, bendra_suma3, bendra_suma4, bendra_suma5;
    private double[] new_array, new_array_ABS, forecast_array;
    private String data[][];
    private JPanel test_data_ABS_Panel;
    private JLabel MAE_test_ABS_Label, MAPE_test_ABS_Label, PMAD_test_ABS_Label, MSE_test_ABS_Label, RMSE_test_ABS_Label, residual_variance_test_ABS_Label;
    private JLabel MAE_test_value_ABS_Label, MAPE_test_value_ABS_Label, PMAD_test_value_ABS_Label, MSE_test_value_ABS_Label, RMSE_test_value_ABS_Label, residual_variance_test_value_ABS_Label;
    private JButton save_test_CSV_ABS_Button;
    private JScrollPane test_data_ABS_Scroll;

    public LoadTestDataABSListener(StartApplet applet) {
        this.applet = applet;
    }

    public void actionPerformed(ActionEvent e) {
        applet.test_data_ABS_Frame = new JFrame();
        applet.test_data_ABS_Frame.setTitle("Test AR-ABS data");
        applet.test_data_ABS_Frame.setSize(800,600);
        applet.test_data_ABS_Frame.setVisible(true);

        String titles[] = new String[4];
        titles[0] = "No.";
        titles[1] = "Actual value";
        titles[2] = "Forecast";
        titles[3] = "Error";

        String forecast_string = applet.forecast_ABS_Field.getText();
        int forecast_length = forecast_string.length();
        if ( forecast_length <= 0 ) forecast_ABS = 1;
        else forecast_ABS = Integer.parseInt( applet.forecast_ABS_Field.getText() );

        data = new String[applet.entered_data_Count+forecast_ABS][5];

        applet.forecast_test_ABS_Series = new TimeSeries( "Forecast", Day.class );

        new_array = new double[applet.entered_data_Count];
        for ( int i = 0; i < applet.entered_data_Count; i++ ) {
            data[i][0] = Integer.toString(i+1) + "."; //numeracija
            data[i][1] = String.valueOf( applet.data_ABS_Table.getValueAt(i, 1) ); //realūs duomenys
            new_array[i] = Double.parseDouble( String.valueOf( applet.data_ABS_Table.getValueAt(i, 1) ) );
        }

        test_error_sum = 0;
        bendra_suma2 = 0;
        bendra_suma3 = 0;
        bendra_suma4 = 0;
        bendra_suma5 = 0;

        applet.testing_data_ABS_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_ABS_Field.getText());

        int n = 0;
        forecast_array = new double[applet.testing_data_ABS_Count];
        for ( int i = applet.training_data_ABS_Count; i < applet.entered_data_Count; i++ ) {
            double suma = 0;
            for ( int j = 0; j < applet.coef_ABS.length; j++ ) {
                suma += applet.coef_ABS[j] * new_array[i-j-1];
                forecast_array[n] = suma;
            }
            data[i][2] = Double.toString( applet.round(suma, 3) );

            double error = new_array[applet.training_data_ABS_Count+n] - forecast_array[n];
            bendra_suma5 += error;
            if ( error < 0 ) error = error * (-1);
            data[i][3] = Double.toString( applet.round(error, 3) );
            test_error_sum += error;
            bendra_suma2 += error / Double.parseDouble( String.valueOf( applet.data_ABS_Table.getValueAt(i, 1) ) );
            bendra_suma3 += Double.parseDouble( String.valueOf( applet.data_ABS_Table.getValueAt(i, 1) ) );
            bendra_suma4 += error * error;

            Date now = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(now);
            cal.add(Calendar.DAY_OF_YEAR, i+1);
            Date tomorrow = cal.getTime();
            applet.forecast_test_ABS_Series.add( new Day( tomorrow ), applet.round(suma, 3) );
            n++;
        }

        new_array_ABS = new double[forecast_ABS+applet.p_value_ABS];
        for ( int i = applet.p_value_ABS; i > 0; i-- ) {
            new_array_ABS[applet.p_value_ABS-i] = applet.entered_data_ABS[applet.entered_data_Count-i];
        }

        applet.forecast_ABS_Series.clear();

        int y = 0;
        for ( int i = applet.entered_data_Count; i < applet.entered_data_Count+forecast_ABS; i++ ) {
            data[i][0] = Integer.toString(i+1) + ".";
            double suma = 0;
            for ( int j = 0; j < applet.coef_ABS.length; j++ )
                suma += applet.coef_ABS[j] * new_array_ABS[applet.p_value_ABS+y-j-1];
            new_array_ABS[applet.p_value_ABS+y] = suma;
            data[i][2] = Double.toString( applet.round(suma, 3) );
            Date now = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(now);
            cal.add(Calendar.DAY_OF_YEAR, i+1);
            Date tomorrow = cal.getTime();
            applet.forecast_test_ABS_Series.add( new Day( tomorrow ), applet.round(suma,3) );
            y++;
        }

        test_data_ABS_Panel = new JPanel();
        test_data_ABS_Panel.setLayout(null);
        applet.test_data_ABS_Frame.add(test_data_ABS_Panel);

        applet.test_data_ABS_Table = new JTable(data, titles) {
            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if ( row >= applet.training_data_ABS_Count ) c.setBackground(new Color(200,221,242));
                else c.setBackground(null);
                return c;
            }
        };
        test_data_ABS_Scroll = new JScrollPane(applet.test_data_ABS_Table);
        test_data_ABS_Scroll.setVerticalScrollBarPolicy(22);
        test_data_ABS_Scroll.setBounds(10, 10, 400, 337);
        test_data_ABS_Panel.add(test_data_ABS_Scroll);

        applet.graphic_ABS_Button = new JButton("Graphic");
        applet.graphic_ABS_Button.setBounds(10, 355, 90, 20);
        LoadGraphicListener Graphic_Listener = new LoadGraphicListener( applet, "AR-ABS test data graphic", 4 );
        applet.graphic_ABS_Button.addActionListener(Graphic_Listener);
        test_data_ABS_Panel.add(applet.graphic_ABS_Button);

        save_test_CSV_ABS_Button = new JButton("Save CSV file");
        save_test_CSV_ABS_Button.setBounds(110, 355, 120, 20);
        CSVFileSaveListener test_CSV_file_ABS_Listener = new CSVFileSaveListener( applet, 4 );
        save_test_CSV_ABS_Button.addActionListener(test_CSV_file_ABS_Listener);
        test_data_ABS_Panel.add(save_test_CSV_ABS_Button);

        MAE_test_ABS_Label = new JLabel("Mean absolute error (MAE)");
        MAE_test_ABS_Label.setBounds(10, 380, 300, 20);
        test_data_ABS_Panel.add(MAE_test_ABS_Label);

        MAE_test_value_ABS_Label = new JLabel();
        MAE_test_value_ABS_Label.setBounds(300, 380, 300, 20);
        test_data_ABS_Panel.add(MAE_test_value_ABS_Label);

        MAPE_test_ABS_Label = new JLabel("Mean absolute percentage error (MAPE)");
        MAPE_test_ABS_Label.setBounds(10, 405, 300, 20);
        test_data_ABS_Panel.add(MAPE_test_ABS_Label);

        MAPE_test_value_ABS_Label = new JLabel();
        MAPE_test_value_ABS_Label.setBounds(300, 405, 300, 20);
        test_data_ABS_Panel.add(MAPE_test_value_ABS_Label);

        PMAD_test_ABS_Label = new JLabel("Percent mean absolute deviation (PMAD)");
        PMAD_test_ABS_Label.setBounds(10, 430, 300, 20);
        test_data_ABS_Panel.add(PMAD_test_ABS_Label);

        PMAD_test_value_ABS_Label = new JLabel();
        PMAD_test_value_ABS_Label.setBounds(300, 430, 300, 20);
        test_data_ABS_Panel.add(PMAD_test_value_ABS_Label);

        MSE_test_ABS_Label = new JLabel("Mean squared error (MSE)");
        MSE_test_ABS_Label.setBounds(10, 455, 300, 20);
        test_data_ABS_Panel.add(MSE_test_ABS_Label);

        MSE_test_value_ABS_Label = new JLabel();
        MSE_test_value_ABS_Label.setBounds(300, 455, 300, 20);
        test_data_ABS_Panel.add(MSE_test_value_ABS_Label);

        RMSE_test_ABS_Label = new JLabel("Root mean squared error (RMSE)");
        RMSE_test_ABS_Label.setBounds(10, 480, 300, 20);
        test_data_ABS_Panel.add(RMSE_test_ABS_Label);

        RMSE_test_value_ABS_Label = new JLabel();
        RMSE_test_value_ABS_Label.setBounds(300, 480, 300, 20);
        test_data_ABS_Panel.add(RMSE_test_value_ABS_Label);

        residual_variance_test_ABS_Label = new JLabel("Residual variance");
        residual_variance_test_ABS_Label.setBounds(10, 505, 300, 20);
        test_data_ABS_Panel.add(residual_variance_test_ABS_Label);

        residual_variance_test_value_ABS_Label = new JLabel();
        residual_variance_test_value_ABS_Label.setBounds(300, 505, 300, 20);
        test_data_ABS_Panel.add(residual_variance_test_value_ABS_Label);

        double MAE = 0;
        if ( test_error_sum == Double.NaN || test_error_sum == Double.POSITIVE_INFINITY || test_error_sum == Double.NEGATIVE_INFINITY )
            MAE = 0;
        else MAE = test_error_sum / applet.testing_data_ABS_Count;
        MAE_test_value_ABS_Label.setText( " = " + Double.toString( applet.round(MAE, 3) ) );

        double MAPE = 0;
        if ( bendra_suma2 == Double.NaN || bendra_suma2 == Double.POSITIVE_INFINITY || bendra_suma2 == Double.NEGATIVE_INFINITY )
            MAPE = 0;
        else MAPE = bendra_suma2 / applet.testing_data_ABS_Count;
        MAPE_test_value_ABS_Label.setText( " = " + Double.toString( applet.round(MAPE, 3) ) );

        double PMAD = 0;
        if ( test_error_sum == Double.NaN || test_error_sum == Double.POSITIVE_INFINITY || test_error_sum == Double.NEGATIVE_INFINITY ||
            bendra_suma3 == Double.NaN || bendra_suma3 == Double.POSITIVE_INFINITY || bendra_suma3 == Double.NEGATIVE_INFINITY ||
            test_error_sum == 0 || bendra_suma3 == 0 )
                PMAD = 0;
        else PMAD = test_error_sum / bendra_suma3;
        PMAD_test_value_ABS_Label.setText( " = " + Double.toString( applet.round(PMAD, 3) ) );

        double MSE = 0;
        if ( bendra_suma4 == Double.NaN || bendra_suma4 == Double.POSITIVE_INFINITY || bendra_suma4 == Double.NEGATIVE_INFINITY )
            MSE = 0;
        else MSE = bendra_suma4 / applet.testing_data_ABS_Count;
        MSE_test_value_ABS_Label.setText( " = " + Double.toString( applet.round(MSE, 3) ) );

        double RMSE = 0;
        if ( MSE == 0 ) RMSE = 0;
        else RMSE = Math.sqrt(MSE);
        RMSE_test_value_ABS_Label.setText( " = " + Double.toString( applet.round(RMSE, 3) ) );

        double residual_variance = 0;
        residual_variance = ( bendra_suma4 - ((bendra_suma5*bendra_suma5)/applet.testing_data_ABS_Count) ) / ( applet.testing_data_ABS_Count - 1 );
        residual_variance_test_value_ABS_Label.setText( " = " + Double.toString( applet.round(residual_variance, 3) ) );
    }
}