package main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class LoadNASDAQDataListener implements ActionListener {
    StartApplet applet;

    public LoadNASDAQDataListener(StartApplet applet) {
        this.applet = applet;
    }

    public void actionPerformed(ActionEvent e) {
        String stock_code = ((Select)applet.stock_list_Box.getSelectedItem()).id;
        String currency = applet.currency_Group.getSelection().getActionCommand();
        int start_month = applet.start_month_Box.getSelectedIndex();
        String start_day = applet.start_day_Field.getText();
        String start_year = applet.start_year_Field.getText();
        int end_month = applet.end_month_Box.getSelectedIndex();
        String end_day = applet.end_day_Field.getText();
        String end_year = applet.end_year_Field.getText();

        try {
            applet.read_Label.setBounds(10, 240, 120, 20);
            applet.read_Label.setVisible(true);
            applet.read_top_Button.setSelected(true);
            applet.read_top_Button.setBounds(125, 240, 125, 20);
            applet.read_top_Button.setVisible(true);
            applet.read_bottom_Button.setBounds(250, 240, 130, 20);
            applet.read_bottom_Button.setVisible(true);
            applet.column_Label.setBounds(10, 270, 280, 20);
            applet.column_Label.setVisible(true);
            applet.column_Field.setValue(8);
            applet.column_Field.setBounds(290, 270, 40, 20);
            applet.column_Field.setVisible(true);

            URL nasdaqUrl = new URL("http://www.nasdaqomxbaltic.com/market/?instrument=" + stock_code +
                "&list=2&pg=details&tab=historical&lang=en&currency=" + currency + "&downloadcsv=0&date=&start_d=" + start_day +
                "&start_m=" + (start_month+1) + "&start_y=" + start_year + "&end_d=" + end_day +
                "&end_m=" + (end_month+1) + "&end_y=" + end_year + "&pg=details&pg2=equity&downloadcsv=1&csv_style=baltic");
            URLConnection yc = nasdaqUrl.openConnection();
            CSVFileReader csv = new CSVFileReader(new InputStreamReader(yc.getInputStream()));
            csv.ReadFileFromURL();
            ArrayList<String> a = csv.getArrayList();
            String titles[] = new String[8];
            titles = a.get(5).split(";"); //stulpelių pavadinimai
            String data [][] = new String[a.size()-6][8]; //duomenys
            for (int i = 6; i < a.size(); i++)
                data[i-6] = a.get(i).replace(",", ".").split(";");

            //atvaizduojam nuskaitytus duomenis lentelėje
            if ( applet.table1 != null ) {
                applet.scrollPanel1.remove(applet.table1);
                applet.table1 = null;
            }
            applet.table1 = new JTable(data, titles);
            applet.table1.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
            applet.entered_data_Count = applet.table1.getRowCount();
            applet.data_count_AR_Label.setText("You have " + applet.entered_data_Count + " data.");
            applet.data_count_ABS_Label.setText("You have " + applet.entered_data_Count + " data.");
            applet.data_count_ARMA_Label.setText("You have " + applet.entered_data_Count + " data.");
            applet.data_count_ARMAABS_Label.setText("You have " + applet.entered_data_Count + " data.");

            applet.training_data_AR_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_AR_Field.setValue(applet.training_data_AR_Count);
            applet.training_data_AR_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_AR_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_AR_Field.getText())) + " data used for testing");
                    applet.training_data_AR_Count = Integer.parseInt(applet.training_data_AR_Field.getText());
                    applet.testing_data_AR_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_AR_Field.getText());
                }
            });
            applet.half_data_AR_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_AR_Count) + " data used for testing");

            applet.training_data_ABS_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_ABS_Field.setValue(applet.training_data_ABS_Count);
            applet.training_data_ABS_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_ABS_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_ABS_Field.getText())) + " data used for testing");
                    applet.training_data_ABS_Count = Integer.parseInt(applet.training_data_ABS_Field.getText());
                    applet.testing_data_ABS_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_ABS_Field.getText());
                }
            });
            applet.half_data_ABS_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_ABS_Count) + " data used for testing");
            
            applet.training_data_ARMA_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_ARMA_Field.setValue(applet.training_data_ARMA_Count);
            applet.training_data_ARMA_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_ARMA_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMA_Field.getText())) + " data used for testing");
                    applet.training_data_ARMA_Count = Integer.parseInt(applet.training_data_ARMA_Field.getText());
                    applet.testing_data_ARMA_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMA_Field.getText());
                }
            });
            applet.half_data_ARMA_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_ARMA_Count) + " data used for testing");
            
            applet.training_data_ARMAABS_Count = (int)applet.round((applet.entered_data_Count / 2.0), 0);
            applet.training_data_ARMAABS_Field.setValue(applet.training_data_ARMAABS_Count);
            applet.training_data_ARMAABS_Field.addKeyListener(new KeyAdapter() {
                @Override
                public void keyReleased(KeyEvent e) {
                    applet.half_data_ARMAABS_Label.setText("data used for training, and " + (applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMAABS_Field.getText())) + " data used for testing");
                    applet.training_data_ARMAABS_Count = Integer.parseInt(applet.training_data_ARMAABS_Field.getText());
                    applet.testing_data_ARMAABS_Count = applet.entered_data_Count - Integer.parseInt(applet.training_data_ARMAABS_Field.getText());
                }
            });
            applet.half_data_ARMAABS_Label.setText("data used for training, and " + (applet.entered_data_Count - applet.training_data_ARMAABS_Count) + " data used for testing");

            if ( applet.scrollPanel1 != null ) {
                applet.data_Panel.remove(applet.scrollPanel1);
                applet.scrollPanel1 = null;
            }
            applet.scrollPanel1 = new JScrollPane(applet.table1);
            applet.scrollPanel1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            applet.scrollPanel1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
            applet.scrollPanel1.setBounds(10, 300, 600, 337);
            applet.data_Panel.add(applet.scrollPanel1);
        }
        catch(Exception ex) {
            System.out.println("Unable to get stockinfo: " + ex);
        }
    }
}