package main;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimeSeriesCollection;

class LoadGraphicListener implements ActionListener {
    private StartApplet applet;
    private String title;
    int model_number;
    
    public LoadGraphicListener(StartApplet applet, String title, int model_number ) {
        this.applet = applet;
        this.title = title;
        this.model_number = model_number;
    }

    public void actionPerformed(ActionEvent e) {
        applet.graphicFrame = new JFrame();
        applet.graphicFrame.setTitle(title);
        applet.graphicFrame.setSize(500,300);
        applet.graphicFrame.setVisible(true);

        final TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.setDomainIsPointsInTime(true);

        switch ( model_number ) {
            case 1: //nuskaitant vartotojo įvestus duomenis išjungiam šiuos laukus:
                dataset.addSeries(applet.real_AR_Series);
                dataset.addSeries(applet.forecast_AR_Series);
                break;
            case 2:
                dataset.addSeries(applet.real_ABS_Series);
                dataset.addSeries(applet.forecast_ABS_Series);
                break;
            case 3:
                dataset.addSeries(applet.real_AR_Series);
                dataset.addSeries(applet.forecast_test_AR_Series);
                break;
            case 4:
                dataset.addSeries(applet.real_ABS_Series);
                dataset.addSeries(applet.forecast_test_ABS_Series);
                break;
            case 5:
                dataset.addSeries(applet.real_ARMAABS_Series);
                dataset.addSeries(applet.forecast_ARMAABS_Series);
                break;
        }
        JFreeChart chart = ChartFactory.createTimeSeriesChart("Stock price", "Date", "Stock price", dataset, true, false, false);
        /*
        JFreeChart chart = ChartFactory.createXYLineChart(
            "",                         // chart title
            "No.",                      // x axis label
            "Data value",               // y axis label
            dataset,                    // data
            PlotOrientation.VERTICAL,
            true,                       // include legend
            true,                       // tooltips
            false                       // urls
        );
        */
        chart.setBackgroundPaint(new Color(240,240,240));
        final XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.white);
        plot.setDomainGridlinePaint(new Color(191,191,191));
        plot.setRangeGridlinePaint(new Color(191,191,191));

        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setBounds(10, 430, 500, 300);
        applet.graphicFrame.add(chartPanel);
    }
}