/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.vector.doubles.operation;

import com.numericalmethod.suanshu.datastructure.list.VectorList;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class Projection {
    public final double[] length;
    public final Vector orthogonalVector;
    public final Vector[] projVector;
    private final VectorList E;

    public Projection(Vector v, VectorList basis) {
        int a2;
        this.E = basis;
        int a3 = basis.size();
        this.length = new double[a3];
        this.projVector = new Vector[a3];
        Vector a4 = v.deepCopy();
        int n = a2 = 0;
        while (n < a3) {
            Vector a5 = (Vector)basis.get(a2);
            if (a5 != null) {
                this.length[a2] = a4.innerProduct(a5);
                this.projVector[a2] = a5.scaled(this.length[a2]);
                a4 = a4.minus(this.projVector[a2]);
            }
            n = ++a2;
        }
        this.orthogonalVector = a4;
    }

    public Projection(Vector v, Vector basis) {
        this.E = new VectorList();
        this.E.add(basis);
        this.length = new double[1];
        this.projVector = new Vector[1];
        Vector a2 = v;
        Vector a3 = basis;
        if (a3 != null) {
            this.length[0] = a2.innerProduct(a3);
            this.projVector[0] = a3.scaled(this.length[0]);
            a2 = a2.minus(this.projVector[0]);
        }
        this.orthogonalVector = a2;
    }

    public Projection(Vector v, Vector[] basis) {
        this(v, new VectorList(basis));
    }
}

