/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.time;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

public class JodaTimeUtils {
    public static final DateTime BEGINNING_OF_TIME;
    public static final long ENDING_OF_TIME_LONG;
    public static final DateTime ORIGIN;
    public static final DateTimeZone GMT;
    public static final DateTime ENDING_OF_TIME;
    public static final long BEGINNING_OF_TIME_LONG;
    public static final DateTimeZone EST;

    public static DateTime getDateTime(String str) throws ParseException {
        DateTimeZone a2 = DateTimeZone.forID(str.substring(str.lastIndexOf(32) + 1, str.length()));
        SimpleDateFormat a3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSSS");
        String a4 = str.substring(0, str.lastIndexOf(32));
        return JodaTimeUtils.getDateTime(a4, a3, a2);
    }

    public static DateTime getDateTime(String str, DateFormat format, DateTimeZone tz) throws ParseException {
        if (tz != null) {
            format.setTimeZone(tz.toTimeZone());
        }
        long a2 = format.parse(str).getTime();
        return new DateTime(a2, tz);
    }

    public static List<DateTime> makePeriodicInstants(DateTime startTime, Period period, int nPeriods) {
        int a2;
        ArrayList<DateTime> a3 = new ArrayList<DateTime>(nPeriods + 1);
        a3.add(startTime);
        DateTime a4 = startTime;
        int n = a2 = 0;
        while (n < nPeriods) {
            a4 = a4.plus(period);
            a3.add(a4);
            n = ++a2;
        }
        return a3;
    }

    public static DateTime min(DateTime t1, DateTime t2) {
        return t1.compareTo(t2) <= 0 ? t1 : t2;
    }

    public static DateTime previousWeekDay(DateTime time) {
        DateTime a2 = new DateTime(time.getYear(), time.getMonthOfYear(), time.getDayOfMonth(), time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute(), time.getMillisOfSecond(), time.getZone());
        switch (time.getDayOfWeek()) {
            case 7: {
                do {
                } while (false);
                return a2.minusDays(2);
            }
            case 1: {
                return a2.minusDays(3);
            }
        }
        return a2.minusDays(1);
    }

    private JodaTimeUtils() {
        JodaTimeUtils a2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isWeekend(DateTime time) {
        if (time.getDayOfWeek() == 6) return true;
        if (time.getDayOfWeek() != 7) return false;
        return true;
    }

    static {
        GMT = DateTimeZone.forID("GMT");
        EST = DateTimeZone.forID("EST");
        ORIGIN = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
        BEGINNING_OF_TIME = new DateTime(0, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
        BEGINNING_OF_TIME_LONG = BEGINNING_OF_TIME.getMillis();
        ENDING_OF_TIME = new DateTime(9999, 12, 31, 0, 0, 0, 0, DateTimeZone.UTC);
        ENDING_OF_TIME_LONG = ENDING_OF_TIME.getMillis();
    }

    public static DateTime plusWeekdayPeriod(DateTime time, Period period) {
        DateTime a2 = time;
        if (JodaTimeUtils.isWeekend(time)) {
            a2 = JodaTimeUtils.nextWeekDay(time).withTime(0, 0, 0, 0);
        }
        int a3 = period.getDays() / 5;
        int a4 = period.getDays() % 5;
        Period a5 = period.minusDays(period.getDays());
        DateTime a6 = a2.plusWeeks(a3);
        a6 = a6.plusDays(a4);
        if (a4 + a2.getDayOfWeek() > 5) {
            a6 = a6.plusDays(2);
        }
        a6 = a6.plus(a5);
        if (a6.getDayOfWeek() == 6) {
            a6 = a6.plusDays(2);
        }
        return a6;
    }

    public static DateTime getLastMillisecondOfDay(DateTime t) {
        return t.withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59).withMillisOfSecond(999);
    }

    public static DateTime getDate(int year, int month, int day, DateTimeZone tz) {
        return new DateTime(year, month, day, 0, 0, 0, 0, tz);
    }

    public static DateTime getLastDayOfMonth(DateTime t) {
        return t.dayOfMonth().withMaximumValue();
    }

    public static DateTime nextWeekDay(DateTime time) {
        DateTime a2 = new DateTime(time.getYear(), time.getMonthOfYear(), time.getDayOfMonth(), time.getHourOfDay(), time.getMinuteOfHour(), time.getSecondOfMinute(), time.getMillisOfSecond(), time.getZone());
        switch (time.getDayOfWeek()) {
            case 5: {
                return a2.plusDays(3);
            }
            case 6: {
                do {
                } while (false);
                return a2.plusDays(2);
            }
        }
        return a2.plusDays(1);
    }

    public static int getNumberOfPeriodsBetween(DateTime t1, DateTime t2, Period period) {
        DateTime a2;
        int a3 = 0;
        DateTime dateTime = a2 = new DateTime(t1);
        while (dateTime.isBefore(t2)) {
            ++a3;
            dateTime = a2.plus(period);
        }
        return a3;
    }

    public static DateTime max(DateTime t1, DateTime t2) {
        return t1.compareTo(t2) >= 0 ? t1 : t2;
    }

    public static DateTime minusWeekdayPeriod(DateTime time, Period period) {
        DateTime a2 = time;
        if (JodaTimeUtils.isWeekend(time)) {
            a2 = JodaTimeUtils.previousWeekDay(time).plusDays(1).withTime(0, 0, 0, 0);
        }
        int a3 = period.getDays() / 5;
        int a4 = period.getDays() % 5;
        Period a5 = period.minusDays(period.getDays());
        DateTime a6 = a2.minusWeeks(a3);
        a6 = a6.minusDays(a4);
        if (a4 > a2.getDayOfWeek()) {
            a6 = a6.minusDays(2);
        }
        a6 = a6.minus(a5);
        if (a6.getDayOfWeek() == 7) {
            a6 = a6.minusDays(2);
        }
        return a6;
    }
}

