/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.univariate.realtime;

import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.TimeSeries;
import java.util.ArrayList;
import java.util.Iterator;

public class SimpleTimeSeries
implements TimeSeries {
    private final ArrayList<Double> E = new ArrayList();

    @Override
    public double[] toArray() {
        return DoubleUtils.Collection2doubleArray(this.E);
    }

    public SimpleTimeSeries lag(int nLags) {
        return this.lag(nLags, this.size() - nLags);
    }

    @Override
    public double get(int t) {
        return this.E.get(t - 1);
    }

    @Override
    public Iterator<TimeSeries.Entry> iterator() {
        return new Iterator<TimeSeries.Entry>(){
            private final Iterator<Double> L;
            private int E;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("time series is immutable");
            }

            @Override
            public boolean hasNext() {
                return this.L.hasNext();
            }
            {
                1 a2;
                a2.L = a2.SimpleTimeSeries.this.E.iterator();
                a2.E = 1;
            }

            @Override
            public TimeSeries.Entry next() {
                Double a2 = this.L.next();
                int n = this.E;
                this.E = n + 1;
                return new TimeSeries.Entry(n, (double)a2);
            }
        };
    }

    @Override
    public int size() {
        return this.E.size();
    }

    public SimpleTimeSeries diff(int d2) {
        double[] a2 = this.toArray();
        return new SimpleTimeSeries(R.diff(a2, 1, d2));
    }

    public String toString() {
        int a2;
        int a3 = 20;
        StringBuilder a4 = new StringBuilder();
        Object[] objectArray = new Object[1];
        objectArray[0] = this.E.size();
        a4.append(String.format("length = %d\n", objectArray));
        int n = a2 = 1;
        while (n <= this.E.size()) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = a2;
            a4.append(String.format("[%d,] ", objectArray2));
            Object[] objectArray3 = new Object[1];
            objectArray3[0] = this.E.get(a2 - 1);
            a4.append(String.format("%f, ", objectArray3));
            if (a2 % 20 == 0) {
                a4.append("\n");
            }
            n = ++a2;
        }
        return a4.toString();
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 41 * a2 + (this.E != null ? this.E.hashCode() : 0);
        return a2;
    }

    public SimpleTimeSeries(double[] values) {
        int a2;
        double[] a3 = values;
        int a4 = values.length;
        int n = a2 = 0;
        while (n < a4) {
            double a5 = a3[a2];
            this.E.add(a5);
            n = ++a2;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTimeSeries a2 = (SimpleTimeSeries)obj;
        if (!(this.E == a2.E || this.E != null && this.E.equals(a2.E))) {
            return false;
        }
        return true;
    }

    public SimpleTimeSeries drop(int nItems) {
        return this.lag(0, this.size() - nItems);
    }

    public SimpleTimeSeries lag(int nLags, int length) {
        int a2;
        SuanShuUtils.assertArgument(nLags >= 0, "nLags >= 0", new Object[0]);
        int a3 = this.size() - nLags - length + 1;
        SuanShuUtils.assertArgument(a3 >= 1, "lagged series length is too long", new Object[0]);
        double[] a4 = new double[length];
        int n = a2 = a3;
        while (n <= this.size() - nLags) {
            a4[a2 - a3] = this.E.get(a2 - 1);
            n = ++a2;
        }
        return new SimpleTimeSeries(a4);
    }
}

