/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.garch;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.license.Package;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.number.DoubleArrayMath;
import java.util.Arrays;

public class GARCHModel {
    private double[] k;
    private double L;
    private double[] E;

    public int q() {
        return this.k != null ? this.k.length : 0;
    }

    public GARCHModel(double a0, double[] a2, double[] b2) {
        int a3;
        SuanShuUtils.assertArgument(a0 > 0.0, "a0 > 0", new Object[0]);
        SuanShuUtils.assertArgument(DoubleArrayMath.min(a2) >= 0.0, "{a} >= 0", new Object[0]);
        SuanShuUtils.assertArgument(DoubleArrayMath.min(b2) >= 0.0, "{b} >= 0", new Object[0]);
        double a4 = 0.0;
        int n = a3 = 1;
        while (n < a2.length) {
            a4 += a2[a3];
            n = ++a3;
        }
        int n2 = a3 = 1;
        while (n2 < b2.length) {
            a4 += b2[a3];
            n2 = ++a3;
        }
        SuanShuUtils.assertArgument(a4 < 1.0, "\u03a3{\u03b1} + \u03a3{\u03b2} < 1, (except for \u03b1<sub>0</sub>)", new Object[0]);
        this.L = a0;
        this.k = a2 != null ? Arrays.copyOf(a2, a2.length) : null;
        this.E = b2 != null ? Arrays.copyOf(b2, b2.length) : null;
    }

    static {
        Package.getInstance("STATS").isValidated();
    }

    public double a0() {
        return this.L;
    }

    public double sigma2(double[] e2, double[] sigma2_lag) {
        return this.L + FunctionOps.dotProduct(this.k, e2) + FunctionOps.dotProduct(this.E, sigma2_lag);
    }

    public double[] beta() {
        return this.E != null ? Arrays.copyOf(this.E, this.E.length) : null;
    }

    public double[] alpha() {
        return this.k != null ? Arrays.copyOf(this.k, this.k.length) : null;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append(this.L);
        int n = a2 = 0;
        while (n < this.k.length) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.k[a2];
            objectArray[1] = a2 + 1;
            a3.append(String.format("+ %f * e_{t-%d}", objectArray));
            n = ++a2;
        }
        int n2 = a2 = 0;
        while (n2 < this.E.length) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.E[a2];
            objectArray[1] = a2 + 1;
            a3.append(String.format("+ %f * h_{t-%d}", objectArray));
            n2 = ++a2;
        }
        return a3.toString();
    }

    public double var() {
        double d2;
        int a2;
        double a3 = 1.0;
        int n = a2 = 0;
        while (n < this.q()) {
            a3 -= this.k[a2];
            n = ++a2;
        }
        int n2 = a2 = 0;
        while (n2 < this.p()) {
            a3 -= this.E[a2];
            n2 = ++a2;
        }
        a3 = this.L / a3;
        SuanShuUtils.assertArgument(d2 > 0.0, "invalid GARCH specification (except \u03b1<sub>0</sub>), \u03a3{\u03b1} + \u03a3{\u03b2} < 1; invalid variance", new Object[0]);
        return a3;
    }

    public int maxPQ() {
        return Math.max(this.p(), this.q());
    }

    public int p() {
        return this.E != null ? this.E.length : 0;
    }

    public GARCHModel(GARCHModel that) {
        this.L = that.L;
        this.k = that.k != null ? Arrays.copyOf(that.k, that.k.length) : null;
        this.E = that.E != null ? Arrays.copyOf(that.E, that.E.length) : null;
    }
}

