/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arma.ARMAModel;
import java.util.Arrays;

public class LinearRepresentation {
    public static final int DEFAULT_NUMBER_OF_LAGS = 15;
    private double[] E;

    public LinearRepresentation(ARMAModel arma) {
        this(arma, 15);
    }

    public LinearRepresentation(ARMAModel arma, int nlags) {
        int a2;
        this.E = new double[nlags];
        int a3 = arma.p();
        int a4 = arma.q();
        int a5 = Math.max(a3, a4 + 1);
        double[][] dArrayArray = new double[2][];
        double[] dArray = new double[1];
        dArray[0] = 1.0;
        dArrayArray[0] = dArray;
        dArrayArray[1] = arma.MA();
        double[] a6 = DoubleUtils.concat(dArrayArray);
        double[][] dArrayArray2 = new double[2][];
        double[] dArray2 = new double[1];
        dArray2[0] = 1.0;
        dArrayArray2[0] = dArray2;
        dArrayArray2[1] = arma.AR();
        double[] a7 = DoubleUtils.concat(dArrayArray2);
        int n = a2 = 0;
        while (n < nlags) {
            int a8;
            if (a2 <= a5) {
                this.E[a2] = a2 <= a4 ? a6[a2] : 0.0;
                int n2 = a8 = 1;
                while (n2 <= a2) {
                    int n3 = a2;
                    this.E[n3] = this.E[n3] + (a8 <= a4 ? a7[a8] * this.E[a2 - a8] : 0.0);
                    n2 = ++a8;
                }
            } else {
                int n4 = a8 = 1;
                while (n4 <= a3) {
                    int n5 = a2;
                    this.E[n5] = this.E[n5] + (a8 <= a4 ? a7[a8] * this.E[a2 - a8] : 0.0);
                    n4 = ++a8;
                }
            }
            n = ++a2;
        }
    }

    public double[] psi() {
        return Arrays.copyOf(this.E, this.E.length);
    }
}

