/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.analysis.function.FunctionOps;
import com.numericalmethod.suanshu.analysis.function.rn2r1.RealScalarFunction;
import com.numericalmethod.suanshu.analysis.function.rn2r1.UnivariateRealFunction;
import com.numericalmethod.suanshu.analysis.integration.univariate.riemann.Riemann;
import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.matrix.doubles.operation.Inverse;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.optimization.unconstrained.NelderMead;
import com.numericalmethod.suanshu.stats.descriptive.moment.Mean;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arma.ARMAFitting;
import com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arma.ARMAModel;
import com.numericalmethod.suanshu.stats.timeseries.univariate.realtime.TimeSeries;
import com.numericalmethod.suanshu.vector.doubles.ImmutableVector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class ConditionalSumOfSquares
implements ARMAFitting {
    private final int F;
    private final double k;
    private final double L;
    private final Estimators E;

    public ConditionalSumOfSquares(TimeSeries xt, int p, int d2, int q2) {
        int a2;
        this.F = xt.size();
        double[] a3 = xt.toArray();
        if (d2 > 0) {
            a3 = R.diff(a3, 1, d2);
        }
        this.k = new Mean(a3).value();
        double[] a4 = new double[a3.length];
        int n = a2 = 0;
        while (n < a3.length) {
            a4[a2] = a3[a2] - this.k;
            n = ++a2;
        }
        RealScalarFunction a22 = ConditionalSumOfSquares.b(p, q2, a4);
        NelderMead a5 = new NelderMead();
        a5.solve(a22, 0.0, 500);
        double[] dArray = new double[p + q2 + 1];
        double[] a6 = dArray;
        dArray[p + q2] = 0.01;
        double[][] dArrayArray = new double[1][];
        dArrayArray[0] = a6;
        a6 = a5.search(dArrayArray);
        this.L = -1.0 * a22.evaluate(a6);
        this.E = new Estimators(a6, p, q2, null);
    }

    @Override
    public ImmutableVector stderr() {
        int a2;
        ImmutableMatrix a3 = this.covariance();
        int a4 = this.E.p() + this.E.q();
        DenseVector a5 = new DenseVector(a4);
        int n = a2 = 1;
        while (n <= a4) {
            a5.set(a2, Math.sqrt(a3.get(a2, a2)));
            n = ++a2;
        }
        return new ImmutableVector(a5);
    }

    @Override
    public ImmutableMatrix covariance() {
        int a2;
        int a3 = this.E.p();
        int a4 = this.E.q();
        int a5 = a3 + a4;
        Riemann a6 = new Riemann();
        DenseMatrix a7 = new DenseMatrix(a5, a5);
        int n = a2 = 1;
        while (n <= a5) {
            int n2 = a2;
            while (n2 <= a5) {
                int a8;
                final UnivariateRealFunction a9 = this.b(a2);
                final UnivariateRealFunction a10 = this.b(a8);
                UnivariateRealFunction a11 = new UnivariateRealFunction(){
                    {
                        1 a2;
                    }

                    @Override
                    public double evaluate(double x) {
                        double a2 = a9.evaluate(x);
                        double a3 = a10.evaluate(x);
                        return a2 * a3;
                    }
                };
                double a12 = a6.integrate(a11, -Math.PI, Math.PI);
                a7.set(a2, a8, a12 /= Math.PI * 4);
                a7.set(a8, a2, a12);
                n2 = ++a8;
            }
            n = ++a2;
        }
        Matrix a22 = new Inverse((Matrix)a7).scaled(1.0 / (double)this.F);
        return new ImmutableMatrix(a22);
    }

    @Override
    public double AIC() {
        double a2 = Math.log(this.L);
        return -2.0 * a2 + 2.0 * (double)this.nParams();
    }

    @Override
    public ARMAModel getFittedARMA() {
        int a2;
        double a3 = 1.0;
        int n = a2 = 0;
        while (n < this.E.phi.length) {
            a3 -= this.E.phi[a2];
            n = ++a2;
        }
        ARMAModel aRMAModel = new ARMAModel(a3 *= this.k, this.E.phi, this.E.theta, this.E.var);
        return aRMAModel;
    }

    @Override
    public double var() {
        return this.E.var;
    }

    public int nParams() {
        return this.E.p() + this.E.q() + 1;
    }

    private static RealScalarFunction b(final int a2, final int a3, double[] a4) {
        final int a5 = Math.max(a2, a3);
        final int a6 = a4.length;
        double[][] dArrayArray = new double[2][];
        dArrayArray[0] = R.rep(0.0, a5);
        dArrayArray[1] = a4;
        final double[] a7 = DoubleUtils.concat(dArrayArray);
        final int a8 = a7.length;
        return new RealScalarFunction(){

            @Override
            public int dimensionOfDomain() {
                return a3 + a2 + 1;
            }
            {
                2 a22;
            }

            @Override
            public int dimensionOfRange() {
                return 1;
            }

            @Override
            public double evaluate(double ... params) {
                int a23;
                double d2;
                Estimators a32 = new Estimators(params, a2, a3, null);
                double a4 = a32.var;
                if (d2 < 0.0) {
                    return Double.MAX_VALUE;
                }
                double[] a52 = new double[a8];
                int n = a23 = 0;
                while (n < a6) {
                    int a62;
                    int a72 = a5 + a23;
                    double[] a82 = new double[a2];
                    double[] a9 = new double[a3];
                    if (a2 > 0) {
                        int n2 = a62 = 0;
                        while (n2 < a2) {
                            a82[a62] = a7[a72 - a62 - 1];
                            n2 = ++a62;
                        }
                    }
                    if (a3 > 0) {
                        int n3 = a62 = 0;
                        while (n3 < a3) {
                            a9[a62] = a52[a72 - a62 - 1];
                            n3 = ++a62;
                        }
                    }
                    double a10 = FunctionOps.dotProduct(a32.phi, a82) + FunctionOps.dotProduct(a32.theta, a9);
                    a52[a72] = a7[a72] - a10;
                    n = ++a23;
                }
                double a22 = FunctionOps.dotProduct(a52, a52);
                double a11 = (double)a6 * Math.log(a4) + a22 / a4;
                return a11;
            }
        };
    }

    @Override
    public double AICC() {
        double a2 = Math.log(this.L);
        return -2.0 * a2 + 2.0 * (double)this.nParams() * (double)this.F / (double)(this.F - this.nParams() - 1);
    }

    private UnivariateRealFunction b(final int a2) {
        ConditionalSumOfSquares a3;
        final double[] a4 = a2 <= a3.E.p() ? a3.E.phi : a3.E.theta;
        return new UnivariateRealFunction(){
            {
                3 a22;
            }

            @Override
            public double evaluate(double x) {
                int a23;
                int a3;
                double a42 = 2.0 * Math.cos((double)a2 * x);
                int n = a3 = 1;
                while (n <= a4.length) {
                    a42 -= 2.0 * a4[a3 - 1] * Math.cos((double)a2 * x - x);
                    n = ++a3;
                }
                double a22 = 1.0;
                int n2 = a23 = 0;
                while (n2 < a4.length) {
                    a22 += a4[a23] * a4[a23];
                    a22 -= 2.0 * a4[a23] * Math.cos(x);
                    n2 = ++a23;
                }
                int n3 = a23 = 1;
                while (n3 <= a4.length) {
                    int n4 = a23 + 1;
                    while (n4 <= a4.length) {
                        int a5;
                        a22 += 2.0 * a4[a23 - 1] * a4[a5 - 1] * Math.cos((double)(a23 - a5) * x);
                        n4 = ++a5;
                    }
                    n3 = ++a23;
                }
                return a42 / a22;
            }
        };
    }

    public String toString() {
        return this.getFittedARMA().toString();
    }

    private static class Estimators {
        public final double[] phi;
        public final double var;
        public final double[] theta;

        public int q() {
            Estimators a2;
            return a2.theta.length;
        }

        private Estimators(double[] a2, int a3, int a4) {
            Estimators a5;
            a5.phi = Arrays.copyOfRange(a2, 0, a3);
            a5.theta = Arrays.copyOfRange(a2, a3, a3 + a4);
            a5.var = a2[a3 + a4];
        }

        public /* synthetic */ Estimators(double[] a2, int a3, int a4, 1 a5) {
            a6(a2, a3, a4);
            Estimators a6;
        }

        public int p() {
            Estimators a2;
            return a2.phi.length;
        }
    }
}

