/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma.VARXModel;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma.VECM;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class VECMTransitory
extends VECM {
    public VECMTransitory(VARXModel varx) {
        super(VECMTransitory.fromVarx(varx));
    }

    public VECMTransitory(Matrix pi, Matrix[] gamma, Matrix psi, Matrix sigma) {
        this(new DenseVector(R.rep(0.0, pi.nRows())), pi, gamma, psi, sigma);
    }

    public static VECMTransitory fromVarx(VARXModel varx) {
        int a2;
        Matrix[] a3 = varx.p() > 1 ? new Matrix[varx.p() - 1] : null;
        Matrix a4 = new DenseMatrix(varx.dimension(), varx.dimension()).ZERO();
        int n = a2 = varx.p() - 1;
        while (true) {
            if (n < 1) break;
            a4 = a4.minus(varx.AR(a2 + 1));
            a3[a2 - 1] = new DenseMatrix(a4);
            n = --a2;
        }
        Matrix a22 = a4.minus(varx.AR(1)).opposite().minus(a4.ONE());
        return new VECMTransitory(varx.mu(), a22, a3, varx.psi(), varx.sigma());
    }

    public VECMTransitory(Vector mu, Matrix pi, Matrix[] gamma, Matrix psi, Matrix sigma) {
        super(mu, pi, gamma, psi, sigma);
    }

    public VECMTransitory(VECMTransitory that) {
        super(that);
    }
}

