/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma.ARMAXModel;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma.VECMLongrun;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma.VECMTransitory;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class VARXModel
extends ARMAXModel {
    public VARXModel(Matrix[] phi, Matrix psi) {
        this(new DenseVector(R.rep(0.0, phi[0].nRows())), phi, psi);
    }

    public VARXModel(VECMLongrun vecm) {
        this(VARXModel.b(vecm));
    }

    public VARXModel(Vector mu, Matrix[] phi, Matrix psi, Matrix sigma) {
        super(mu, phi, null, psi, sigma);
    }

    public VARXModel(Vector mu, Matrix[] phi, Matrix psi) {
        this(mu, phi, psi, (Matrix)new DenseMatrix(mu.size(), mu.size()).ONE());
    }

    private static VARXModel b(VECMTransitory a2) {
        int a3;
        Matrix[] matrixArray = new Matrix[a2.p()];
        Matrix[] a4 = matrixArray;
        matrixArray[0] = a2.pi().ONE().add(a2.pi()).add(a2.gamma(1));
        int n = a3 = 1;
        while (true) {
            if (n >= a2.p() - 1) break;
            a4[a3] = a2.gamma(a3 + 1).minus(a2.gamma(a3));
            n = ++a3;
        }
        a4[a2.p() - 1] = a2.gamma(a2.p() - 1).opposite();
        VARXModel vARXModel = new VARXModel((Vector)a2.mu(), a4, (Matrix)a2.psi(), (Matrix)a2.sigma());
        return vARXModel;
    }

    public VARXModel(VECMTransitory vecm) {
        this(VARXModel.b(vecm));
    }

    private static VARXModel b(VECMLongrun a2) {
        int a3;
        Matrix[] matrixArray = new Matrix[a2.p()];
        Matrix[] a4 = matrixArray;
        matrixArray[0] = a2.gamma(1);
        a4[0] = a4[0].add(a4[0].ONE());
        int n = a3 = 1;
        while (true) {
            if (n >= a2.p() - 1) break;
            a4[a3] = a2.gamma(a3 + 1).minus(a2.gamma(a3));
            n = ++a3;
        }
        a4[a2.p() - 1] = a2.pi().minus(a2.gamma(a2.p() - 1));
        VARXModel vARXModel = new VARXModel((Vector)a2.mu(), a4, (Matrix)a2.psi(), (Matrix)a2.sigma());
        return vARXModel;
    }

    public VARXModel(Matrix[] phi, Matrix psi, Matrix sigma) {
        this((Vector)new DenseVector(R.rep(0.0, phi[0].nRows())), phi, psi, sigma);
    }

    public VARXModel(VARXModel that) {
        super(that);
    }
}

