/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma.ARMAModel;

public class LinearRepresentation {
    public static final int DEFAULT_NUMBER_OF_LAGS = 15;
    public final ImmutableMatrix[] PSI;

    public LinearRepresentation(ARMAModel model, int nLags) {
        int a2;
        int a3 = model.p();
        int a4 = model.q();
        ImmutableMatrix a5 = model.AR(0);
        Matrix[] matrixArray = new Matrix[nLags + 1];
        Matrix[] a6 = matrixArray;
        matrixArray[0] = a5.ONE();
        int n = a2 = 1;
        while (n <= nLags) {
            int a7;
            a6[a2] = a2 > a4 ? a5.ZERO() : model.MA(a2);
            int n2 = a7 = 1;
            while (n2 <= Math.min(a3, a2)) {
                a6[a2] = a6[a2].add(model.AR(a7).multiply(a6[a2 - a7]));
                n2 = ++a7;
            }
            n = ++a2;
        }
        this.PSI = new ImmutableMatrix[a6.length];
        int n3 = a2 = 0;
        while (n3 < a6.length) {
            this.PSI[a2] = new ImmutableMatrix(a6[a2]);
            n3 = ++a2;
        }
    }

    public LinearRepresentation(ARMAModel model) {
        this(model, 15);
    }
}

