/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.linearsystem.LUSolver;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.SuanShuUtils;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.AutoCovarianceFunction;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.arima.ARIMAModel;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma.LinearRepresentation;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;
import java.util.Arrays;

public class AutoCovariance
extends AutoCovarianceFunction {
    public final int nLags;
    private final int i;
    private LinearRepresentation G;
    private final int F;
    private final int k;
    private final int L;
    private final Matrix[] E;

    private Vector b(Matrix[] a2) {
        int a3;
        AutoCovariance a4;
        DenseVector a5 = new DenseVector(a4.k);
        int a6 = 0;
        int n = a3 = 0;
        while (n <= a4.L) {
            int a7;
            int n2 = a7 = 1;
            while (n2 <= a4.F) {
                int a8;
                int n3 = a8 = 1;
                while (n3 <= a4.F) {
                    a5.set(++a6, a2[a3].get(a7, a8));
                    n3 = ++a8;
                }
                n2 = ++a7;
            }
            n = ++a3;
        }
        return a5;
    }

    private int b(int a2, int a3, int a4, boolean a5) {
        AutoCovariance a6;
        if (a5) {
            return a6.b(a2, a4, a3, false);
        }
        int a7 = a2 * a6.F * a6.F;
        a7 += (a3 - 1) * a6.F;
        return a7 += a4;
    }

    public AutoCovariance(ARIMAModel model, int nLags) {
        SuanShuUtils.assertArgument(model.mu().norm() == 0.0, "EX<sub>t</sub> = 0", new Object[0]);
        this.nLags = nLags;
        this.F = model.dimension();
        this.L = model.p();
        this.i = model.q();
        this.k = (this.L + 1) * this.F * this.F;
        this.G = new LinearRepresentation(model.getArma(), nLags);
        Matrix[] a2 = this.b(model, (Matrix)model.sigma(), nLags);
        Vector a3 = this.b(a2);
        Matrix a4 = this.b(model);
        Vector a5 = new LUSolver(a4).solve(a3);
        this.E = this.b(model, (Matrix)model.sigma(), a5.toArray());
    }

    private Matrix[] b(ARIMAModel a2, Matrix a3, double[] a4) {
        Object[] a22;
        int a5;
        AutoCovariance a6;
        Matrix[] a7 = new Matrix[a6.nLags + 1];
        int n = a5 = 0;
        while (n <= a6.L) {
            a22 = Arrays.copyOfRange(a4, a5 * a6.F * a6.F, (a5 + 1) * a6.F * a6.F);
            a7[a5] = new DenseMatrix((double[])a22, a6.F, a6.F);
            n = ++a5;
        }
        int n2 = a5 = a6.L + 1;
        while (n2 <= a6.nLags) {
            int a8;
            a7[a5] = new DenseMatrix(a6.F, a6.F).ZERO();
            int n3 = a8 = 1;
            while (n3 <= a6.L) {
                Matrix a9 = a2.AR(a8).multiply(a7[a5 - a8]);
                a7[a5] = a7[a5].add(a9);
                n3 = ++a8;
            }
            a22 = a6.G.PSI;
            int n4 = a5;
            while (n4 <= a6.i) {
                int a10;
                Matrix a11 = a2.MA(a10).multiply(a3).multiply(a22[a10 - a5].t());
                a7[a5] = a7[a5].add(a11);
                n4 = ++a10;
            }
            n2 = ++a5;
        }
        return a7;
    }

    public Matrix evaluate(double i2) {
        if (i2 < 0.0) {
            return this.evaluate(-i2).t();
        }
        if (i2 <= (double)this.nLags) {
            return this.E[(int)i2];
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = this.nLags;
        throw new RuntimeException(String.format("the maximum number of lags available is %d", objectArray));
    }

    @Override
    public Matrix evaluate(double x1, double x2) {
        return this.evaluate(Math.abs(x2 - x1));
    }

    private Matrix[] b(ARIMAModel a2, Matrix a3, int a4) {
        int a5;
        AutoCovariance a6;
        Matrix[] a7 = new Matrix[a6.L + 1];
        ImmutableMatrix[] a8 = a6.G.PSI;
        int n = a5 = 0;
        while (n <= a6.L) {
            a7[a5] = new DenseMatrix(a6.F, a6.F).ZERO();
            int n2 = a5;
            while (n2 <= a6.i) {
                int a9;
                Matrix a10 = a2.MA(a9).multiply(a3).multiply(a8[a9 - a5].t());
                a7[a5] = a7[a5].add(a10);
                n2 = ++a9;
            }
            n = ++a5;
        }
        return a7;
    }

    private Matrix b(ARIMAModel a2) {
        int a3;
        AutoCovariance a4;
        DenseMatrix a5 = new DenseMatrix(a4.k, a4.k).ZERO();
        int a6 = 0;
        int n = a3 = 0;
        while (n <= a4.L) {
            int a7;
            int n2 = a7 = 1;
            while (n2 <= a4.F) {
                int a8;
                int n3 = a8 = 1;
                while (n3 <= a4.F) {
                    int a9;
                    ++a6;
                    int n4 = a9 = 0;
                    while (n4 <= a4.L) {
                        int a10;
                        boolean a11 = a9 > a3;
                        int a12 = Math.abs(a3 - a9);
                        Matrix a13 = a11 ? a2.AR(a9).t() : a2.AR(a9);
                        int n5 = a10 = 1;
                        while (n5 <= a4.F) {
                            double a14 = a9 == 0 ? a13.get(a7, a10) : -a13.get(a7, a10);
                            int a15 = a4.b(a12, a10, a8, a11);
                            a5.set(a6, a15, a5.get(a6, a15) + a14);
                            n5 = ++a10;
                        }
                        n4 = ++a9;
                    }
                    n3 = ++a8;
                }
                n2 = ++a7;
            }
            n = ++a3;
        }
        return a5;
    }
}

