/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.arima.ARIMAXModel;
import com.numericalmethod.suanshu.vector.doubles.Vector;

public class ARMAXModel
extends ARIMAXModel {
    public ARMAXModel(Vector mu, Matrix[] phi, Matrix[] theta, Matrix psi, Matrix sigma) {
        super(mu, phi, 0, theta, psi, sigma);
    }

    public ARMAXModel(ARMAXModel that) {
        super(that);
    }

    public Matrix armaxMeanNoIntercept(Matrix arLags, Matrix maLags, Vector exVar) {
        int a2;
        Matrix a3 = new DenseMatrix(R.rep(0.0, this.dimension()), this.dimension(), 1);
        Matrix a4 = new DenseMatrix(R.rep(0.0, this.dimension()), this.dimension(), 1);
        DenseMatrix a5 = new DenseMatrix(this.psi().multiply(exVar));
        if (this.p() > 0) {
            int n = a2 = 1;
            while (n <= this.p()) {
                a3 = a3.add(this.AR(a2).multiply(new DenseMatrix(arLags.getColumn(a2).toArray(), this.dimension(), 1)));
                n = ++a2;
            }
        }
        if (this.q() > 0) {
            int n = a2 = 1;
            while (n <= this.q()) {
                a4 = a4.add(this.MA(a2).multiply(new DenseMatrix(maLags.getColumn(a2).toArray(), this.dimension(), 1)));
                n = ++a2;
            }
        }
        Matrix a6 = a3.add(a4).add(a5);
        return a6;
    }

    public ARMAXModel(Matrix[] phi, Matrix[] theta, Matrix psi) {
        super(phi, 0, theta, psi);
    }

    public ARMAXModel(Matrix[] phi, Matrix[] theta, Matrix psi, Matrix sigma) {
        super(phi, 0, theta, psi, sigma);
    }

    public ARMAXModel(Vector mu, Matrix[] phi, Matrix[] theta, Matrix psi) {
        super(mu, phi, 0, theta, psi);
    }

    public Matrix armaxMean(Matrix arLags, Matrix maLags, Vector exVar) {
        Matrix a2 = this.armaxMeanNoIntercept(arLags, maLags, exVar);
        return new DenseMatrix(this.mu()).add(a2);
    }

    public ARMAXModel(com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arma.ARMAXModel model) {
        super(model);
    }
}

