/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.stationaryprocess.arma;

import com.numericalmethod.suanshu.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.misc.R;
import com.numericalmethod.suanshu.stats.timeseries.linear.multivariate.arima.ARIMAModel;
import com.numericalmethod.suanshu.vector.doubles.Vector;
import com.numericalmethod.suanshu.vector.doubles.dense.DenseVector;

public class ARMAModel
extends ARIMAModel {
    public ARMAModel(Matrix[] phi, Matrix[] theta) {
        this(phi, theta, new DenseMatrix(phi != null ? phi[0].nRows() : theta[0].nRows(), phi != null ? phi[0].nRows() : theta[0].nRows()).ONE());
    }

    public ARMAModel(ARMAModel that) {
        super(that);
    }

    public ARMAModel(Matrix[] phi, Matrix[] theta, Matrix sigma) {
        this((Vector)new DenseVector(R.rep(0.0, sigma.nRows())), phi, theta, sigma);
    }

    public ARMAModel(Vector mu, Matrix[] phi, Matrix[] theta) {
        this(mu, phi, theta, (Matrix)new DenseMatrix(mu.size(), mu.size()).ONE());
    }

    public Matrix armaMeanNoIntercept(Matrix arLags, Matrix maLags) {
        int a2;
        Matrix a3 = new DenseMatrix(R.rep(0.0, this.dimension()), this.dimension(), 1);
        Matrix a4 = new DenseMatrix(R.rep(0.0, this.dimension()), this.dimension(), 1);
        if (this.p() > 0) {
            int n = a2 = 1;
            while (n <= this.p()) {
                a3 = a3.add(this.AR(a2).multiply(new DenseMatrix(arLags.getColumn(a2).toArray(), this.dimension(), 1)));
                n = ++a2;
            }
        }
        if (this.q() > 0) {
            int n = a2 = 1;
            while (n <= this.q()) {
                a4 = a4.add(this.MA(a2).multiply(new DenseMatrix(maLags.getColumn(a2).toArray(), this.dimension(), 1)));
                n = ++a2;
            }
        }
        Matrix a5 = a3.add(a4);
        return a5;
    }

    public ARMAModel(Vector mu, Matrix[] phi, Matrix[] theta, Matrix sigma) {
        super(mu, phi, 0, theta, sigma);
    }

    public ARMAModel(com.numericalmethod.suanshu.stats.timeseries.linear.univariate.stationaryprocess.arma.ARMAModel model) {
        super(model);
    }

    public Matrix armaMean(Matrix arLags, Matrix maLags) {
        Matrix a2 = this.armaMeanNoIntercept(arLags, maLags);
        return new DenseMatrix(this.mu()).add(a2);
    }
}

